/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.common;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.eaglei.model.EIURI;

public final class GsonHolder {
    public static final Gson Gson = new GsonBuilder().registerTypeAdapter((Type)((Object)EIURI.class), EIURIAdapter.Instance).create();

    private GsonHolder() {
    }

    private static final class EIURIAdapter
    implements JsonSerializer<EIURI>,
    JsonDeserializer<EIURI> {
        public static final EIURIAdapter Instance = new EIURIAdapter();
        private static final String NullInstanceString = new JsonNull().toString();

        private EIURIAdapter() {
        }

        @Override
        public JsonElement serialize(EIURI uri, Type type, JsonSerializationContext context) {
            if (uri == null) {
                return new JsonNull();
            }
            return new JsonPrimitive(uri.toString());
        }

        @Override
        public EIURI deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
            String strValue = element.getAsString();
            if (NullInstanceString.equals(strValue)) {
                return null;
            }
            return EIURI.create(strValue);
        }
    }
}

