/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.lucene;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;
import org.eaglei.lexical.lucene.LuceneUtils;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchProviderUtil;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.lucene.LuceneSearchIndexSchema;

public final class LuceneQueryBuilder
extends LuceneSearchIndexSchema {
    private static final Log logger = LogFactory.getLog(LuceneQueryBuilder.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    private final EIOntModel eagleiOntModel;
    private Analyzer analyzer;
    private QueryParser prefTextParser;
    private QueryParser textParser;

    public LuceneQueryBuilder(EIOntModel eagleiOntModel, Analyzer analyzer) throws IOException {
        assert (eagleiOntModel != null);
        assert (analyzer != null);
        this.eagleiOntModel = eagleiOntModel;
        this.analyzer = analyzer;
        this.textParser = new QueryParser(Version.LUCENE_30, "text", this.analyzer);
        this.prefTextParser = new QueryParser(Version.LUCENE_30, "pref_text", this.analyzer);
    }

    public Query createQuery(SearchRequest request) throws ParseException {
        SearchRequest.TypeBinding binding;
        EIURI typeURI;
        SearchRequest.Term term = request.getTerm();
        EIURI institution = request.getInstitution();
        BooleanQuery query2 = new BooleanQuery();
        PhraseQuery resourceFlagQuery = new PhraseQuery();
        resourceFlagQuery.add(new Term("resourceFlag", Boolean.TRUE.toString()));
        query2.add(resourceFlagQuery, BooleanClause.Occur.MUST);
        if (institution != null) {
            PhraseQuery institutionQuery = new PhraseQuery();
            institutionQuery.add(new Term("institution_uri", institution.toString()));
            query2.add(institutionQuery, BooleanClause.Occur.MUST);
        }
        if (term != null) {
            BooleanQuery termQuery = new BooleanQuery();
            query2.add(termQuery, BooleanClause.Occur.MUST);
            if (term.getQuery() != null) {
                Query strTextQuery = LuceneUtils.escapeIfInvalid(this.textParser, term.getQuery());
                termQuery.add(strTextQuery, BooleanClause.Occur.SHOULD);
                Query strPrefTextQuery = LuceneUtils.escapeIfInvalid(this.prefTextParser, term.getQuery());
                termQuery.add(strPrefTextQuery, BooleanClause.Occur.SHOULD);
            }
            if (term.getURI() != null) {
                EIURI uri = term.getURI();
                EIClass eiClass = this.eagleiOntModel.getClass(uri);
                if (eiClass != null) {
                    PhraseQuery typeQuery = new PhraseQuery();
                    typeQuery.add(new Term("inferredType", uri.toString()));
                    termQuery.add(typeQuery, BooleanClause.Occur.SHOULD);
                    StringBuilder sb = new StringBuilder();
                    boolean first = true;
                    for (String label : this.eagleiOntModel.getLabels(uri)) {
                        if (!first) {
                            sb.append(" ");
                        }
                        first = false;
                        sb.append(label);
                    }
                    Query strTextQuery = LuceneUtils.escapeIfInvalid(this.textParser, sb.toString());
                    termQuery.add(strTextQuery, BooleanClause.Occur.SHOULD);
                    Query strPrefTextQuery = LuceneUtils.escapeIfInvalid(this.prefTextParser, sb.toString());
                    termQuery.add(strPrefTextQuery, BooleanClause.Occur.SHOULD);
                }
                PhraseQuery propQuery = new PhraseQuery();
                propQuery.add(new Term("related", uri.toString()));
                termQuery.add(propQuery, BooleanClause.Occur.SHOULD);
            }
        }
        if ((typeURI = SearchProviderUtil.getType(request)) != null) {
            PhraseQuery typeQuery = new PhraseQuery();
            typeQuery.add(new Term("inferredType", typeURI.toString()));
            query2.add(typeQuery, BooleanClause.Occur.MUST);
        }
        if ((binding = request.getBinding()) != null) {
            Object constraint;
            for (EIURI prop : binding.getDataTypeProperties()) {
                constraint = binding.getDataTypeProperty(prop);
                QueryParser propParser = new QueryParser(Version.LUCENE_30, prop.toString(), this.analyzer);
                Query propQuery = propParser.parse((String)constraint);
                query2.add(propQuery, BooleanClause.Occur.MUST);
            }
            for (EIURI prop : binding.getObjectProperties()) {
                constraint = binding.getObjectProperty(prop);
                PhraseQuery propQuery = new PhraseQuery();
                propQuery.add(new Term(prop.toString() + "_uri", ((EIURI)constraint).toString()));
                query2.add(propQuery, BooleanClause.Occur.MUST);
            }
        }
        if (query2.clauses().isEmpty()) {
            MatchAllDocsQuery allDocsQuery = new MatchAllDocsQuery();
            query2.add(allDocsQuery, BooleanClause.Occur.MUST);
            return query2;
        }
        if (DEBUG) {
            logger.debug("Query: " + query2.toString());
        }
        return query2;
    }
}

