/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.lucene;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.store.Directory;
import org.eaglei.model.EIOntModel;
import org.eaglei.search.datagen.DataGenParams;
import org.eaglei.search.provider.lucene.LuceneGenerator;
import org.eaglei.search.provider.lucene.LuceneSearchProvider;
import org.eaglei.search.provider.lucene.LuceneSearchProviderProperties;
import org.eaglei.services.InstitutionRegistry;

public final class LuceneSearchProviderFactory {
    public static LuceneSearchProvider createProviderForGeneratedData(InstitutionRegistry institutionRegistry, EIOntModel eagleiOntModel, DataGenParams datagenParams) throws IOException {
        Analyzer analyzer = LuceneSearchProviderProperties.getAnalyzer();
        Directory dir = LuceneSearchProviderProperties.getDirectory();
        LuceneGenerator generator = new LuceneGenerator(eagleiOntModel, analyzer, dir);
        if (datagenParams == null) {
            generator.generate(LuceneSearchProviderFactory.getDefaultDataGenParams(institutionRegistry));
        } else {
            generator.generate(datagenParams);
        }
        return new LuceneSearchProvider(eagleiOntModel, dir, analyzer);
    }

    private static DataGenParams getDefaultDataGenParams(InstitutionRegistry institutionRegistry) {
        DataGenParams params = DataGenParams.createForAllInstitutions(institutionRegistry.getInstitutions());
        params.setCoreFacilityRange(1, 3);
        params.setResearchFacilityRange(0, 0);
        params.setMaterializeHierarchy(true);
        return params;
    }
}

