/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.services.repository;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.security.SecurityProvider;
import org.eaglei.security.Session;
import org.eaglei.services.InstitutionRegistry;
import org.eaglei.services.repository.RepositoryHttpConfig;

public final class RepositorySecurityProvider
implements SecurityProvider {
    private static final Log log = LogFactory.getLog(RepositorySecurityProvider.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    private final InstitutionRegistry institutionRegistry;
    private Map<String, Session> mapSessionIdToSession = new HashMap<String, Session>();
    private Map<String, HttpClient> mapSessionIdToHttpClient = new HashMap<String, HttpClient>();

    public RepositorySecurityProvider(InstitutionRegistry institutionRegistry) {
        this.institutionRegistry = institutionRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session logIn(String institutionId, String user, String password) {
        HttpClient userClient = RepositoryHttpConfig.createHttpClient(user, password);
        RepositoryHttpConfig repoConfig = this.institutionRegistry.getRepositoryHttpConfig(institutionId);
        if (repoConfig == null) {
            log.error("Unrecognized login institution id: " + institutionId);
            return null;
        }
        int status = 0;
        ResultSet results = null;
        String responseBody = null;
        GetMethod method = new GetMethod(repoConfig.getWhoamiUrl());
        try {
            if (isDebugEnabled) {
                log.debug("Authenticating user " + user + " at " + repoConfig.getWhoamiUrl());
            }
            status = userClient.executeMethod(method);
            responseBody = this.getStringFromInputStream(method.getResponseBodyAsStream());
            if (status != 200) {
                if (status == 404) {
                    log.error("Repo unavailable");
                } else if (status == 401) {
                    log.info("not authorized to get user information (login/whoami) : " + user);
                } else {
                    log.error(responseBody);
                }
                Session session = null;
                return session;
            }
            results = ResultSetFactory.fromXML(responseBody);
            if (results == null) {
                log.error("whoami response body is null");
                Session session = null;
                return session;
            }
            QuerySolution soln = results.nextSolution();
            Literal username = soln.getLiteral("username");
            if (username == null) {
                log.error("Could not authenticate, null username in response body: " + user);
                Session session = null;
                return session;
            }
            Resource userURI = soln.getResource("uri");
            if (userURI == null) {
                log.error("Could not authenticate, null uri in response body: " + user);
                Session session = null;
                return session;
            }
            if (isDebugEnabled) {
                log.debug("Authenticated user: " + username.getString() + " " + userURI.getURI());
            }
            String sessionId = UUID.randomUUID().toString();
            Session session = new Session(sessionId, institutionId, username.getString(), userURI.getURI());
            this.mapSessionIdToSession.put(sessionId, session);
            this.mapSessionIdToHttpClient.put(sessionId, userClient);
            Session session2 = session;
            return session2;
        }
        catch (Exception e2) {
            log.error("problem getting user info " + repoConfig.getWhoamiUrl() + " Message from repo: " + responseBody + "; Exception " + e2);
            Session session = null;
            return session;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logOut(String sessionId) {
        HttpMethodBase method = null;
        try {
            HttpClient client = this.mapSessionIdToHttpClient.get(sessionId);
            Session session = this.mapSessionIdToSession.get(sessionId);
            if (client == null) {
                return;
            }
            if (session == null) {
                return;
            }
            RepositoryHttpConfig repoConfig = this.institutionRegistry.getRepositoryHttpConfig(session.getInstitutionId());
            method = new PostMethod(repoConfig.getLogoutUrl());
            int status = 0;
            if (isDebugEnabled) {
                log.debug("Trying to logout at " + repoConfig.getLogoutUrl());
            }
            if ((status = client.executeMethod(method)) == 200) {
                if (isDebugEnabled) {
                    log.debug("logout succeded");
                }
            } else {
                log.info("Could not logout user: HTTP Status: " + status);
            }
        }
        catch (Exception e2) {
            log.error("Unexpected error during logout  " + e2);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
            this.mapSessionIdToHttpClient.remove(sessionId);
            this.mapSessionIdToSession.remove(sessionId);
        }
    }

    public HttpClient getUserHttpClient(String sessionId) {
        return this.mapSessionIdToHttpClient.get(sessionId);
    }

    private String getStringFromInputStream(InputStream in) throws IOException {
        StringWriter writer = new StringWriter();
        IOUtils.copy(in, writer, "UTF-8");
        return writer.toString();
    }

    @Override
    public Session getSession(String sessionId) {
        return this.mapSessionIdToSession.get(sessionId);
    }

    @Override
    public boolean isValid(String sessionId) {
        return this.getSession(sessionId) != null;
    }
}

