/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.services.repository;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.services.repository.SPARQLConstants;
import org.eaglei.services.repository.SPARQLOntConstants;

public class SPARQLQueryUtil
implements SPARQLOntConstants,
SPARQLConstants {
    private static final Log logger = LogFactory.getLog(SPARQLQueryUtil.class);

    public static EIEntity getStatusEntity(EIURI statusUri) {
        if (statusUri == null) {
            return EIEntity.NULL_ENTITY;
        }
        if ("http://eagle-i.org/ont/repo/1.0/WFS_Draft".equals(statusUri.toString())) {
            return DRAFT_ENTITY;
        }
        if ("http://eagle-i.org/ont/repo/1.0/WFS_Curation".equals(statusUri.toString())) {
            return CURATION_ENTITY;
        }
        if ("http://eagle-i.org/ont/repo/1.0/WFS_Published".equals(statusUri.toString())) {
            return PUBLISH_ENTITY;
        }
        if ("http://eagle-i.org/ont/repo/1.0/WFS_Withdrawn".equals(statusUri.toString())) {
            return WITHDRAW_ENTITY;
        }
        return EIEntity.NULL_ENTITY;
    }

    public static String getReferencedByQuery(EIURI resourceUri) {
        StringBuilder sparql2 = new StringBuilder();
        sparql2.append(SPARQLQueryUtil.namespaces());
        sparql2.append(SPARQLQueryUtil.selectClause());
        sparql2.append(SPARQLQueryUtil.commonPattern());
        sparql2.append(SPARQLQueryUtil.typePattern());
        sparql2.append(SPARQLQueryUtil.referencedByPattern(resourceUri));
        sparql2.append(SPARQLQueryUtil.closingClause());
        return sparql2.toString();
    }

    public static String referencedByPattern(EIURI resourceUri) {
        StringBuilder sparql2 = new StringBuilder();
        sparql2.append("?");
        sparql2.append("r_subject");
        sparql2.append(" ?anyPredicate <");
        sparql2.append(resourceUri.toString());
        sparql2.append("> . ");
        return sparql2.toString();
    }

    private static String namespaces() {
        StringBuilder namespaces = new StringBuilder();
        namespaces.append("PREFIX dcterms: <");
        namespaces.append("http://purl.org/dc/terms/");
        namespaces.append("> ");
        namespaces.append("PREFIX rdf: <");
        namespaces.append("http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        namespaces.append("> ");
        namespaces.append("PREFIX rdfs: <");
        namespaces.append("http://www.w3.org/2000/01/rdf-schema#");
        namespaces.append("> ");
        namespaces.append("PREFIX repo: <");
        namespaces.append("http://eagle-i.org/ont/repo/1.0/");
        namespaces.append("> ");
        return namespaces.toString();
    }

    private static String selectClause() {
        StringBuilder sparql2 = new StringBuilder();
        sparql2.append("SELECT DISTINCT ");
        sparql2.append("?anyPredicate ");
        for (String variable : resultSetVariables) {
            sparql2.append("?");
            sparql2.append(variable);
            sparql2.append(" ");
        }
        sparql2.append("WHERE {");
        return sparql2.toString();
    }

    private static String commonPattern() {
        StringBuilder sparql2 = new StringBuilder();
        sparql2.append("?");
        sparql2.append("r_subject");
        sparql2.append(" <http://www.w3.org/2000/01/rdf-schema#label> ?");
        sparql2.append("r_label");
        sparql2.append(" . ?");
        sparql2.append("r_subject");
        sparql2.append(" dcterms:created ?");
        sparql2.append("r_date");
        sparql2.append(" . ");
        return sparql2.toString();
    }

    private static String typePattern() {
        return "graph ?g{?r_subject a ?r_type} filter(?g != repo:NG_Inferred) . ";
    }

    public static String allTypesPattern(boolean excludeSomeTypes) {
        StringBuilder sparql2 = new StringBuilder();
        sparql2.append("?");
        sparql2.append("r_subject");
        sparql2.append(" a ?rt . ");
        sparql2.append("?rt <http://eagle-i.org/ont/app/1.0/inClassGroup> <http://eagle-i.org/ont/app/1.0/ClassGroup/resourceRoot> ");
        if (excludeSomeTypes) {
            sparql2.append("filter(?rt != <");
            sparql2.append("http://purl.obolibrary.org/obo/OBI_0000245");
            sparql2.append("> && ?rt != <");
            sparql2.append("http://xmlns.com/foaf/0.1/Person");
            sparql2.append(">) .");
        }
        return sparql2.toString();
    }

    private static String ownerRestrictionPattern(String user, boolean strictOwnerFilter) {
        StringBuilder sparql2 = new StringBuilder();
        if (strictOwnerFilter) {
            sparql2.append("?");
            sparql2.append("r_subject");
            sparql2.append(" repo:hasWorkflowOwner ?");
            sparql2.append("r_owner");
            sparql2.append(". FILTER(?");
            sparql2.append("r_owner");
            sparql2.append("= <");
        } else {
            sparql2.append("OPTIONAL {?");
            sparql2.append("r_subject");
            sparql2.append(" repo:hasWorkflowOwner ?");
            sparql2.append("r_owner");
            sparql2.append("} . FILTER(!bound(?");
            sparql2.append("r_owner");
            sparql2.append(") || ?");
            sparql2.append("r_owner");
            sparql2.append(" = <");
        }
        sparql2.append(user);
        sparql2.append(">) . ");
        return sparql2.toString();
    }

    private static String typeRestrictionPattern(EIURI classUri, boolean excludeSomeTypes) {
        StringBuilder sparql2 = new StringBuilder();
        if (!SPARQLQueryUtil.isNull(classUri)) {
            sparql2.append("?");
            sparql2.append("r_subject");
            sparql2.append(" a <");
            sparql2.append(classUri.toString());
            sparql2.append("> .");
        } else {
            sparql2.append(SPARQLQueryUtil.allTypesPattern(excludeSomeTypes));
        }
        return sparql2.toString();
    }

    private static String stateRestrictionPattern(EIURI state) {
        StringBuilder sparql2 = new StringBuilder();
        if (!SPARQLQueryUtil.isNull(state)) {
            sparql2.append("?");
            sparql2.append("r_subject");
            sparql2.append(" repo:hasWorkflowState <");
            sparql2.append(state.toString());
            sparql2.append("> . ?");
            sparql2.append("r_subject");
            sparql2.append(" repo:hasWorkflowState ?");
            sparql2.append("r_state");
            sparql2.append(" . ");
        } else {
            sparql2.append("OPTIONAL {?");
            sparql2.append("r_subject");
            sparql2.append(" repo:hasWorkflowState ?");
            sparql2.append("r_state");
            sparql2.append("} . ");
        }
        return sparql2.toString();
    }

    public static String labRestrictionPattern(EIURI lab) {
        StringBuilder sparql2 = new StringBuilder();
        if (!SPARQLQueryUtil.isNull(lab)) {
            sparql2.append("?");
            sparql2.append("r_subject");
            sparql2.append(" ?labProperty ?");
            sparql2.append("r_lab");
            sparql2.append(" . ?");
            sparql2.append("r_lab");
            sparql2.append(" <http://www.w3.org/2000/01/rdf-schema#label> ?");
            sparql2.append("r_labName");
            sparql2.append(" . ?labProperty <http://eagle-i.org/ont/app/1.0/inPropertyGroup> <http://eagle-i.org/ont/app/1.0/PropertyGroup/relatedLab> . filter(?");
            sparql2.append("r_lab");
            sparql2.append(" = <");
            sparql2.append(lab.toString());
            sparql2.append(">) . ");
        } else {
            sparql2.append("OPTIONAL {?");
            sparql2.append("r_subject");
            sparql2.append(" ?labProperty ?");
            sparql2.append("r_lab");
            sparql2.append(" . ?labProperty <http://eagle-i.org/ont/app/1.0/inPropertyGroup> <http://eagle-i.org/ont/app/1.0/PropertyGroup/relatedLab> . ?");
            sparql2.append("r_lab");
            sparql2.append(" a <");
            sparql2.append("http://purl.obolibrary.org/obo/ERO_0000001");
            sparql2.append("> . ?");
            sparql2.append("r_lab");
            sparql2.append(" <http://www.w3.org/2000/01/rdf-schema#label> ?");
            sparql2.append("r_labName");
            sparql2.append("} . ");
        }
        return sparql2.toString();
    }

    private static String closingClause() {
        return "} order by repo:upperCaseStr(?r_label)";
    }

    private static boolean isNull(EIURI uri) {
        return uri == null || uri.equals(EIURI.NULL_EIURI) || "".equals(uri.toString());
    }

    public static List<EIInstanceMinimal> createReferencedByInstances(EIOntModel ontModel, EIInstance objectInstance, ResultSet resultSet) {
        if (resultSet == null) {
            return Collections.EMPTY_LIST;
        }
        List<EIProperty> objInstProperties = ontModel.getProperties(objectInstance.getInstanceType().getURI());
        HashMap<EIURI, EIInstanceMinimal> instances = new HashMap<EIURI, EIInstanceMinimal>();
        ArrayList<EIInstanceMinimal> instanceList = new ArrayList<EIInstanceMinimal>();
        while (resultSet.hasNext()) {
            EIInstanceMinimal ei;
            QuerySolution solution = resultSet.next();
            if (!solution.contains("r_subject") || !solution.contains("r_type") || !solution.contains("r_label")) continue;
            EIURI instanceUri = SPARQLQueryUtil.getUriFromSolution(solution, "r_subject");
            EIURI instanceType = SPARQLQueryUtil.getUriFromSolution(solution, "r_type");
            String label = SPARQLQueryUtil.getStringFromSolution(solution, "r_label");
            if (SPARQLQueryUtil.safeGetClass(ontModel, instanceType) == null) continue;
            EIEntity instanceEntity = EIEntity.create(instanceUri, label);
            boolean inferredValue = false;
            EIURI referencePredicate = SPARQLQueryUtil.getUriFromSolution(solution, "anyPredicate");
            if (referencePredicate != EIURI.NULL_EIURI) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Referencing property: " + referencePredicate);
                }
                String referencePredicateStr = referencePredicate.toString();
                for (EIProperty objInstProperty : objInstProperties) {
                    String inverseProperty;
                    if (!(objInstProperty instanceof EIObjectProperty) || !referencePredicateStr.equals(inverseProperty = ((EIObjectProperty)objInstProperty).getInverseURI())) continue;
                    Set<EIEntity> values = objectInstance.getObjectProperty(objInstProperty.getEntity());
                    inferredValue = true;
                    if (values != null && values.contains(instanceEntity)) continue;
                    objectInstance.addObjectProperty(objInstProperty.getEntity(), instanceEntity);
                    if (!logger.isDebugEnabled()) break;
                    logger.debug("Inferred inverse property: " + objInstProperty.getEntity() + "   value: " + instanceEntity);
                    break;
                }
            }
            if (inferredValue) continue;
            if (!instances.containsKey(instanceUri)) {
                ei = SPARQLQueryUtil.createEmptyMinimal(ontModel, instanceType, instanceEntity);
                instances.put(instanceUri, ei);
                instanceList.add(ei);
                if (logger.isDebugEnabled()) {
                    logger.debug("Creating new EIInstance: " + ei);
                }
            } else {
                ei = (EIInstanceMinimal)instances.get(instanceUri);
                ei.addEIType(EIEntity.create(instanceType, ""));
                if (logger.isDebugEnabled()) {
                    logger.debug("Adding type: " + instanceType + " to existing EIInstance :" + ei);
                }
            }
            ei.setWFOwner(SPARQLQueryUtil.getEntityFromSolution(solution, "r_owner", "r_ownerName"));
            ei.setWFState(SPARQLQueryUtil.getEntityFromSolution(solution, "r_state", ""));
            ei.setCreationDate(SPARQLQueryUtil.getStringFromSolution(solution, "r_date"));
            ei.setLab(SPARQLQueryUtil.getEntityFromSolution(solution, "r_lab", "r_labName"));
        }
        return instanceList;
    }

    private static EIInstanceMinimal createEmptyMinimal(EIOntModel ontModel, EIURI typeUri, EIEntity instanceEntity) {
        if (instanceEntity == null) {
            return null;
        }
        EIClass instanceClass = SPARQLQueryUtil.safeGetClass(ontModel, typeUri);
        if (instanceClass == null) {
            return null;
        }
        String label = instanceClass.getEntity().getLabel();
        instanceClass.getEntity().setLabel(label);
        EIInstanceMinimal ei = EIInstanceMinimal.create(instanceClass.getEntity(), instanceEntity);
        return ei;
    }

    private static EIEntity getEntityFromSolution(QuerySolution solution, String uriVariable, String labelVariable) {
        if (solution.contains(uriVariable)) {
            EIURI uri = EIURI.create(solution.getResource(uriVariable).getURI());
            if ("r_state".equals(uriVariable)) {
                return SPARQLQueryUtil.getStatusEntity(uri);
            }
            String label = "<none>";
            if (solution.contains(labelVariable)) {
                label = solution.getLiteral(labelVariable).getString();
            }
            return EIEntity.create(uri, label);
        }
        return EIEntity.NULL_ENTITY;
    }

    private static EIURI getUriFromSolution(QuerySolution solution, String variable) {
        if (solution.contains(variable)) {
            return EIURI.create(solution.getResource(variable).getURI());
        }
        return EIURI.NULL_EIURI;
    }

    private static String getStringFromSolution(QuerySolution solution, String variable) {
        if (solution.contains(variable)) {
            return solution.getLiteral(variable).getString();
        }
        return "";
    }

    private static EIClass safeGetClass(EIOntModel ontModel, EIURI typeUri) {
        if (ontModel.isModelClassURI(typeUri.toString())) {
            return ontModel.getClass(typeUri);
        }
        return null;
    }
}

