/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.BranchEffectTracker;
import com.clarkparsia.pellet.IncrementalChangeTracker;
import com.clarkparsia.pellet.datatypes.DatatypeReasoner;
import com.clarkparsia.pellet.datatypes.DatatypeReasonerImpl;
import com.clarkparsia.pellet.datatypes.exceptions.DatatypeReasonerException;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.exceptions.UnrecognizedDatatypeException;
import com.clarkparsia.pellet.expressivity.Expressivity;
import com.clarkparsia.pellet.impl.SimpleBranchEffectTracker;
import com.clarkparsia.pellet.impl.SimpleIncrementalChangeTracker;
import com.clarkparsia.pellet.utils.MultiMapUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DefaultEdge;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.NodeMerge;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.RBox;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.tableau.branch.Branch;
import org.mindswap.pellet.tableau.cache.CachedNode;
import org.mindswap.pellet.tableau.cache.CachedNodeFactory;
import org.mindswap.pellet.tableau.cache.ConceptCache;
import org.mindswap.pellet.tableau.cache.ConceptCacheLRU;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.tableau.completion.SROIQIncStrategy;
import org.mindswap.pellet.tableau.completion.queue.BasicCompletionQueue;
import org.mindswap.pellet.tableau.completion.queue.CompletionQueue;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.queue.OptimizedBasicCompletionQueue;
import org.mindswap.pellet.tableau.completion.queue.QueueElement;
import org.mindswap.pellet.tbox.TBox;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Bool;
import org.mindswap.pellet.utils.CandidateSet;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.fsm.State;
import org.mindswap.pellet.utils.fsm.Transition;
import org.mindswap.pellet.utils.fsm.TransitionGraph;
import org.mindswap.pellet.utils.iterator.MultiListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ABox {
    public static final Logger log = Logger.getLogger(ABox.class.getName());
    private int anonCount = 0;
    public long satisfiabilityCount = 0L;
    public long consistencyCount = 0L;
    public int treeDepth = 0;
    protected final DatatypeReasoner dtReasoner;
    protected Map<ATermAppl, Node> nodes;
    protected List<ATermAppl> nodeList;
    private boolean changed = false;
    private boolean doExplanation;
    protected ConceptCache cache;
    private ABox lastCompletion;
    private boolean keepLastCompletion;
    private Clash lastClash;
    private boolean isComplete = false;
    private Clash clash;
    private Set<Clash> assertedClashes;
    private int branch;
    private List<Branch> branches;
    private List<NodeMerge> toBeMerged;
    private Map<ATermAppl, int[]> disjBranchStats;
    ABox sourceABox;
    private boolean initialized = false;
    private KnowledgeBase kb;
    public boolean rulesNotApplied;
    public boolean ranRete = false;
    public boolean useRete = false;
    private BranchEffectTracker branchEffects;
    private CompletionQueue completionQueue;
    private IncrementalChangeTracker incChangeTracker;
    private boolean syntacticUpdate = false;

    public ABox(KnowledgeBase kb) {
        this.kb = kb;
        this.nodes = new HashMap<ATermAppl, Node>();
        this.nodeList = new ArrayList<ATermAppl>();
        this.clash = null;
        this.assertedClashes = new HashSet<Clash>();
        this.doExplanation = false;
        this.dtReasoner = new DatatypeReasonerImpl();
        this.keepLastCompletion = false;
        this.clearCaches(true);
        this.setBranch(DependencySet.NO_BRANCH);
        this.branches = new ArrayList<Branch>();
        this.setDisjBranchStats(new HashMap<ATermAppl, int[]>());
        this.toBeMerged = new ArrayList<NodeMerge>();
        this.rulesNotApplied = true;
        this.branchEffects = PelletOptions.TRACK_BRANCH_EFFECTS ? new SimpleBranchEffectTracker() : null;
        this.completionQueue = PelletOptions.USE_COMPLETION_QUEUE ? (PelletOptions.USE_OPTIMIZED_BASIC_COMPLETION_QUEUE ? new OptimizedBasicCompletionQueue(this) : new BasicCompletionQueue(this)) : null;
        this.incChangeTracker = PelletOptions.USE_INCREMENTAL_CONSISTENCY ? new SimpleIncrementalChangeTracker() : null;
    }

    public ABox(ABox abox, ATermAppl extraIndividual, boolean copyIndividuals) {
        Object copy;
        this.kb = abox.kb;
        Timer timer = this.kb.timers.startTimer("cloneABox");
        this.rulesNotApplied = true;
        this.initialized = abox.initialized;
        this.setChanged(abox.isChanged());
        this.setAnonCount(abox.getAnonCount());
        this.cache = abox.cache;
        this.clash = abox.clash;
        this.dtReasoner = abox.dtReasoner;
        this.doExplanation = abox.doExplanation;
        this.setDisjBranchStats(abox.getDisjBranchStats());
        int extra = extraIndividual == null ? 0 : 1;
        int nodeCount = extra + (copyIndividuals ? abox.nodes.size() : 0);
        this.nodes = new HashMap<ATermAppl, Node>(nodeCount);
        this.nodeList = new ArrayList<ATermAppl>(nodeCount);
        this.branchEffects = PelletOptions.TRACK_BRANCH_EFFECTS ? (copyIndividuals ? abox.branchEffects.copy() : new SimpleBranchEffectTracker()) : null;
        if (PelletOptions.USE_COMPLETION_QUEUE) {
            if (copyIndividuals) {
                this.completionQueue = abox.completionQueue.copy();
                this.completionQueue.setABox(this);
            } else {
                this.completionQueue = PelletOptions.USE_OPTIMIZED_BASIC_COMPLETION_QUEUE ? new OptimizedBasicCompletionQueue(this) : new BasicCompletionQueue(this);
            }
        } else {
            this.completionQueue = null;
        }
        if (extraIndividual != null) {
            Individual n = new Individual(extraIndividual, this, null);
            n.setNominalLevel(Integer.MAX_VALUE);
            n.setConceptRoot(true);
            n.addType(ATermUtils.TOP, DependencySet.INDEPENDENT);
            this.nodes.put(extraIndividual, n);
            this.nodeList.add(extraIndividual);
            if (PelletOptions.COPY_ON_WRITE) {
                this.sourceABox = abox;
            }
        }
        if (copyIndividuals) {
            this.toBeMerged = abox.getToBeMerged();
            if (this.sourceABox == null) {
                for (int i = 0; i < nodeCount - extra; ++i) {
                    ATermAppl x = abox.nodeList.get(i);
                    Node node = abox.getNode(x);
                    copy = node.copyTo(this);
                    this.nodes.put(x, (Node)copy);
                    this.nodeList.add(x);
                }
                for (Node node : this.nodes.values()) {
                    node.updateNodeReferences();
                }
            }
        } else {
            this.toBeMerged = Collections.emptyList();
            this.sourceABox = null;
            this.initialized = false;
        }
        this.incChangeTracker = PelletOptions.USE_INCREMENTAL_CONSISTENCY ? (copyIndividuals ? abox.incChangeTracker.copy(this) : new SimpleIncrementalChangeTracker()) : null;
        this.assertedClashes = new HashSet<Clash>();
        for (Clash clash : abox.assertedClashes) {
            this.assertedClashes.add(clash.copyTo(this));
        }
        if (extraIndividual == null || copyIndividuals) {
            this.setBranch(abox.branch);
            this.branches = new ArrayList<Branch>(abox.branches.size());
            int n = abox.branches.size();
            for (int i = 0; i < n; ++i) {
                Branch branch = abox.branches.get(i);
                if (this.sourceABox == null) {
                    copy = branch.copyTo(this);
                    ((Branch)copy).setNodeCount(branch.getNodeCount() + extra);
                } else {
                    copy = branch;
                }
                this.branches.add((Branch)copy);
            }
        } else {
            this.setBranch(DependencySet.NO_BRANCH);
            this.branches = new ArrayList<Branch>();
        }
        timer.stop();
    }

    public ABox copy() {
        return this.copy(null, true);
    }

    public ABox copy(ATermAppl extraIndividual, boolean copyIndividuals) {
        return new ABox(this, extraIndividual, copyIndividuals);
    }

    public void copyOnWrite() {
        if (this.sourceABox == null) {
            return;
        }
        Timer t = this.kb.timers.startTimer("copyOnWrite");
        ArrayList<ATermAppl> currentNodeList = new ArrayList<ATermAppl>(this.nodeList);
        int currentSize = currentNodeList.size();
        int nodeCount = this.sourceABox.nodes.size();
        this.nodeList = new ArrayList<ATermAppl>(nodeCount + 1);
        this.nodeList.add((ATermAppl)currentNodeList.get(0));
        for (int i = 0; i < nodeCount; ++i) {
            ATermAppl x = this.sourceABox.nodeList.get(i);
            Node node = this.sourceABox.getNode(x);
            Node copyNode = node.copyTo(this);
            this.nodes.put(x, copyNode);
            this.nodeList.add(x);
        }
        if (currentSize > 1) {
            this.nodeList.addAll(currentNodeList.subList(1, currentSize));
        }
        for (Node node : this.nodes.values()) {
            if (!this.sourceABox.nodes.containsKey(node.getName())) continue;
            node.updateNodeReferences();
        }
        int n = this.branches.size();
        for (int i = 0; i < n; ++i) {
            Branch branch = this.branches.get(i);
            Branch copy = branch.copyTo(this);
            this.branches.set(i, copy);
            if (i >= this.sourceABox.getBranches().size()) {
                copy.setNodeCount(copy.getNodeCount() + nodeCount);
                continue;
            }
            copy.setNodeCount(copy.getNodeCount() + 1);
        }
        t.stop();
        this.sourceABox = null;
    }

    public void clearCaches(boolean clearSatCache) {
        this.lastCompletion = null;
        if (clearSatCache) {
            this.cache = new ConceptCacheLRU();
        }
    }

    public Bool getCachedSat(ATermAppl c) {
        return this.cache.getSat(c);
    }

    public ConceptCache getAllCached() {
        return this.cache;
    }

    public ConceptCache getCache() {
        return this.cache;
    }

    public CachedNode getCached(ATermAppl c) {
        if (ATermUtils.isNominal(c)) {
            return this.getIndividual(c.getArgument(0));
        }
        return (CachedNode)this.cache.get(c);
    }

    private void cache(Individual rootNode, ATermAppl c, boolean isConsistent) {
        if (!isConsistent) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Unsatisfiable: " + ATermUtils.toString(c));
                log.fine("Equivalent to TOP: " + ATermUtils.toString(ATermUtils.negate(c)));
            }
            this.cache.putSat(c, false);
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Cache " + rootNode.debugString());
            }
            this.cache.put(c, CachedNodeFactory.createNode(c, rootNode));
        }
    }

    public Bool isKnownSubClassOf(ATermAppl c1, ATermAppl c2) {
        Bool isSubClassOf = Bool.UNKNOWN;
        CachedNode cached = this.getCached(c1);
        if (cached != null) {
            isSubClassOf = this.isType(cached, c2);
        }
        return isSubClassOf;
    }

    public boolean isSubClassOf(ATermAppl c1, ATermAppl c2) {
        Bool isKnownSubClass;
        if (!this.doExplanation && (isKnownSubClass = this.isKnownSubClassOf(c1, c2)).isKnown()) {
            return isKnownSubClass.isTrue();
        }
        if (log.isLoggable(Level.FINE)) {
            long count = this.kb.timers.getTimer("subClassSat") == null ? 0L : this.kb.timers.getTimer("subClassSat").getCount();
            log.fine(count + ") Checking subclass [" + ATermUtils.toString(c1) + " " + ATermUtils.toString(c2) + "]");
        }
        ATermAppl notC2 = ATermUtils.negate(c2);
        ATermAppl c = ATermUtils.makeAnd(c1, notC2);
        Timer t = this.kb.timers.startTimer("subClassSat");
        boolean sub = !this.isSatisfiable(c, false);
        t.stop();
        if (log.isLoggable(Level.FINE)) {
            log.fine(" Result: " + sub + " (" + t.getLast() + "ms)");
        }
        return sub;
    }

    public boolean isSatisfiable(ATermAppl c) {
        boolean cacheModel = PelletOptions.USE_CACHING && (ATermUtils.isPrimitiveOrNegated(c) || PelletOptions.USE_ADVANCED_CACHING);
        return this.isSatisfiable(c, cacheModel);
    }

    public boolean isSatisfiable(ATermAppl c, boolean cacheModel) {
        CachedNode cached;
        if ((c = ATermUtils.normalize(c)).equals(ATermUtils.BOTTOM)) {
            return false;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Satisfiability for " + ATermUtils.toString(c));
        }
        if (cacheModel && (cached = this.getCached(c)) != null) {
            boolean needToCacheModel;
            boolean satisfiable = !cached.isBottom();
            boolean bl = needToCacheModel = cacheModel && !cached.isComplete();
            if (log.isLoggable(Level.FINE)) {
                log.fine("Cached sat for " + ATermUtils.toString(c) + " is " + satisfiable);
            }
            if (!(needToCacheModel || !satisfiable && this.doExplanation)) {
                return satisfiable;
            }
        }
        ++this.satisfiabilityCount;
        Timer t = this.kb.timers.startTimer("satisfiability");
        boolean isSat = this.isConsistent(SetUtils.<ATermAppl>emptySet(), c, cacheModel);
        t.stop();
        return isSat;
    }

    public CandidateSet<ATermAppl> getObviousInstances(ATermAppl c) {
        return this.getObviousInstances(c, this.kb.getIndividuals());
    }

    public CandidateSet<ATermAppl> getObviousInstances(ATermAppl c, Collection<ATermAppl> individuals) {
        c = ATermUtils.normalize(c);
        Set<ATermAppl> subs = this.kb.isClassified() && this.kb.getTaxonomy().contains(c) ? this.kb.getTaxonomy().getFlattenedSubs(c, false) : Collections.emptySet();
        subs.remove(ATermUtils.BOTTOM);
        CandidateSet<ATermAppl> cs = new CandidateSet<ATermAppl>();
        for (ATermAppl x : individuals) {
            Bool isType = this.isKnownType(x, c, subs);
            cs.add(x, isType);
        }
        return cs;
    }

    public void getObviousTypes(ATermAppl x, List<ATermAppl> types, List<ATermAppl> nonTypes) {
        assert (this.isComplete()) : "Initial consistency check has not been performed!";
        Individual pNode = this.getIndividual(x);
        pNode = !pNode.getMergeDependency(true).isIndependent() ? this.getIndividual(x) : pNode.getSame();
        pNode.getObviousTypes(types, nonTypes);
    }

    public CandidateSet<ATermAppl> getObviousSubjects(ATermAppl p, ATermAppl o) {
        CandidateSet<ATermAppl> candidates = new CandidateSet<ATermAppl>(this.kb.getIndividuals());
        this.getObviousSubjects(p, o, candidates);
        return candidates;
    }

    public void getSubjects(ATermAppl p, ATermAppl o, CandidateSet<ATermAppl> candidates) {
        Iterator<ATermAppl> i = candidates.iterator();
        while (i.hasNext()) {
            ATermAppl s = i.next();
            Bool hasObviousValue = this.hasObviousPropertyValue(s, p, o);
            candidates.update(s, hasObviousValue);
        }
    }

    public void getObviousSubjects(ATermAppl p, ATermAppl o, CandidateSet<ATermAppl> candidates) {
        Iterator<ATermAppl> i = candidates.iterator();
        while (i.hasNext()) {
            ATermAppl s = i.next();
            Bool hasObviousValue = this.hasObviousPropertyValue(s, p, o);
            if (hasObviousValue.isFalse()) {
                i.remove();
                continue;
            }
            candidates.update(s, hasObviousValue);
        }
    }

    public void getObviousObjects(ATermAppl p, CandidateSet<ATermAppl> candidates) {
        p = this.getRole(p).getInverse().getName();
        Iterator<ATermAppl> i = candidates.iterator();
        while (i.hasNext()) {
            ATermAppl s = i.next();
            Bool hasObviousValue = this.hasObviousObjectPropertyValue(s, p, null);
            candidates.update(s, hasObviousValue);
        }
    }

    public Bool isKnownType(ATermAppl x, ATermAppl c) {
        return this.isKnownType(x, c, SetUtils.<ATermAppl>emptySet());
    }

    public Bool isKnownType(ATermAppl x, ATermAppl c, Collection<ATermAppl> subs) {
        assert (this.isComplete()) : "Initial consistency check has not been performed!";
        Individual pNode = this.getIndividual(x);
        boolean isIndependent = true;
        if (pNode.isMerged()) {
            isIndependent = pNode.getMergeDependency(true).isIndependent();
            pNode = pNode.getSame();
        }
        Bool isType = this.isKnownType(pNode, c, subs);
        if (isIndependent) {
            return isType;
        }
        if (isType.isTrue()) {
            return Bool.UNKNOWN;
        }
        return isType;
    }

    public Bool isKnownType(Individual pNode, ATermAppl concept, Collection<ATermAppl> subs) {
        Bool isType = this.isType(pNode, concept);
        if (isType.isUnknown()) {
            Set<ATermAppl> concepts = ATermUtils.isAnd(concept) ? ATermUtils.listToSet((ATermList)concept.getArgument(0)) : SetUtils.singleton(concept);
            isType = Bool.TRUE;
            for (ATermAppl c : concepts) {
                Bool type = pNode.hasObviousType(c);
                if (type.isUnknown() && pNode.hasObviousType(subs)) {
                    type = Bool.TRUE;
                }
                if (type.isKnown()) {
                    isType = isType.and(type);
                    continue;
                }
                isType = Bool.UNKNOWN;
                Collection<ATermAppl> axioms = this.kb.getTBox().getAxioms(c);
                for (ATermAppl axiom : axioms) {
                    ATermAppl term = (ATermAppl)axiom.getArgument(1);
                    boolean equivalent = axiom.getAFun().equals(ATermUtils.EQCLASSFUN);
                    if (!equivalent) continue;
                    Iterator<ATermAppl> i = ATermUtils.isAnd(term) ? new MultiListIterator((ATermList)term.getArgument(0)) : Collections.singleton(term).iterator();
                    Bool knownType = Bool.TRUE;
                    while (i.hasNext() && knownType.isTrue()) {
                        term = i.next();
                        knownType = this.isKnownType(pNode, term, SetUtils.<ATermAppl>emptySet());
                    }
                    if (!knownType.isTrue()) continue;
                    isType = Bool.TRUE;
                    break;
                }
                if (!isType.isUnknown()) continue;
                return Bool.UNKNOWN;
            }
        }
        return isType;
    }

    private Bool isType(CachedNode pNode, ATermAppl c) {
        CachedNode cNode;
        Bool isType = Bool.UNKNOWN;
        ATermAppl notC = ATermUtils.negate(c);
        CachedNode cached = this.getCached(notC);
        if (cached != null && cached.isComplete()) {
            Timer t = this.kb.timers.startTimer("mergable");
            isType = this.cache.isMergable(this.kb, pNode, cached).not();
            t.stop();
        }
        if (PelletOptions.CHECK_NOMINAL_EDGES && isType.isUnknown() && (cNode = this.getCached(c)) != null) {
            isType = this.cache.checkNominalEdges(this.kb, pNode, cNode);
        }
        return isType;
    }

    public boolean isSameAs(ATermAppl ind1, ATermAppl ind2) {
        ATermAppl c = ATermUtils.makeValue(ind2);
        return this.isType(ind1, c);
    }

    public boolean isType(ATermAppl x, ATermAppl c) {
        c = ATermUtils.normalize(c);
        if (!this.doExplanation()) {
            Set<ATermAppl> subs;
            if (this.kb.isClassified() && this.kb.getTaxonomy().contains(c)) {
                subs = this.kb.getTaxonomy().getFlattenedSubs(c, false);
                subs.remove(ATermUtils.BOTTOM);
            } else {
                subs = SetUtils.emptySet();
            }
            Bool type = this.isKnownType(x, c, subs);
            if (type.isKnown()) {
                return type.isTrue();
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Checking type " + ATermUtils.toString(c) + " for individual " + ATermUtils.toString(x));
        }
        ATermAppl notC = ATermUtils.negate(c);
        Timer t = this.kb.timers.startTimer("isType");
        boolean isType = !this.isConsistent(SetUtils.singleton(x), notC, false);
        t.stop();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Type " + isType + " " + ATermUtils.toString(c) + " for individual " + ATermUtils.toString(x));
        }
        return isType;
    }

    public boolean isType(List<ATermAppl> inds, ATermAppl c) {
        ATermAppl notC;
        boolean isType;
        c = ATermUtils.normalize(c);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Checking type " + ATermUtils.toString(c) + " for individuals " + inds.size());
        }
        boolean bl = isType = !this.isConsistent(inds, notC = ATermUtils.negate(c), false);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Type " + isType + " " + ATermUtils.toString(c) + " for individuals " + inds.size());
        }
        return isType;
    }

    public Bool hasObviousPropertyValue(ATermAppl s, ATermAppl p, ATermAppl o) {
        Role prop = this.getRole(p);
        if (prop.isDatatypeRole()) {
            try {
                Object value = o == null ? null : this.dtReasoner.getValue(o);
                return this.hasObviousDataPropertyValue(s, p, value);
            }
            catch (UnrecognizedDatatypeException e2) {
                log.warning(String.format("Returning false for property value check (%s,%s,%s) due to datatype problem with input literal: %s", s, p, o, e2.getMessage()));
                return Bool.FALSE;
            }
            catch (InvalidLiteralException e3) {
                log.warning(String.format("Returning false for property value check (%s,%s,%s) due to problem with input literal: %s", s, p, o, e3.getMessage()));
                return Bool.FALSE;
            }
        }
        return this.hasObviousObjectPropertyValue(s, p, o);
    }

    public Bool hasObviousDataPropertyValue(ATermAppl s, ATermAppl p, Object value) {
        assert (this.isComplete()) : "Initial consistency check has not been performed!";
        Individual subj = this.getIndividual(s);
        Role prop = this.getRole(p);
        if (prop.isTop()) {
            return Bool.TRUE;
        }
        if (prop.isBottom()) {
            return Bool.FALSE;
        }
        boolean onlyPositive = false;
        if (!subj.getMergeDependency(true).isIndependent()) {
            onlyPositive = true;
            subj = this.getIndividual(s);
        } else {
            subj = subj.getSame();
        }
        Bool hasValue = subj.hasDataPropertyValue(prop, value);
        if (onlyPositive && hasValue.isFalse()) {
            return Bool.UNKNOWN;
        }
        return hasValue;
    }

    public Bool hasObviousObjectPropertyValue(ATermAppl s, ATermAppl p, ATermAppl o) {
        Role prop = this.getRole(p);
        if (prop.isTop()) {
            return Bool.TRUE;
        }
        if (prop.isBottom()) {
            return Bool.FALSE;
        }
        HashSet<ATermAppl> knowns = new HashSet<ATermAppl>();
        HashSet<ATermAppl> unknowns = new HashSet<ATermAppl>();
        this.getObjectPropertyValues(s, prop, knowns, unknowns, true);
        if (o == null) {
            if (!knowns.isEmpty()) {
                return Bool.TRUE;
            }
            if (!unknowns.isEmpty()) {
                return Bool.UNKNOWN;
            }
            return Bool.FALSE;
        }
        if (knowns.contains(o)) {
            return Bool.TRUE;
        }
        if (unknowns.contains(o)) {
            return Bool.UNKNOWN;
        }
        return Bool.FALSE;
    }

    public boolean hasPropertyValue(ATermAppl s, ATermAppl p, ATermAppl o) {
        Bool hasObviousValue = this.hasObviousPropertyValue(s, p, o);
        if (hasObviousValue.isKnown() && (hasObviousValue.isFalse() || !this.doExplanation())) {
            return hasObviousValue.isTrue();
        }
        ATermAppl c = null;
        c = o == null ? (this.kb.isDatatypeProperty(p) ? ATermUtils.makeMin((ATerm)p, 1, (ATerm)ATermUtils.TOP_LIT) : ATermUtils.makeMin((ATerm)p, 1, (ATerm)ATermUtils.TOP)) : ATermUtils.makeHasValue(p, o);
        boolean isType = this.isType(s, c);
        return isType;
    }

    public List<ATermAppl> getDataPropertyValues(ATermAppl s, Role role, ATermAppl datatype) {
        return this.getDataPropertyValues(s, role, datatype, false);
    }

    public List<ATermAppl> getDataPropertyValues(ATermAppl s, Role role, ATermAppl datatype, boolean onlyObvious) {
        assert (this.isComplete()) : "Initial consistency check has not been performed!";
        Individual subj = this.getIndividual(s);
        ArrayList<ATermAppl> values = new ArrayList<ATermAppl>();
        boolean isIndependent = true;
        if (subj.isMerged()) {
            isIndependent = subj.getMergeDependency(true).isIndependent();
            subj = subj.getSame();
        }
        EdgeList edges = subj.getRSuccessorEdges(role);
        for (int i = 0; i < edges.size(); ++i) {
            ATermAppl hasValue;
            Edge edge = edges.edgeAt(i);
            DependencySet ds = edge.getDepends();
            Literal literal = (Literal)edge.getTo();
            ATermAppl literalValue = literal.getTerm();
            if (literalValue == null) continue;
            if (datatype != null && !literal.hasType(datatype)) {
                try {
                    if (!this.dtReasoner.isSatisfiable(Collections.singleton(datatype), literal.getValue())) {
                        continue;
                    }
                }
                catch (DatatypeReasonerException e2) {
                    String msg = String.format("Unexpected datatype reasoner exception while fetching property values (%s,%s,%s): %s", s, role, datatype, e2.getMessage());
                    log.severe(msg);
                    throw new InternalReasonerException(msg);
                }
            }
            if (isIndependent && ds.isIndependent()) {
                values.add(literalValue);
                continue;
            }
            if (onlyObvious || !this.isType(s, hasValue = ATermUtils.makeHasValue(role.getName(), literalValue))) continue;
            values.add(literalValue);
        }
        return values;
    }

    public List<ATermAppl> getObviousDataPropertyValues(ATermAppl s, Role prop, ATermAppl datatype) {
        return this.getDataPropertyValues(s, prop, datatype, true);
    }

    public void getObjectPropertyValues(ATermAppl s, Role role, Set<ATermAppl> knowns, Set<ATermAppl> unknowns, boolean getSames) {
        assert (this.isComplete()) : "Initial consistency check has not been performed!";
        Individual subj = this.getIndividual(s);
        boolean isIndependent = true;
        if (subj.isMerged()) {
            isIndependent = subj.getMergeDependency(true).isIndependent();
            subj = subj.getSame();
        }
        if (role.isSimple()) {
            this.getSimpleObjectPropertyValues(subj, role, knowns, unknowns, getSames);
        } else if (!role.hasComplexSubRole()) {
            this.getTransitivePropertyValues(subj, role, knowns, unknowns, getSames, new HashMap<Individual, Set<Role>>(), true);
        } else {
            TransitionGraph<Role> tg = role.getFSM();
            this.getComplexObjectPropertyValues(subj, tg.getInitialState(), tg, knowns, unknowns, getSames, new HashMap<Individual, Set<State<Role>>>(), true);
        }
        if (!isIndependent) {
            unknowns.addAll(knowns);
            knowns.clear();
        }
    }

    void getSimpleObjectPropertyValues(Individual subj, Role role, Set<ATermAppl> knowns, Set<ATermAppl> unknowns, boolean getSames) {
        EdgeList edges = subj.getRNeighborEdges(role);
        for (int i = 0; i < edges.size(); ++i) {
            Edge edge = edges.edgeAt(i);
            DependencySet ds = edge.getDepends();
            Individual value = (Individual)edge.getNeighbor(subj);
            if (!value.isRootNominal()) continue;
            if (ds.isIndependent()) {
                if (getSames) {
                    this.getSames(value, knowns, unknowns);
                    continue;
                }
                knowns.add(value.getName());
                continue;
            }
            if (getSames) {
                this.getSames(value, unknowns, unknowns);
                continue;
            }
            unknowns.add(value.getName());
        }
    }

    void getTransitivePropertyValues(Individual subj, Role prop, Set<ATermAppl> knowns, Set<ATermAppl> unknowns, boolean getSames, Map<Individual, Set<Role>> visited, boolean isIndependent) {
        if (!MultiMapUtils.addAll(visited, subj, prop.getSubRoles())) {
            return;
        }
        EdgeList edges = subj.getRNeighborEdges(prop);
        for (int i = 0; i < edges.size(); ++i) {
            Role edgeRole;
            Edge edge = edges.edgeAt(i);
            DependencySet ds = edge.getDepends();
            Individual value = (Individual)edge.getNeighbor(subj);
            Role role = edgeRole = edge.getFrom().equals(subj) ? edge.getRole() : edge.getRole().getInverse();
            if (value.isRootNominal()) {
                if (isIndependent && ds.isIndependent()) {
                    if (getSames) {
                        this.getSames(value, knowns, unknowns);
                    } else {
                        knowns.add(value.getName());
                    }
                } else if (getSames) {
                    this.getSames(value, unknowns, unknowns);
                } else {
                    unknowns.add(value.getName());
                }
            }
            if (prop.isSimple()) continue;
            Set<Role> transRoles = SetUtils.intersection(edgeRole.getSuperRoles(), prop.getTransitiveSubRoles());
            for (Role transRole : transRoles) {
                this.getTransitivePropertyValues(value, transRole, knowns, unknowns, getSames, visited, isIndependent && ds.isIndependent());
            }
        }
    }

    void getComplexObjectPropertyValues(Individual subj, State<Role> st, TransitionGraph<Role> tg, Set<ATermAppl> knowns, Set<ATermAppl> unknowns, boolean getSames, HashMap<Individual, Set<State<Role>>> visited, boolean isIndependent) {
        if (!MultiMapUtils.add(visited, subj, st)) {
            return;
        }
        if (tg.isFinal(st) && subj.isRootNominal()) {
            log.fine("add " + subj);
            if (isIndependent) {
                if (getSames) {
                    this.getSames(subj, knowns, unknowns);
                } else {
                    knowns.add(subj.getName());
                }
            } else if (getSames) {
                this.getSames(subj, unknowns, unknowns);
            } else {
                unknowns.add(subj.getName());
            }
        }
        log.fine(subj.toString());
        for (Transition<Role> t : st.getTransitions()) {
            Role r = t.getName();
            EdgeList edges = subj.getRNeighborEdges(r);
            for (int i = 0; i < edges.size(); ++i) {
                Edge edge = edges.edgeAt(i);
                DependencySet ds = edge.getDepends();
                Individual value = (Individual)edge.getNeighbor(subj);
                this.getComplexObjectPropertyValues(value, t.getTo(), tg, knowns, unknowns, getSames, visited, isIndependent && ds.isIndependent());
            }
        }
    }

    public void getSames(Individual ind, Set<ATermAppl> knowns, Set<ATermAppl> unknowns) {
        knowns.add(ind.getName());
        boolean thisMerged = ind.isMerged() && !ind.getMergeDependency(true).isIndependent();
        for (Node other : ind.getMerged()) {
            boolean otherMerged;
            if (!other.isRootNominal()) continue;
            boolean bl = otherMerged = other.isMerged() && !other.getMergeDependency(true).isIndependent();
            if (thisMerged || otherMerged) {
                unknowns.add(other.getName());
                this.getSames((Individual)other, unknowns, unknowns);
                continue;
            }
            knowns.add(other.getName());
            this.getSames((Individual)other, knowns, unknowns);
        }
    }

    public boolean isConsistent() {
        boolean isConsistent = false;
        this.checkAssertedClashes();
        isConsistent = this.isConsistent(SetUtils.<ATermAppl>emptySet(), null, false);
        if (isConsistent) {
            this.cache.putSat(ATermUtils.BOTTOM, false);
            assert (this.isComplete()) : "ABox not marked complete!";
        }
        return isConsistent;
    }

    private boolean checkAssertedClashes() {
        Iterator<Clash> i = this.assertedClashes.iterator();
        while (i.hasNext()) {
            Clash clash = i.next();
            Node node = clash.getNode();
            ATermAppl term = clash.args != null ? (ATermAppl)clash.args[0] : null;
            boolean resolved = true;
            switch (clash.getClashType()) {
                case ATOMIC: {
                    ATermAppl negation = ATermUtils.negate(term);
                    resolved = !node.hasType(term) || !node.hasType(negation);
                    break;
                }
                case NOMINAL: {
                    resolved = !node.isSame(this.getNode(term));
                    break;
                }
                case INVALID_LITERAL: {
                    resolved = false;
                    break;
                }
                default: {
                    log.warning("Unexpected asserted clash type: " + clash);
                }
            }
            if (resolved) {
                i.remove();
                continue;
            }
            this.setClash(clash);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isConsistent(Collection<ATermAppl> individuals, ATermAppl c, boolean cacheModel) {
        boolean consistent;
        Timer t = this.kb.timers.startTimer("isConsistent");
        if (log.isLoggable(Level.FINE)) {
            if (c == null) {
                log.fine("ABox consistency for " + individuals.size() + " individuals");
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("[");
                Iterator<ATermAppl> it = individuals.iterator();
                for (int i = 0; i < 100 && it.hasNext(); ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(ATermUtils.toString(it.next()));
                }
                if (it.hasNext()) {
                    sb.append(", ...");
                }
                sb.append("]");
                log.fine("Consistency " + ATermUtils.toString(c) + " for " + individuals.size() + " individuals " + sb);
            }
        }
        Expressivity expr = this.kb.getExpressivityChecker().getExpressivityWith(c);
        boolean initialConsistencyCheck = c == null;
        boolean emptyConsistencyCheck = initialConsistencyCheck && this.isEmpty();
        boolean conceptSatisfiability = individuals.isEmpty() && (!initialConsistencyCheck || emptyConsistencyCheck);
        boolean hasNominal = expr.hasNominal() && !PelletOptions.USE_PSEUDO_NOMINALS;
        boolean canUseEmptyABox = conceptSatisfiability && !hasNominal;
        ATermAppl x = null;
        if (conceptSatisfiability) {
            x = ATermUtils.CONCEPT_SAT_IND;
            individuals = SetUtils.singleton(x);
        }
        if (emptyConsistencyCheck) {
            c = ATermUtils.TOP;
        }
        ABox abox = canUseEmptyABox ? this.copy(x, false) : (initialConsistencyCheck ? this : this.copy(x, true));
        for (ATermAppl ind : individuals) {
            abox.setSyntacticUpdate(true);
            abox.addType(ind, c);
            abox.setSyntacticUpdate(false);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Consistency check starts");
        }
        CompletionStrategy strategy = this.kb.chooseStrategy(abox, expr);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Strategy: " + strategy.getClass().getName());
        }
        Timer completionTimer = this.kb.timers.getTimer("complete");
        completionTimer.start();
        try {
            strategy.complete(expr);
        }
        finally {
            completionTimer.stop();
        }
        boolean bl = consistent = !abox.isClosed();
        if (x != null && c != null && cacheModel) {
            this.cache(abox.getIndividual(x), c, consistent);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Consistent: " + consistent + " Tree depth: " + abox.treeDepth + " Tree size: " + abox.getNodes().size() + " Time: " + t.getElapsed());
        }
        if (consistent) {
            if (initialConsistencyCheck && this.isEmpty()) {
                this.setComplete(true);
            }
        } else {
            this.lastClash = abox.getClash();
            if (log.isLoggable(Level.FINE)) {
                log.fine("Clash: " + abox.getClash().detailedString());
            }
            if (this.doExplanation && PelletOptions.USE_TRACING) {
                if (individuals.size() == 1) {
                    ATermAppl ind = individuals.iterator().next();
                    ATermAppl tempAxiom = ATermUtils.makeTypeAtom(ind, c);
                    Set<ATermAppl> explanationSet = this.getExplanationSet();
                    boolean removed = explanationSet.remove(tempAxiom);
                    if (!removed && log.isLoggable(Level.FINE)) {
                        log.fine("Explanation set is missing an axiom.\n\tAxiom: " + tempAxiom + "\n\tExplantionSet: " + explanationSet);
                    }
                }
                if (log.isLoggable(Level.FINE)) {
                    StringBuilder sb = new StringBuilder();
                    for (ATermAppl axiom : this.getExplanationSet()) {
                        sb.append("\n\t");
                        sb.append(ATermUtils.toString(axiom));
                    }
                    log.fine("Explanation: " + sb);
                }
            }
        }
        ++this.consistencyCount;
        this.lastCompletion = this.keepLastCompletion ? abox : null;
        t.stop();
        return consistent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isIncConsistent() {
        boolean consistent;
        assert (this.isComplete()) : "Initial consistency check has not been performed!";
        Timer incT = this.kb.timers.startTimer("isIncConsistent");
        Timer t = this.kb.timers.startTimer("isConsistent");
        this.lastCompletion = null;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Consistency check starts");
        }
        SROIQIncStrategy incStrategy = new SROIQIncStrategy(this);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Strategy: " + incStrategy.getClass().getName());
        }
        this.setComplete(false);
        Timer completionTimer = this.kb.timers.getTimer("complete");
        completionTimer.start();
        try {
            ((CompletionStrategy)incStrategy).complete(this.kb.getExpressivityChecker().getExpressivity());
        }
        finally {
            completionTimer.stop();
        }
        boolean bl = consistent = !this.isClosed();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Consistent: " + consistent + " Tree depth: " + this.treeDepth + " Tree size: " + this.getNodes().size());
        }
        if (!consistent) {
            this.lastClash = this.getClash();
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getClash().detailedString());
            }
        }
        ++this.consistencyCount;
        this.lastCompletion = this;
        t.stop();
        incT.stop();
        return consistent;
    }

    public EdgeList getInEdges(ATerm x) {
        return this.getNode(x).getInEdges();
    }

    public EdgeList getOutEdges(ATerm x) {
        Node node = this.getNode(x);
        if (node instanceof Literal) {
            return new EdgeList();
        }
        return ((Individual)node).getOutEdges();
    }

    public Individual getIndividual(ATerm x) {
        return (Individual)this.nodes.get(x);
    }

    public Literal getLiteral(ATerm x) {
        return (Literal)this.nodes.get(x);
    }

    public Node getNode(ATerm x) {
        return this.nodes.get(x);
    }

    public void addType(ATermAppl x, ATermAppl c) {
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeTypeAtom(x, c)) : DependencySet.INDEPENDENT;
        this.addType(x, c, ds);
    }

    public void addType(ATermAppl x, ATermAppl c, DependencySet ds) {
        c = ATermUtils.normalize(c);
        int remember = this.branch;
        this.setBranch(DependencySet.NO_BRANCH);
        Individual node = this.getIndividual(x);
        node.addType(c, ds, false);
        while (node.isMerged()) {
            ds = ds.union(node.getMergeDependency(false), this.doExplanation);
            node.addType(c, ds, !(node = (Individual)node.getMergedTo()).isMerged());
        }
        this.setBranch(remember);
    }

    public Edge addEdge(ATermAppl p, ATermAppl s, ATermAppl o, DependencySet ds) {
        Role role = this.getRole(p);
        Individual subj = this.getIndividual(s);
        Node obj = this.getNode(o);
        if (subj.isMerged() && obj.isMerged()) {
            throw new InternalReasonerException("Adding an edge with merged subject and object is not yet supported");
        }
        if (obj.isMerged()) {
            obj.addInEdge(new DefaultEdge(role, subj, obj, ds));
            ds = ds.union(obj.getMergeDependency(true), true);
            obj = obj.getSame();
        }
        DefaultEdge edge = new DefaultEdge(role, subj, obj, ds);
        Edge existingEdge = subj.getOutEdges().getExactEdge(subj, role, obj);
        if (existingEdge == null) {
            subj.addOutEdge(edge);
        } else if (!existingEdge.getDepends().isIndependent()) {
            subj.removeEdge(existingEdge);
            subj.addOutEdge(edge);
        }
        if (subj.isMerged()) {
            ds = ds.union(subj.getMergeDependency(true), true);
            subj = subj.getSame();
            edge = new DefaultEdge(role, subj, obj, ds);
            if (!subj.getOutEdges().hasEdge(edge)) {
                subj.addOutEdge(edge);
                obj.addInEdge(edge);
            }
        } else if (existingEdge == null) {
            obj.addInEdge(edge);
        } else if (!existingEdge.getDepends().isIndependent()) {
            obj.removeInEdge(existingEdge);
            obj.addInEdge(edge);
        }
        return edge;
    }

    public boolean removeNode(ATermAppl x) {
        return this.nodes.remove(x) != null;
    }

    public void removeType(ATermAppl x, ATermAppl c) {
        c = ATermUtils.normalize(c);
        Node node = this.getNode(x);
        node.removeType(c);
    }

    public Literal addLiteral(DependencySet ds) {
        return this.createLiteral(ATermUtils.makeLiteral(this.createUniqueName(false)), ds);
    }

    public Literal addLiteral(ATermAppl dataValue) {
        int remember = this.getBranch();
        this.setBranch(DependencySet.NO_BRANCH);
        Literal lit = this.addLiteral(dataValue, DependencySet.INDEPENDENT);
        this.setBranch(remember);
        return lit;
    }

    public Literal addLiteral(ATermAppl dataValue, DependencySet ds) {
        if (dataValue == null || !ATermUtils.isLiteral(dataValue)) {
            throw new InternalReasonerException("Invalid value to create a literal. Value: " + dataValue);
        }
        return this.createLiteral(dataValue, ds);
    }

    private Literal createLiteral(ATermAppl dataValue, DependencySet ds) {
        ATermAppl name;
        if (ATermUtils.NO_DATATYPE.equals(dataValue.getArgument(2))) {
            name = dataValue;
        } else {
            try {
                name = this.getDatatypeReasoner().getCanonicalRepresentation(dataValue);
            }
            catch (InvalidLiteralException e2) {
                String msg = String.format("Attempt to create an invalid literal (%s): %s", dataValue, e2.getMessage());
                if (PelletOptions.INVALID_LITERAL_AS_INCONSISTENCY) {
                    log.fine(msg);
                    name = dataValue;
                }
                log.severe(msg);
                throw new InternalReasonerException(msg, e2);
            }
            catch (UnrecognizedDatatypeException e3) {
                String msg = String.format("Attempt to create a literal with an unrecognized datatype (%s): %s", dataValue, e3.getMessage());
                log.severe(msg);
                throw new InternalReasonerException(msg, e3);
            }
        }
        Node node = this.getNode(name);
        if (node != null) {
            if (node instanceof Literal) {
                if (((Literal)node).getValue() == null && PelletOptions.USE_COMPLETION_QUEUE) {
                    QueueElement newElement = new QueueElement(node);
                    this.completionQueue.add(newElement, NodeSelector.LITERAL);
                }
                if (this.getBranch() >= 0 && PelletOptions.TRACK_BRANCH_EFFECTS) {
                    this.branchEffects.add(this.getBranch(), node.getName());
                }
                return (Literal)node;
            }
            throw new InternalReasonerException("Same term refers to both a literal and an individual: " + name);
        }
        int remember = this.branch;
        this.setBranch(DependencySet.NO_BRANCH);
        Literal lit = new Literal(name, dataValue, this, ds);
        lit.addType(ATermUtils.TOP_LIT, ds);
        this.setBranch(remember);
        this.nodes.put(name, lit);
        this.nodeList.add(name);
        if (lit.getValue() == null && PelletOptions.USE_COMPLETION_QUEUE) {
            QueueElement newElement = new QueueElement(lit);
            this.completionQueue.add(newElement, NodeSelector.LITERAL);
        }
        if (this.getBranch() >= 0 && PelletOptions.TRACK_BRANCH_EFFECTS) {
            this.branchEffects.add(this.getBranch(), lit.getName());
        }
        return lit;
    }

    public Individual addIndividual(ATermAppl x, DependencySet ds) {
        Individual ind = this.addIndividual(x, null, ds);
        if (this.getBranch() >= 0 && PelletOptions.TRACK_BRANCH_EFFECTS) {
            this.branchEffects.add(this.getBranch(), ind.getName());
        }
        return ind;
    }

    public Individual addFreshIndividual(Individual parent, DependencySet ds) {
        boolean isNominal = parent == null;
        ATermAppl name = this.createUniqueName(isNominal);
        Individual ind = this.addIndividual(name, parent, ds);
        if (isNominal) {
            ind.setNominalLevel(1);
        }
        return ind;
    }

    private Individual addIndividual(ATermAppl x, Individual parent, DependencySet ds) {
        if (this.nodes.containsKey(x)) {
            throw new InternalReasonerException("adding a node twice " + x);
        }
        this.setChanged(true);
        Individual n = new Individual(x, this, parent);
        this.nodes.put(x, n);
        this.nodeList.add(x);
        n.addType(ATermUtils.TOP, ds);
        if (this.getBranch() > 0 && PelletOptions.TRACK_BRANCH_EFFECTS) {
            this.branchEffects.add(this.getBranch(), n.getName());
        }
        return n;
    }

    public void addSame(ATermAppl x, ATermAppl y) {
        Individual ind1 = this.getIndividual(x);
        Individual ind2 = this.getIndividual(y);
        ATermAppl sameAxiom = ATermUtils.makeSameAs(x, y);
        if (PelletOptions.USE_INCREMENTAL_DELETION) {
            this.kb.getSyntacticAssertions().add(sameAxiom);
        }
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(sameAxiom) : DependencySet.INDEPENDENT;
        this.getToBeMerged().add(new NodeMerge(ind1, ind2, ds));
    }

    public void addDifferent(ATermAppl x, ATermAppl y) {
        Individual ind1 = this.getIndividual(x);
        Individual ind2 = this.getIndividual(y);
        ATermAppl diffAxiom = ATermUtils.makeDifferent(x, y);
        if (PelletOptions.USE_INCREMENTAL_DELETION) {
            this.kb.getSyntacticAssertions().add(diffAxiom);
        }
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(diffAxiom) : DependencySet.INDEPENDENT;
        int remember = this.branch;
        this.setBranch(DependencySet.NO_BRANCH);
        ind1.setDifferent(ind2, ds);
        this.setBranch(remember);
    }

    public void addAllDifferent(ATermList list) {
        ATermAppl allDifferent = ATermUtils.makeAllDifferent(list);
        ATermList outer = list;
        while (!outer.isEmpty()) {
            ATermList inner = outer.getNext();
            while (!inner.isEmpty()) {
                Individual ind1 = this.getIndividual(outer.getFirst());
                Individual ind2 = this.getIndividual(inner.getFirst());
                if (PelletOptions.USE_INCREMENTAL_DELETION) {
                    this.kb.getSyntacticAssertions().add(allDifferent);
                }
                DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(allDifferent) : DependencySet.INDEPENDENT;
                int remember = this.branch;
                this.setBranch(DependencySet.NO_BRANCH);
                ind1.setDifferent(ind2, ds);
                this.setBranch(remember);
                inner = inner.getNext();
            }
            outer = outer.getNext();
        }
    }

    public boolean isNode(ATerm x) {
        return this.getNode(x) != null;
    }

    public final ATermAppl createUniqueName(boolean isNominal) {
        ++this.anonCount;
        ATermAppl name = isNominal ? ATermUtils.makeAnonNominal(this.anonCount) : ATermUtils.makeAnon(this.anonCount);
        return name;
    }

    public final Collection<Node> getNodes() {
        return this.nodes.values();
    }

    public final List<ATermAppl> getNodeNames() {
        return this.nodeList;
    }

    public String toString() {
        return "[size: " + this.nodes.size() + " freeMemory: " + (double)Runtime.getRuntime().freeMemory() / 1000000.0 + "mb]";
    }

    public DatatypeReasoner getDatatypeReasoner() {
        return this.dtReasoner;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public void setComplete(boolean isComplete) {
        this.isComplete = isComplete;
    }

    public boolean isClosed() {
        return !PelletOptions.SATURATE_TABLEAU && this.clash != null;
    }

    public Clash getClash() {
        return this.clash;
    }

    public void setClash(Clash clash) {
        if (clash != null) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("CLSH: " + clash);
                if (clash.getDepends().max() > this.branch && this.branch != -1) {
                    log.severe("Invalid clash dependency " + clash + " > " + this.branch);
                }
            }
            if (this.branch == DependencySet.NO_BRANCH && clash.getDepends().getBranch() == DependencySet.NO_BRANCH) {
                this.assertedClashes.add(clash);
            }
            if (this.clash != null) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Clash was already set \nExisting: " + this.clash + "\nNew     : " + clash);
                }
                if (this.clash.getDepends().max() < clash.getDepends().max()) {
                    return;
                }
            }
        }
        this.clash = clash;
        if (PelletOptions.USE_INCREMENTAL_DELETION) {
            this.kb.getDependencyIndex().setClashDependencies(this.clash);
        }
    }

    public KnowledgeBase getKB() {
        return this.kb;
    }

    public Role getRole(ATerm r) {
        return this.kb.getRole(r);
    }

    public RBox getRBox() {
        return this.kb.getRBox();
    }

    public TBox getTBox() {
        return this.kb.getTBox();
    }

    public int getBranch() {
        return this.branch;
    }

    public void setBranch(int branch) {
        this.branch = branch;
    }

    public void incrementBranch() {
        if (PelletOptions.USE_COMPLETION_QUEUE) {
            this.completionQueue.incrementBranch(this.branch);
        }
        ++this.branch;
    }

    public boolean isInitialized() {
        return this.initialized && !this.kb.isChanged();
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public final boolean doExplanation() {
        return this.doExplanation;
    }

    public void setDoExplanation(boolean doExplanation) {
        this.doExplanation = doExplanation;
    }

    public void setExplanation(DependencySet ds) {
        this.lastClash = Clash.unexplained(null, ds);
    }

    public String getExplanation() {
        if (this.lastClash == null) {
            return "No inconsistency was found! There is no explanation generated.";
        }
        return this.lastClash.detailedString();
    }

    public Set<ATermAppl> getExplanationSet() {
        if (this.lastClash == null) {
            throw new RuntimeException("No explanation was generated!");
        }
        return this.lastClash.getDepends().getExplain();
    }

    public BranchEffectTracker getBranchEffectTracker() {
        if (this.branchEffects == null) {
            throw new NullPointerException();
        }
        return this.branchEffects;
    }

    public List<Branch> getBranches() {
        return this.branches;
    }

    public IncrementalChangeTracker getIncrementalChangeTracker() {
        if (this.incChangeTracker == null) {
            throw new NullPointerException();
        }
        return this.incChangeTracker;
    }

    public IndividualIterator getIndIterator() {
        return new IndividualIterator(this);
    }

    public void validate() {
        if (!PelletOptions.VALIDATE_ABOX) {
            return;
        }
        System.out.print("VALIDATING...");
        IndividualIterator n = this.getIndIterator();
        while (n.hasNext()) {
            Individual node = (Individual)n.next();
            if (node.isPruned()) continue;
            this.validate(node);
        }
    }

    void validateTypes(Individual node, List<ATermAppl> negatedTypes) {
        int n = negatedTypes.size();
        for (int i = 0; i < n; ++i) {
            ATermAppl notA;
            ATermAppl a = negatedTypes.get(i);
            if (a.getArity() == 0 || !node.hasType(notA = (ATermAppl)a.getArgument(0))) continue;
            if (!node.hasType(a)) {
                throw new InternalReasonerException("Invalid type found: " + node + " " + " " + a + " " + node.debugString() + " " + node.depends);
            }
            throw new InternalReasonerException("Clash found: " + node + " " + a + " " + node.debugString() + " " + node.depends);
        }
    }

    void validate(Individual node) {
        Edge edge;
        int e2;
        DependencySet ds;
        this.validateTypes(node, node.getTypes(0));
        this.validateTypes(node, node.getTypes(2));
        this.validateTypes(node, node.getTypes(1));
        this.validateTypes(node, node.getTypes(5));
        if (!node.isRoot()) {
            boolean validPred;
            EdgeList preds = node.getInEdges();
            boolean bl = validPred = preds.size() == 1 || preds.size() == 2 && preds.hasEdgeFrom(node);
            if (!validPred) {
                throw new InternalReasonerException("Invalid blockable node: " + node + " " + node.getInEdges());
            }
        } else if (node.isNominal()) {
            ATermAppl nominal = ATermUtils.makeValue(node.getName());
            if (!ATermUtils.isAnonNominal(node.getName()) && !node.hasType(nominal)) {
                throw new InternalReasonerException("Invalid nominal node: " + node + " " + node.getTypes());
            }
        }
        for (ATermAppl c : node.getDepends().keySet()) {
            ds = node.getDepends(c);
            if (ds.max() <= this.branch && (PelletOptions.USE_SMART_RESTORE || ds.getBranch() <= this.branch)) continue;
            throw new InternalReasonerException("Invalid ds found: " + node + " " + c + " " + ds + " " + this.branch);
        }
        for (Node ind : node.getDifferents()) {
            ds = node.getDifferenceDependency(ind);
            if (ds.max() > this.branch || ds.getBranch() > this.branch) {
                throw new InternalReasonerException("Invalid ds: " + node + " != " + ind + " " + ds);
            }
            if (ind.getDifferenceDependency(node) != null) continue;
            throw new InternalReasonerException("Invalid difference: " + node + " != " + ind + " " + ds);
        }
        EdgeList edges = node.getOutEdges();
        for (e2 = 0; e2 < edges.size(); ++e2) {
            edge = edges.edgeAt(e2);
            Node succ = edge.getTo();
            if (this.nodes.get(succ.getName()) != succ) {
                throw new InternalReasonerException("Invalid edge to a non-existing node: " + edge + " " + this.nodes.get(succ.getName()) + "(" + this.nodes.get(succ.getName()).hashCode() + ")" + succ + "(" + succ.hashCode() + ")");
            }
            if (!succ.getInEdges().hasEdge(edge)) {
                throw new InternalReasonerException("Invalid edge: " + edge);
            }
            if (succ.isMerged()) {
                throw new InternalReasonerException("Invalid edge to a removed node: " + edge + " " + succ.isMerged());
            }
            DependencySet ds2 = edge.getDepends();
            if (ds2.max() > this.branch || ds2.getBranch() > this.branch) {
                throw new InternalReasonerException("Invalid ds: " + edge + " " + ds2);
            }
            EdgeList allEdges = node.getEdgesTo(succ);
            if (allEdges.getRoles().size() == allEdges.size()) continue;
            throw new InternalReasonerException("Duplicate edges: " + allEdges);
        }
        edges = node.getInEdges();
        for (e2 = 0; e2 < edges.size(); ++e2) {
            edge = edges.edgeAt(e2);
            DependencySet ds3 = edge.getDepends();
            if (ds3.max() <= this.branch && ds3.getBranch() <= this.branch) continue;
            throw new InternalReasonerException("Invalid ds: " + edge + " " + ds3);
        }
    }

    public void printTree() {
        if (!PelletOptions.PRINT_ABOX) {
            return;
        }
        System.err.println("PRINTING... " + DependencySet.INDEPENDENT);
        for (Node node : this.nodes.values()) {
            if (!node.isRoot() || node instanceof Literal) continue;
            this.printNode((Individual)node, new HashSet<Individual>(), "   ");
        }
    }

    private void printNode(Individual node, Set<Individual> printed, String indent) {
        boolean printOnlyName = node.isNominal() && !printed.isEmpty();
        System.err.print(node);
        if (!printed.add(node)) {
            System.err.println();
            return;
        }
        if (node.isMerged()) {
            System.err.println(" -> " + node.getMergedTo() + " " + node.getMergeDependency(false));
            return;
        }
        if (node.isPruned()) {
            throw new InternalReasonerException("Pruned node: " + node);
        }
        System.err.print(" = ");
        for (int i = 0; i < 7; ++i) {
            for (ATermAppl c : node.getTypes(i)) {
                System.err.print(ATermUtils.toString(c));
                System.err.print(", ");
            }
        }
        System.err.println(node.getDifferents());
        if (printOnlyName) {
            return;
        }
        indent = indent + "  ";
        for (Edge edge : node.getOutEdges()) {
            Node succ = edge.getTo();
            EdgeList edges = node.getEdgesTo(succ);
            System.err.print(indent + "[");
            for (int e2 = 0; e2 < edges.size(); ++e2) {
                if (e2 > 0) {
                    System.err.print(", ");
                }
                System.err.print(edges.edgeAt(e2).getRole());
            }
            System.err.print("] ");
            if (succ instanceof Individual) {
                this.printNode((Individual)succ, printed, indent);
                continue;
            }
            System.err.println(" (Literal) " + succ.getName() + " " + succ.getTypes());
        }
    }

    public Clash getLastClash() {
        return this.lastClash;
    }

    public ABox getLastCompletion() {
        return this.lastCompletion;
    }

    public boolean isKeepLastCompletion() {
        return this.keepLastCompletion;
    }

    public void setKeepLastCompletion(boolean keepLastCompletion) {
        this.keepLastCompletion = keepLastCompletion;
    }

    public int size() {
        return this.nodes.size();
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public void setLastCompletion(ABox comp) {
        this.lastCompletion = comp;
    }

    protected void setSyntacticUpdate(boolean val) {
        this.syntacticUpdate = val;
    }

    protected boolean isSyntacticUpdate() {
        return this.syntacticUpdate;
    }

    public CompletionQueue getCompletionQueue() {
        return this.completionQueue;
    }

    public void reset() {
        Iterator<ATermAppl> i = this.nodeList.iterator();
        while (i.hasNext()) {
            ATermAppl nodeName = i.next();
            Node node = this.nodes.get(nodeName);
            if (!node.isRootNominal()) {
                i.remove();
                this.nodes.remove(nodeName);
                continue;
            }
            node.reset(false);
        }
        this.setComplete(false);
        this.setInitialized(false);
        this.setClash(null);
        this.setBranch(DependencySet.NO_BRANCH);
        this.branches = new ArrayList<Branch>();
        this.setDisjBranchStats(new HashMap<ATermAppl, int[]>());
        this.rulesNotApplied = true;
    }

    public void resetQueue() {
        for (Node node : this.nodes.values()) {
            node.reset(true);
        }
    }

    public int setAnonCount(int anonCount) {
        this.anonCount = anonCount;
        return this.anonCount;
    }

    public int getAnonCount() {
        return this.anonCount;
    }

    public void setDisjBranchStats(Map<ATermAppl, int[]> disjBranchStats) {
        this.disjBranchStats = disjBranchStats;
    }

    public Map<ATermAppl, int[]> getDisjBranchStats() {
        return this.disjBranchStats;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public List<NodeMerge> getToBeMerged() {
        return this.toBeMerged;
    }
}

