/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import aterm.ATermAppl;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.Collection;
import java.util.HashSet;
import org.mindswap.pellet.jena.JenaUtils;
import org.mindswap.pellet.jena.vocabulary.OWL2;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.TaxonomyNode;
import org.mindswap.pellet.utils.TaxonomyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaxonomyExtractor {
    private Taxonomy<ATermAppl> taxonomy;
    private Model model;
    private boolean includeIndividuals;

    public TaxonomyExtractor(Taxonomy<ATermAppl> taxonomy) {
        this.taxonomy = taxonomy;
        this.includeIndividuals = false;
    }

    public void setIncludeIndividuals(boolean includeIndividuals) {
        this.includeIndividuals = includeIndividuals;
    }

    public Model extractModel() {
        if (this.model == null) {
            this.model = this.createExtractedModel();
        }
        return this.model;
    }

    private Model createExtractedModel() {
        Model model = ModelFactory.createDefaultModel();
        HashSet<ATermAppl> processedEquivalentClasses = new HashSet<ATermAppl>();
        for (TaxonomyNode<ATermAppl> taxonomyNode : this.taxonomy.getNodes()) {
            if (processedEquivalentClasses.contains(taxonomyNode.getName())) continue;
            processedEquivalentClasses.addAll(taxonomyNode.getEquivalents());
            for (ATermAppl aClass : taxonomyNode.getEquivalents()) {
                Collection individuals;
                model.add(TaxonomyExtractor.classAssertion(model, aClass));
                for (TaxonomyNode<ATermAppl> superNode : taxonomyNode.getSupers()) {
                    model.add(TaxonomyExtractor.subClassOfAssertion(model, aClass, superNode.getName()));
                }
                if (taxonomyNode.getEquivalents().size() > 1) {
                    for (ATermAppl equivalentClass : taxonomyNode.getEquivalents()) {
                        if (equivalentClass.equals(aClass)) continue;
                        model.add(TaxonomyExtractor.equivalentClassAssertion(model, aClass, equivalentClass));
                    }
                }
                if (!this.includeIndividuals || (individuals = (Collection)taxonomyNode.getDatum(TaxonomyUtils.INSTANCES_KEY)) == null || individuals.isEmpty()) continue;
                for (ATermAppl individual : individuals) {
                    model.add(TaxonomyExtractor.typeAssertion(model, individual, aClass));
                }
            }
        }
        return model;
    }

    private static Statement typeAssertion(Model model, ATermAppl individual, ATermAppl type) {
        Resource individualResource = TaxonomyExtractor.createResource(model, individual);
        Property typeProperty = RDF.type;
        Resource typeResource = TaxonomyExtractor.createResource(model, type);
        return model.createStatement(individualResource, typeProperty, typeResource);
    }

    private static Statement classAssertion(Model model, ATermAppl aClass) {
        Resource classResource = TaxonomyExtractor.createResource(model, aClass);
        Property typeProperty = RDF.type;
        Resource owlClassResource = OWL2.Class;
        return model.createStatement(classResource, typeProperty, owlClassResource);
    }

    private static Statement subClassOfAssertion(Model model, ATermAppl subClass, ATermAppl superClass) {
        Resource subClassResource = TaxonomyExtractor.createResource(model, subClass);
        Property subClassOfProperty = RDFS.subClassOf;
        Resource superClassResource = TaxonomyExtractor.createResource(model, superClass);
        return model.createStatement(subClassResource, subClassOfProperty, superClassResource);
    }

    private static Statement equivalentClassAssertion(Model model, ATermAppl firstClass, ATermAppl secondClass) {
        Resource firstClassResource = TaxonomyExtractor.createResource(model, firstClass);
        Property equivalentClassProperty = OWL2.equivalentClass;
        Resource secondClassResource = TaxonomyExtractor.createResource(model, secondClass);
        return model.createStatement(firstClassResource, equivalentClassProperty, secondClassResource);
    }

    private static Resource createResource(Model model, ATermAppl term) {
        return JenaUtils.makeResource(term, model);
    }
}

