/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion;

import aterm.ATermAppl;
import java.util.Iterator;
import java.util.List;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.tableau.blocking.Blocking;
import org.mindswap.pellet.tableau.blocking.OptimizedDoubleBlocking;
import org.mindswap.pellet.tableau.completion.SROIQStrategy;
import org.mindswap.pellet.utils.ATermUtils;

public class SHOIQStrategy
extends SROIQStrategy {
    public SHOIQStrategy(ABox abox) {
        super(abox, new OptimizedDoubleBlocking());
    }

    public SHOIQStrategy(ABox abox, Blocking blocking) {
        super(abox, blocking);
    }

    void applyAllValues(Individual x, ATermAppl av, DependencySet ds) {
        ATermAppl p = (ATermAppl)av.getArgument(0);
        ATermAppl c = (ATermAppl)av.getArgument(1);
        Role s = this.abox.getRole(p);
        if (s.isTop() && s.isObjectRole()) {
            this.applyAllValuesTop(av, c, ds);
            return;
        }
        EdgeList edges = x.getRNeighborEdges(s);
        for (int e2 = 0; e2 < edges.size(); ++e2) {
            Edge edgeToY = edges.edgeAt(e2);
            Node y = edgeToY.getNeighbor(x);
            DependencySet finalDS = ds.union(edgeToY.getDepends(), this.abox.doExplanation());
            if (this.abox.doExplanation()) {
                Role edgeRole = edgeToY.getRole();
                DependencySet subDS = s.getExplainSubOrInv(edgeRole);
                finalDS = finalDS.union(subDS.getExplain(), true);
            }
            this.applyAllValues(x, s, y, c, finalDS);
            if (!x.isMerged()) continue;
            return;
        }
        if (!s.isSimple()) {
            for (Role r : s.getTransitiveSubRoles()) {
                ATermAppl allRC = ATermUtils.makeAllValues(r.getName(), c);
                edges = x.getRNeighborEdges(r);
                for (int e3 = 0; e3 < edges.size(); ++e3) {
                    Edge edgeToY = edges.edgeAt(e3);
                    Node y = edgeToY.getNeighbor(x);
                    DependencySet finalDS = ds.union(edgeToY.getDepends(), this.abox.doExplanation());
                    if (this.abox.doExplanation()) {
                        finalDS = finalDS.union(r.getExplainTransitive().getExplain(), true);
                        finalDS = finalDS.union(s.getExplainSubOrInv(edgeToY.getRole()), true);
                    }
                    this.applyAllValues(x, r, y, allRC, finalDS);
                    if (!x.isMerged()) continue;
                    return;
                }
            }
        }
    }

    void applyAllValues(Individual subj, Role pred, Node obj, DependencySet ds) {
        List<ATermAppl> allValues = subj.getTypes(3);
        int size = allValues.size();
        Iterator<ATermAppl> i = allValues.iterator();
        while (i.hasNext()) {
            ATermAppl av = i.next();
            ATermAppl p = (ATermAppl)av.getArgument(0);
            ATermAppl c = (ATermAppl)av.getArgument(1);
            Role s = this.abox.getRole(p);
            if (s.isTop() && s.isObjectRole()) {
                this.applyAllValuesTop(av, c, ds);
                continue;
            }
            if (pred.isSubRoleOf(s)) {
                DependencySet finalDS = ds.union(subj.getDepends(av), this.abox.doExplanation());
                if (this.abox.doExplanation()) {
                    finalDS = finalDS.union(s.getExplainSubOrInv(pred).getExplain(), true);
                }
                this.applyAllValues(subj, s, obj, c, finalDS);
                if (s.isTransitive()) {
                    ATermAppl allRC = ATermUtils.makeAllValues(s.getName(), c);
                    finalDS = ds.union(subj.getDepends(av), this.abox.doExplanation());
                    if (this.abox.doExplanation()) {
                        finalDS = finalDS.union(s.getExplainTransitive().getExplain(), true);
                    }
                    this.applyAllValues(subj, s, obj, allRC, finalDS);
                }
            }
            if (size == allValues.size()) continue;
            i = allValues.iterator();
            size = allValues.size();
        }
    }
}

