/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import aterm.ATermAppl;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.TaxonomyNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaxonomyUtils {
    public static final Object INSTANCES_KEY = new Object();
    public static final Object SUPER_EXPLANATION_KEY = new Object();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean addSuperExplanation(Taxonomy<ATermAppl> t, ATermAppl sub, ATermAppl sup, Set<ATermAppl> explanation) {
        HashSet<Set<ATermAppl>> explanations;
        HashMap<ATermAppl, HashSet<Set<ATermAppl>>> map = (HashMap<ATermAppl, HashSet<Set<ATermAppl>>>)t.getDatum(sub, SUPER_EXPLANATION_KEY);
        if (map == null) {
            if (!t.contains(sub)) throw new RuntimeException(sub + " is an unknown class!");
            map = new HashMap<ATermAppl, HashSet<Set<ATermAppl>>>();
            t.putDatum(sub, SUPER_EXPLANATION_KEY, map);
            explanations = null;
        } else {
            explanations = (HashSet<Set<ATermAppl>>)map.get(sup);
        }
        if (explanations != null) return explanations.add(explanation);
        explanations = new HashSet<Set<ATermAppl>>();
        map.put(sup, explanations);
        return explanations.add(explanation);
    }

    public static void clearSuperExplanation(Taxonomy<ATermAppl> t, ATermAppl c) {
        t.removeDatum(c, SUPER_EXPLANATION_KEY);
    }

    public static void clearAllInstances(Taxonomy<ATermAppl> t) {
        for (TaxonomyNode<ATermAppl> node : t.getNodes()) {
            node.removeDatum(INSTANCES_KEY);
        }
    }

    public static Set<ATermAppl> getAllInstances(Taxonomy<ATermAppl> t, ATermAppl c) {
        Iterator<Object> i = t.depthFirstDatumOnly(c, INSTANCES_KEY);
        if (!i.hasNext()) {
            throw new RuntimeException(c + " is an unknown class!");
        }
        HashSet instances = new HashSet();
        do {
            Set current;
            if ((current = (Set)i.next()) == null) continue;
            instances.addAll(current);
        } while (i.hasNext());
        return Collections.unmodifiableSet(instances);
    }

    public static Set<ATermAppl> getDirectInstances(Taxonomy<ATermAppl> t, ATermAppl c) {
        Set instances = (Set)t.getDatum(c, INSTANCES_KEY);
        if (instances == null) {
            if (t.contains(c)) {
                return Collections.emptySet();
            }
            throw new RuntimeException(c + " is an unknown class!");
        }
        return Collections.unmodifiableSet(instances);
    }

    public static Set<Set<ATermAppl>> getSuperExplanations(Taxonomy<ATermAppl> t, ATermAppl sub, ATermAppl sup) {
        Map map = (Map)t.getDatum(sub, SUPER_EXPLANATION_KEY);
        if (map == null) {
            return null;
        }
        Set explanations = (Set)map.get(sup);
        if (explanations == null) {
            return null;
        }
        return Collections.unmodifiableSet(explanations);
    }

    public static <T> Set<Set<T>> getTypes(Taxonomy<T> t, Object ind, boolean directOnly) {
        HashSet<Set<T>> types = new HashSet<Set<T>>();
        Iterator<Map.Entry<Set<T>, Object>> i = t.datumEquivalentsPair(INSTANCES_KEY);
        while (i.hasNext()) {
            Map.Entry<Set<T>, Object> pair = i.next();
            Set instances = (Set)pair.getValue();
            if (instances == null || !instances.contains(ind)) continue;
            types.add(pair.getKey());
            if (directOnly) continue;
            T a = pair.getKey().iterator().next();
            types.addAll(t.getSupers(a));
        }
        return Collections.unmodifiableSet(types);
    }

    public static boolean isType(Taxonomy<ATermAppl> t, ATermAppl ind, ATermAppl c) {
        Iterator<Object> i = t.depthFirstDatumOnly(c, INSTANCES_KEY);
        if (!i.hasNext()) {
            throw new RuntimeException(c + " is an unknown class!");
        }
        do {
            Set instances;
            if ((instances = (Set)i.next()) == null || !instances.contains(ind)) continue;
            return true;
        } while (i.hasNext());
        return false;
    }
}

