/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.util.Assert;

public class RootBeanDefinition
extends AbstractBeanDefinition {
    private final Set<Member> externallyManagedConfigMembers = Collections.synchronizedSet(new HashSet());
    private final Set<String> externallyManagedInitMethods = Collections.synchronizedSet(new HashSet());
    private final Set<String> externallyManagedDestroyMethods = Collections.synchronizedSet(new HashSet());
    boolean isFactoryMethodUnique;
    volatile Object resolvedConstructorOrFactoryMethod;
    volatile Object[] resolvedConstructorArguments;
    volatile Object[] preparedConstructorArguments;
    volatile boolean constructorArgumentsResolved = false;
    volatile Boolean beforeInstantiationResolved;
    boolean postProcessed = false;
    final Object postProcessingLock = new Object();

    public RootBeanDefinition() {
    }

    public RootBeanDefinition(Class beanClass) {
        this.setBeanClass(beanClass);
    }

    @Deprecated
    public RootBeanDefinition(Class beanClass, boolean singleton) {
        this.setBeanClass(beanClass);
        this.setSingleton(singleton);
    }

    @Deprecated
    public RootBeanDefinition(Class beanClass, int autowireMode) {
        this.setBeanClass(beanClass);
        this.setAutowireMode(autowireMode);
    }

    public RootBeanDefinition(Class beanClass, int autowireMode, boolean dependencyCheck) {
        this.setBeanClass(beanClass);
        this.setAutowireMode(autowireMode);
        if (dependencyCheck && this.getResolvedAutowireMode() != 3) {
            this.setDependencyCheck(1);
        }
    }

    @Deprecated
    public RootBeanDefinition(Class beanClass, MutablePropertyValues pvs) {
        super(null, pvs);
        this.setBeanClass(beanClass);
    }

    @Deprecated
    public RootBeanDefinition(Class beanClass, MutablePropertyValues pvs, boolean singleton) {
        super(null, pvs);
        this.setBeanClass(beanClass);
        this.setSingleton(singleton);
    }

    public RootBeanDefinition(Class beanClass, ConstructorArgumentValues cargs, MutablePropertyValues pvs) {
        super(cargs, pvs);
        this.setBeanClass(beanClass);
    }

    public RootBeanDefinition(String beanClassName) {
        this.setBeanClassName(beanClassName);
    }

    public RootBeanDefinition(String beanClassName, ConstructorArgumentValues cargs, MutablePropertyValues pvs) {
        super(cargs, pvs);
        this.setBeanClassName(beanClassName);
    }

    public RootBeanDefinition(RootBeanDefinition original) {
        this((BeanDefinition)original);
    }

    RootBeanDefinition(BeanDefinition original) {
        super(original);
        if (original instanceof RootBeanDefinition) {
            this.isFactoryMethodUnique = ((RootBeanDefinition)original).isFactoryMethodUnique;
        }
    }

    public String getParentName() {
        return null;
    }

    public void setParentName(String parentName) {
        if (parentName != null) {
            throw new IllegalArgumentException("Root bean cannot be changed into a child bean with parent reference");
        }
    }

    public void setUniqueFactoryMethodName(String name) {
        Assert.hasText(name, "Factory method name must not be empty");
        this.setFactoryMethodName(name);
        this.isFactoryMethodUnique = true;
    }

    public boolean isFactoryMethod(Method candidate) {
        return candidate != null && candidate.getName().equals(this.getFactoryMethodName());
    }

    public Method getResolvedFactoryMethod() {
        Object candidate = this.resolvedConstructorOrFactoryMethod;
        return candidate instanceof Method ? (Method)candidate : null;
    }

    public void registerExternallyManagedConfigMember(Member configMember) {
        this.externallyManagedConfigMembers.add(configMember);
    }

    public boolean isExternallyManagedConfigMember(Member configMember) {
        return this.externallyManagedConfigMembers.contains(configMember);
    }

    public void registerExternallyManagedInitMethod(String initMethod) {
        this.externallyManagedInitMethods.add(initMethod);
    }

    public boolean isExternallyManagedInitMethod(String initMethod) {
        return this.externallyManagedInitMethods.contains(initMethod);
    }

    public void registerExternallyManagedDestroyMethod(String destroyMethod) {
        this.externallyManagedDestroyMethods.add(destroyMethod);
    }

    public boolean isExternallyManagedDestroyMethod(String destroyMethod) {
        return this.externallyManagedDestroyMethods.contains(destroyMethod);
    }

    public RootBeanDefinition cloneBeanDefinition() {
        return new RootBeanDefinition(this);
    }

    public boolean equals(Object other) {
        return this == other || other instanceof RootBeanDefinition && super.equals(other);
    }

    public String toString() {
        return "Root bean: " + super.toString();
    }
}

