package org.eaglei.network.actions;

import static org.spin.tools.Util.guardNotNull;

import java.io.IOException;

import org.apache.log4j.Logger;
import org.eaglei.search.provider.SearchCountRequest;
import org.eaglei.search.provider.SearchCounts;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResultSet;

/**
 * 
 * @author Clint Gilbert
 * 
 * Jul 13, 2010
 *
 * Center for Biomedical Informatics (CBMI)
 * @link https://cbmi.med.harvard.edu/
 *
 */
public final class SearchProviderOperations
{
    private static final Logger log = Logger.getLogger(SearchProviderQueryAction.class);
    
    private static final boolean INFO = log.isInfoEnabled();
    
    private SearchProviderOperations()
    {
        super();
    }
    
    @SuppressWarnings("synthetic-access")
    public static SearchProviderOp<SearchCountRequest, SearchCounts> invokesCount(final SearchProvider provider)
    {
        return new WithSearchProvider<SearchCountRequest, SearchCounts>(provider) {
            @Override
            public SearchCounts perform(final SearchCountRequest param) throws IOException
            {
                guardNotNull(param);
             
                if(INFO)
                {
                    log.info("Getting counts from search provider");
                }
                
                try
                {
                    return provider.count(param);
                }
                finally
                {
                    if(INFO)
                    {
                        log.info("Done getting counts from search provider");
                    }
                }
            }
        };
    }
    
    @SuppressWarnings("synthetic-access")
    public static SearchProviderOp<SearchRequest, SearchResultSet> invokesQuery(final SearchProvider provider)
    {
        return new WithSearchProvider<SearchRequest, SearchResultSet>(provider) {
            @Override
            public SearchResultSet perform(final SearchRequest param) throws IOException
            {
                if(INFO)
                {
                    log.info("Querying repository");
                }

                try
                {
                    return provider.query(param);
                }
                finally
                {
                    if(INFO)
                    {
                        log.info("Done querying repository");
                    }
                }
            }
        };
    }
    
    /**
     * 
     * @author Clint Gilbert
     * 
     * Jul 13, 2010
     *
     * Center for Biomedical Informatics (CBMI)
     * @link https://cbmi.med.harvard.edu/
     *
     */
    private abstract static class WithSearchProvider<P, R> implements SearchProviderOp<P, R>
    {
        private final SearchProvider provider;

        WithSearchProvider(final SearchProvider provider)
        {
            super();
         
            guardNotNull(provider);
            
            this.provider = provider;
        }

        @Override
        public final SearchProvider getSearchProvider()
        {
            return provider;
        }
    }
}
