package org.eaglei.network.actions;

import static org.eaglei.network.actions.RDFQueryAction.Props.searchCentralIndex;
import static org.spin.tools.Util.guardNotNull;

import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

import org.apache.log4j.Logger;
import org.eaglei.model.EIOntModel;
import org.eaglei.network.actions.Shared.MagicStrings;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.lucene.CompositeLuceneProvider;
import org.eaglei.search.provider.rdf.RepositoryHarvester;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/**
 * 
 * @author Clint Gilbert
 * 
 * Jul 7, 2010
 *
 * Center for Biomedical Informatics (CBMI)
 * @link https://cbmi.med.harvard.edu/
 *
 * TODO: This class should go away.  It's very clunky.
 */
@Deprecated
public final class Shared
{
    private static final Logger log = Logger.getLogger(Shared.class);
    
    private static final boolean INFO = log.isInfoEnabled();
    
    public static final class MagicStrings
    {
        private MagicStrings()
        {
            super();
        }
        
        public static final String SparqlSearchProvider = "sparqlSearchProvider";
        public static final String Harvester = "harvester";        
    }
    
    private Shared()
    {
        super();
    }

    private static final Lock lock = new ReentrantLock();
    
    private static volatile boolean isProviderInitialized = false;
    
    private static volatile SearchProvider searchProvider; 
    
    private static volatile EIOntModel ontModel;
    
    static boolean isProviderInitialized()
    {
        return isProviderInitialized;
    }
    
    static void setIsProviderInitialized(final boolean value)
    {
        isProviderInitialized = value;
    }
    
    public static EIOntModel getOntModel()
    {
        lock.lock();
        
        try
        {
            if(ontModel == null)
            {
                final ApplicationContext context = getApplicationContext();
                
                guardNotNull(context);
                
                ontModel = context.getBean(EIOntModel.class);
            }
            
            return ontModel;
        }
        finally
        {
            lock.unlock();
        }
    }
    
    public static SearchProvider getSearchProvider() throws IOException
    {
        lock.lock();
        
        try
        {
            if(searchProvider == null)
            {
                // TODO This can all disappear into a Spring configuration file.
                //      At that point, will simply get the SearchProvider bean.
                //      Depending on the level of integration with the other webapps,
                //      will eventually obtain an ApplicationContext instead
                //      of creating it.
                
                // create and configure beans
                final ApplicationContext context = getApplicationContext();
        
                guardNotNull(context);
                
                // retrieve configured instance
                final SearchProvider provider = context.getBean(MagicStrings.Harvester, RepositoryHarvester.class);
                
                guardNotNull(provider);
                
                @SuppressWarnings("boxing")
                final boolean shouldUseCentralIndex = Boolean.valueOf(System.getProperty(searchCentralIndex));
                
                if(shouldUseCentralIndex)
                {
                    searchProvider = provider;
                }
                else
                {
                    final EIOntModel eagleiOntModel = context.getBean(EIOntModel.class);
                    
                    guardNotNull(eagleiOntModel);
                    
                    searchProvider = new CompositeLuceneProvider(eagleiOntModel, provider);
                }
                
                isProviderInitialized = false;
            }
            
            return searchProvider;
        }
        finally
        {
            lock.unlock();
        }
    }

    private static ApplicationContext getApplicationContext()
    {
        return new ClassPathXmlApplicationContext("query-action-config.xml");
    }
    
    static void setSearchProvider(final SearchProvider provider)
    {
        lock.lock();
        
        try
        {
            searchProvider = provider;
            
            isProviderInitialized = false;
        }
        finally
        {
            lock.unlock();
        }
    }
    
    /**
     * Lazily invoke init on searchProvider to work around circular init dependency issue
     * See http://jira.eagle-i.net:8080/browse/SEARCH-158 -Clint
     */
    public static void initializeProviderIfNecessary() throws IOException
    {
        lock.lock();
        
        try
        {
            if(!isProviderInitialized)
            {
                if(INFO)
                {
                    log.info("Initializing SearchProvider");
                }
                
                getSearchProvider().init();
                
                isProviderInitialized = true;
                
                if(INFO)
                {
                    log.info("Done initializing SearchProvider");
                }
            }
        }
        finally
        {
            lock.unlock();
        }
    }
}
