package org.eaglei.network.actions;

import static org.spin.tools.Util.guardNotNull;

import java.io.IOException;

import org.eaglei.search.provider.SearchProvider;

/**
 * 
 * @author Clint Gilbert
 * 
 * Jul 13, 2010
 *
 * Center for Biomedical Informatics (CBMI)
 * @link https://cbmi.med.harvard.edu/
 *
 */
public abstract class WithSearchProviderOp<P, R> implements SearchProviderOp<P, R>
{
    private final SearchProvider provider;

    protected WithSearchProviderOp(final SearchProvider provider)
    {
        super();
     
        guardNotNull(provider);
        
        this.provider = provider;
        
        init();
    }

    private void init()
    {
        try
        {
            this.provider.init();
        }
        catch(IOException e)
        {
            throw new UncheckedEagleIQueryException(e);
        }
    }

    @Override
    public final SearchProvider getSearchProvider()
    {
        return provider;
    }
}