/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.network.actions;

import java.io.IOException;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.network.actions.CountQueryAction;
import org.eaglei.network.actions.RDFQueryAction;
import org.eaglei.search.datagen.DataGenParams;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.lucene.LuceneSearchProviderIndexer;
import org.eaglei.search.provider.lucene.RepositoryHarvester;
import org.eaglei.search.provider.rdf.RDFModelProvider;
import org.eaglei.services.InstitutionRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class NetworkSearchTestConfig {
    @Autowired
    private RepositoryHarvester harvester;
    @Autowired
    private EIOntModel eagleiOntModel;
    @Autowired
    private LuceneSearchProviderIndexer indexer;
    @Autowired
    private InstitutionRegistry institutionRegistry;

    @Bean
    public RDFModelProvider rdfModelProvider() throws IOException {
        EIEntity university = (EIEntity)this.institutionRegistry.getInstitutions().get(0);
        return new RDFModelProvider(this.eagleiOntModel, DataGenParams.createForOneInstitution((String)university.getURI().toString(), (String)university.getLabel()), university);
    }

    @Bean
    public RDFQueryAction rdfQueryAction() throws IOException {
        return new RDFQueryAction((SearchProvider)this.rdfModelProvider());
    }

    @Bean
    public CountQueryAction countQueryAction() throws IOException {
        return new CountQueryAction((SearchProvider)this.rdfModelProvider());
    }
}

