/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.network.actions;

import junit.framework.Assert;
import org.apache.log4j.Logger;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.network.actions.CountQueryAction;
import org.eaglei.network.actions.NetworkSearchConfig;
import org.eaglei.network.actions.QueryTestUtils;
import org.eaglei.network.actions.ResultCheckingStrategy;
import org.eaglei.network.actions.SystemPropertyTweaks;
import org.eaglei.search.common.Serializer;
import org.eaglei.search.provider.SearchCountRequest;
import org.eaglei.search.provider.SearchCounts;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.services.InstitutionRegistry;
import org.spin.tools.SPINUnitTest;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public abstract class CountQueryActionTest
extends SPINUnitTest {
    private static final Logger log = Logger.getLogger(CountQueryActionTest.class);
    private static final boolean INFO = log.isInfoEnabled();
    private EIOntModel eagleiOntModel;
    private InstitutionRegistry institutionRegistry;
    private CountQueryAction action;

    public void testPerform() throws Exception {
        EIEntity university = (EIEntity)this.institutionRegistry.getInstitutions().get(0);
        CountQueryActionTest.assertNotNull((Object)university);
        SearchCountRequest countRequest = this.makeCountRequest();
        QueryTestUtils.doPerformTest(this.action, countRequest, Serializer.SearchCountsSerializer, new ResultCheckingStrategy<SearchCounts>(){

            @Override
            public void checkResults(SearchCounts counts) {
                Assert.assertNotNull((String)"counts = null", (Object)counts);
                for (EIClass eiClass : CountQueryActionTest.this.eagleiOntModel.getClassesInGroup("http://eagle-i.org/ont/app/1.0/ClassGroup/resourceRoot")) {
                    EIURI classURI = eiClass.getEntity().getURI();
                    Assert.assertTrue((String)(counts.getClassesForCounts() + " does not contain " + classURI), (boolean)counts.getClassesForCounts().contains(classURI));
                    Assert.assertTrue((String)(classURI + " should have a count of > 0, but was " + counts.getClassCount(classURI)), (counts.getClassCount(classURI) > 0 ? 1 : 0) != 0);
                }
                if (INFO) {
                    log.info((Object)("Count results: " + counts));
                }
            }
        });
    }

    private SearchCountRequest makeCountRequest() {
        SearchCountRequest countRequest = new SearchCountRequest(new SearchRequest());
        for (EIClass eiClass : this.eagleiOntModel.getClassesInGroup("http://eagle-i.org/ont/app/1.0/ClassGroup/resourceRoot")) {
            countRequest.addCountType(eiClass.getEntity().getURI());
        }
        return countRequest;
    }

    protected void setUp() throws Exception {
        super.setUp();
        SystemPropertyTweaks.setSystemProperties();
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext(new Class[]{NetworkSearchConfig.class});
        this.eagleiOntModel = (EIOntModel)context.getBean(EIOntModel.class);
        this.action = (CountQueryAction)context.getBean(CountQueryAction.class);
        this.institutionRegistry = (InstitutionRegistry)context.getBean(InstitutionRegistry.class);
        CountQueryActionTest.assertNotNull((Object)this.action);
        CountQueryActionTest.assertNotNull((Object)this.eagleiOntModel);
        CountQueryActionTest.assertNotNull((Object)this.institutionRegistry);
    }
}

