/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.network.actions;

import org.eaglei.network.actions.CountQueryAction;
import org.eaglei.network.actions.EagleIQueryActionMap;
import org.eaglei.network.actions.RDFQueryAction;
import org.eaglei.network.actions.SystemPropertyTweaks;
import org.eaglei.network.driver.Query;
import org.spin.node.UnknownQueryTypeException;
import org.spin.node.actions.QueryAction;
import org.spin.tools.SPINUnitTest;
import org.spin.tools.Util;

public final class EagleIQueryActionMapTest
extends SPINUnitTest {
    protected void setUp() throws Exception {
        SystemPropertyTweaks.setSystemProperties();
    }

    public void testGuardContainsQueryType() throws Exception {
        EagleIQueryActionMap map = new EagleIQueryActionMap();
        for (String queryType : map.getQueryTypes()) {
            map.guardContainsQueryType(queryType);
        }
        try {
            map.guardContainsQueryType("asdjkasdhjkasdhjkashd");
        }
        catch (UnknownQueryTypeException unknownQueryTypeException) {
            // empty catch block
        }
    }

    public void testEagleIQueryActionMap() {
        EagleIQueryActionMap map = new EagleIQueryActionMap();
    }

    public void testContainsQueryType() {
        EagleIQueryActionMap map = new EagleIQueryActionMap();
        for (Query query : Query.values()) {
            EagleIQueryActionMapTest.assertTrue((boolean)map.containsQueryType(query.queryType));
        }
        EagleIQueryActionMapTest.assertFalse((boolean)map.containsQueryType("sdjhaskdkasjd"));
    }

    public void testGetQueryAction() throws Exception {
        EagleIQueryActionMap map = new EagleIQueryActionMap();
        try {
            map.getQueryAction("sdkhazkfhjkasdfh");
            EagleIQueryActionMapTest.fail((String)"Should have thrown");
        }
        catch (UnknownQueryTypeException expected) {
            // empty catch block
        }
        QueryAction rdfQueryAction = map.getQueryAction(Query.RDF.queryType);
        EagleIQueryActionMapTest.assertNotNull((Object)rdfQueryAction);
        EagleIQueryActionMapTest.assertEquals(RDFQueryAction.class, rdfQueryAction.getClass());
        EagleIQueryActionMapTest.assertSame((Object)rdfQueryAction, (Object)map.getQueryAction(Query.RDF.queryType));
        QueryAction countQueryAction = map.getQueryAction(Query.Count.queryType);
        EagleIQueryActionMapTest.assertNotNull((Object)countQueryAction);
        EagleIQueryActionMapTest.assertEquals(CountQueryAction.class, countQueryAction.getClass());
        EagleIQueryActionMapTest.assertSame((Object)countQueryAction, (Object)map.getQueryAction(Query.Count.queryType));
    }

    public void testGetQueryTypes() {
        EagleIQueryActionMap map = new EagleIQueryActionMap();
        EagleIQueryActionMapTest.assertEquals((Object)Util.asSet((Object[])new String[]{Query.RDF.queryType, Query.Count.queryType}), (Object)map.getQueryTypes());
    }

    public void testDestroy() throws Exception {
        EagleIQueryActionMap map = new EagleIQueryActionMap();
        EagleIQueryActionMapTest.assertFalse((boolean)map.isDestroyed());
        map.destroy();
        EagleIQueryActionMapTest.assertTrue((boolean)map.isDestroyed());
    }
}

