/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.network.actions;

import junit.framework.TestCase;
import org.eaglei.network.actions.CountQueryAction;
import org.eaglei.network.actions.EagleIQueryActions;
import org.eaglei.network.actions.NetworkSearchConfig;
import org.eaglei.network.actions.RDFQueryAction;
import org.eaglei.network.actions.SystemPropertyTweaks;
import org.eaglei.network.driver.Query;
import org.spin.node.actions.QueryAction;
import org.spin.tools.config.QueryTypeConfig;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public final class EagleIQueryActionsTest
extends TestCase {
    protected void setUp() throws Exception {
        SystemPropertyTweaks.setSystemProperties();
    }

    public void testBasicCorrespondence() {
        EagleIQueryActionsTest.assertEquals((int)Query.values().length, (int)EagleIQueryActions.values().length);
    }

    public void testObtainQueryAction() throws Exception {
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext(new Class[]{NetworkSearchConfig.class});
        for (EagleIQueryActions queryActionDef : EagleIQueryActions.values()) {
            QueryAction action = queryActionDef.obtainQueryAction((ApplicationContext)context);
            EagleIQueryActionsTest.assertNotNull((Object)action);
            EagleIQueryActionsTest.assertEquals((Object)queryActionDef.queryActionClass(), action.getClass());
        }
    }

    public void testToQueryTypeConfig() {
        for (EagleIQueryActions queryActionDef : EagleIQueryActions.values()) {
            EagleIQueryActionsTest.assertEquals((Object)new QueryTypeConfig(queryActionDef.query().queryType, queryActionDef.queryActionClass().getName()), (Object)queryActionDef.toQueryTypeConfig());
        }
    }

    public void testQuery() {
        EagleIQueryActionsTest.assertSame((Object)Query.RDF, (Object)EagleIQueryActions.RDF.query());
        EagleIQueryActionsTest.assertSame((Object)Query.Count, (Object)EagleIQueryActions.Count.query());
    }

    public void testQueryActionClass() {
        EagleIQueryActionsTest.assertEquals(RDFQueryAction.class, (Object)EagleIQueryActions.RDF.queryActionClass());
        EagleIQueryActionsTest.assertEquals(CountQueryAction.class, (Object)EagleIQueryActions.Count.queryActionClass());
    }

    public void testFromQueryType() {
        EagleIQueryActionsTest.assertEquals((Object)EagleIQueryActions.RDF, (Object)EagleIQueryActions.fromQueryType((String)Query.RDF.queryType));
        EagleIQueryActionsTest.assertEquals((Object)EagleIQueryActions.Count, (Object)EagleIQueryActions.fromQueryType((String)Query.Count.queryType));
        try {
            EagleIQueryActions.fromQueryType((String)"asdkhaskdhasjkdh");
            EagleIQueryActionsTest.fail((String)"Should have thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testFromQuery() {
        EagleIQueryActionsTest.assertEquals((Object)EagleIQueryActions.RDF, (Object)EagleIQueryActions.fromQuery((Query)Query.RDF));
        EagleIQueryActionsTest.assertEquals((Object)EagleIQueryActions.Count, (Object)EagleIQueryActions.fromQuery((Query)Query.Count));
        try {
            EagleIQueryActions.fromQuery(null);
            EagleIQueryActionsTest.fail((String)"Should have thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

