/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.network.actions;

import java.io.IOException;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.jena.JenaModelConfig;
import org.eaglei.network.actions.CountQueryAction;
import org.eaglei.network.actions.RDFQueryAction;
import org.eaglei.search.datagen.DataGenParams;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.rdf.RDFModelProvider;
import org.eaglei.services.InstitutionRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportResource;

@Configuration
@ImportResource(value={"classpath:services-config.xml"})
@Import(value={JenaModelConfig.class})
public class NetworkSearchTestConfig {
    @Autowired
    private EIOntModel eagleiOntModel;
    @Autowired
    private InstitutionRegistry institutionRegistry;

    @Bean
    public RDFModelProvider rdfModelProvider() throws IOException {
        EIEntity university = (EIEntity)this.institutionRegistry.getInstitutions().get(0);
        return new RDFModelProvider(this.eagleiOntModel, DataGenParams.createForOneInstitution((String)university.getURI().toString(), (String)university.getLabel()), university);
    }

    @Bean
    public RDFQueryAction rdfQueryAction() throws IOException {
        return new RDFQueryAction((SearchProvider)this.rdfModelProvider());
    }

    @Bean
    public CountQueryAction countQueryAction() throws IOException {
        return new CountQueryAction((SearchProvider)this.rdfModelProvider());
    }
}

