#!/bin/sh
#
# Copyright (c) 2015, President and Fellows of Harvard College
# Portions Copyright (c) 2015, VectorC, LLC
# Portions Copyright (c) 2015, Wonder Lake Software, LLC
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in the
# documentation and/or other materials provided with the distribution.
#
# 3. The name of the author may not be used to endorse or promote products
# derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
# EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
# TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
# PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#


# eagle-i Data Repository Installation - Final Step
# Create admin user metadata, AND load data model ontology
#
#  WARNING: THIS *MUST* be executed with tomcat running.
#
# Args:
#  I. admin user metadata
#       -f firstname
#       -l lastname
#       -m mailbox
#  II. options on loading datamodel
#       -F   -- force load instead of update
#
# Started Nov 2010
# $Id: finish-install.sh 19120 2015-04-30 05:13:28Z scheng $
# Author: Larry Stone

#-------- temp directory boilerplate - cleanup on exit
tmpDir="/tmp/ei-finish-install-$$"
mkdir $tmpDir
cleanup () {
  rm -rf $tmpDir
}
trap cleanup EXIT

usage="Usage: $0  [-F|-U] [ -f firstname ] [ -l lastname ] [ -m mailbox ] admin-username  password  repository-URL-prefix"

firstname="x1=y"
lastname="x2=y"
mbox="x3=y"
dmAction=update

if [ $1 = '--version' ]; then
    echo "$0 from release 4.5.1 SCM revision 20108"
    exit 0
fi
while [ $# -gt 3 ]; do
   case "$1" in
      -F)
            dmAction=load ;;
      -U)
            dmAction=update ;;
      -f)
            firstname="firstname=$2"; shift;;
      -l)
            lastname="lastname=$2"; shift;;
      -m)
            mbox="mbox=$2"; shift;;
      -*)
            echo "Unknown option $1"
            echo $usage
            exit 1;;
    esac
    shift
done
if [ $# -ne 3 ]; then
      echo "Remaining args: $*"
      echo $usage
      exit 1
fi
username=$1
password=$2
repoURL=$3

login="${username}:${password}"

#--------------  Step 1 - finish admin user creation by adding RDF metadata
out=${tmpDir}/whoami.out
status=`curl -k -s -S -o "$out" -u "$login" -d create=true -d "$firstname" \
 -d "$lastname" -d "$mbox" --write-out '%{http_code}\n' "${repoURL}/repository/whoami"`
cmd=$?
if [ "${cmd}" -ne 0 ]; then
    echo "FAILED to send whoami command to repository: curl command status: $cmd"
    exit 1
elif [ "$status" = "409" ]; then
    echo "User \"${username}\" already has metadata, skipping."
elif [ "$status" != "201" ]; then
    echo "FAILED to create metadata for user, HTTP status=$status"
    test -f "$out" && cat "$out"
    exit 2
else
    echo "User metadata created."
fi

#---------- step 2 - load data model ontology from jar
dmSource=jar
if [ "$dmAction" = "load" ]; then
    loadVerb="Load"
else
    loadVerb="Updat"
fi

echo "${loadVerb}ing data model ontology from ${dmSource}, please wait..."
out2=${tmpDir}/model.out
status=`curl -k -s -S -o "$out2" -u "$login" -d action=${dmAction} -d source=${dmSource} \
    --write-out '%{http_code}\n' "${repoURL}/repository/model"`
cmd=$?
if [ "${cmd}" -ne 0 ]; then
    echo "FAILED to send model command to repository: curl command status: $cmd"
    exit 4
elif [ "$status" = "200" -o "$status" = "201" ]; then
    echo "${loadVerb}ed data model ontology from jar."
else
    echo "FAILED to load/update data model, HTTP status=$status"
    test -f "$out2" && cat "$out2"
    exit 3
fi
