#!/bin/sh
#
# Copyright (c) 2015, President and Fellows of Harvard College
# Portions Copyright (c) 2015, VectorC, LLC
# Portions Copyright (c) 2015, Wonder Lake Software, LLC
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in the
# documentation and/or other materials provided with the distribution.
#
# 3. The name of the author may not be used to endorse or promote products
# derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
# EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
# TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
# PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#


# simple script to load ontology RDF
#
# WARNING: This is only intended to be used for testing and debugging, it is
#  NOT an official part of the repository.  However, there is not yet any
#  better way to load ontologies.  Use it at your own risk.
#
# It is hardwired to look for the jar created by the eagle-i-model-owl
# maven package, since this is our current (28-Apr-10) convention.
# It then grabs all the files with a ".owl" extension from that jar and
# loads them into one named graph.
#
# Usage:
#  Two modes: show with required args:
#
#  1. Load all data model ontologies:
#    -a  [WAR-file]  [user] [password] [repository-URL]
#
#  2. load a single ontology file into named graph
#    -s  [path/URL]  [user] [password] [repository-URL]
#
#  example: load-ontology  /opt/tomcat/ROOT.war  admin password http://localhost:8008/
#
# Converted to use new /model service to upload ontology.
# Now does it in one transaction, with more complete and
# meaningful provenance metadata, but some of the same bugs:
#  - still grovels all .owl files in model-jena package's jar
#  - does not interpret OWL 'imports' statements
#  - assumes all OWL content is RDF/XML by default, should check extension at least.
#
# $Id: load-ontology.sh 19120 2015-04-30 05:13:28Z scheng $
# Author: Larry Stone

set -e

#-------------- End Configuration

Usage="Usage:  $0   -a  [WAR-file]  [user] [password] [repository-URL]"

if [ "$1" = '--version' ]; then
    echo "$0 from release 4.5.1 SCM revision 20108"
    exit 0

# load all from war
elif [ "$1" = '-a' ]; then
    warpath=$2
    user=$3
    password=$4
    repo=$5
    tmpout=/tmp/onto-load-out-$$.txt

    # invoke /model service to load data model ontology
    curl -k -s -S -u "${user}:${password}" -d action=load -d source=jar \
    --write-out 'Loaded data model ontology: status=%{http_code}, time=%{time_total}\n' \
      "${repo}/repository/model" > $tmpout

    # check HTTP status
    if egrep -q 'status=20[01],' $tmpout ; then
        exitStatus=0
    else
        exitStatus=1
        echo "FAILED loading data model ontology graph\n\n"
    fi
    cat "$tmpout"
    rm "$tmpout"
    exit $exitStatus

elif [ "$1" = "-s" ]; then
    echo "Single load not implemented."
    exit 1

else
    echo "$Usage"
    exit 1
fi
