#!/bin/sh
#
# Copyright (c) 2015, President and Fellows of Harvard College
# Portions Copyright (c) 2015, VectorC, LLC
# Portions Copyright (c) 2015, Wonder Lake Software, LLC
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in the
# documentation and/or other materials provided with the distribution.
#
# 3. The name of the author may not be used to endorse or promote products
# derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
# EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
# TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
# PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

usage() {
    #### NOTE: this usage must be kept up-to-date with the usage provided by the java code;
    #### The options mentioned here are only a small subset of the java-command options:
    #### there, pretty much anything in the config-file can be overridden on the
    #### command-line, and so it can here (it may help to run the java-command with "--help")
    echo "Usage: "
    echo "  bash synchronize-sparqler.sh --help|-h|--version|-v"
    echo "or:"
    echo "  bash synchronize-sparqler.sh [-c full-path-to-eagle-i-home-directory]"
    echo "          [-d dateFrom (\"\\\"yyyy:MMM:dd HH:mm:ss\\\"\")]"
    echo "          [-e full-path-to-config-file]"
    echo "dateFrom may also be specified as \"FIRST_SYNC\" if it is desired to copy all"
    echo "  public data from the source-repository into the sparqler, replacing any"
    echo "  data it may already contain."
    echo "Note that if an alternate config-file is specified, it must contain "
    echo "  access-credentials to the source and the sparqler repositories which"
    echo "  are normally provided in another configuration-file."
    echo "The source- and sparqler-repositories must be running at their specified URLs."
    echo "The location of the java installation should be specified by exported" 
    echo "  shell-variables (either \"JAVA_HOME\" or \"JRE_HOME\")."
    echo "The location of the tomcat installation should be specified by exported"  
    echo "  shell-variables \"CATALINA_HOME\" and \"CATALINA_BASE\"." 
}
#
# check command-line:
if [ "$1" = "--version" -o "$1" = "-v" ]; then
    echo "$0 from release 4.5.1 SCM revision 20108"
    exit 0
fi
if [ "$1" = "--help" -o "$1" = "-h" ]; then
    usage
    exit 0
fi
## default home:
EAGLE_I_HOME=`pwd`
### OPTIONS=""
while [ $# -gt 0 ]; do
    case "$1" in
        -c)
            EAGLE_I_HOME=$2; shift;shift;;
        -d) 
            OPTIONS="${OPTIONS} --dateAfter $2"; shift; shift;;
        -e)
            OPTIONS="${OPTIONS} --eIconfigFile $2"; shift; shift;;
        *)
            # all others are passed through:
            OPTIONS="${OPTIONS} $1"; shift;;
    esac
done
## all other options are passed through to java - see usage:
## debugging:
#echo EAGLE_I_HOME = "${EAGLE_I_HOME}"
#echo OPTIONS = "${OPTIONS}"
#exit
#    
echo "Using directory ${EAGLE_I_HOME} for eagle-i-home"   
#
cd ${EAGLE_I_HOME}
EAGLE_I_CONF=${EAGLE_I_HOME}/conf
EAGLE_I_CREDS=${EAGLE_I_HOME}/.config

# some installations put cred-files in EAGLE_I_CONF, others in EAGLE_I_CREDS:
if [ ! -d "${EAGLE_I_CREDS}" ]; then
    EAGLE_I_CREDS=${EAGLE_I_CONF}
fi

### eagle-i conf dir path - sanity-check it
if [ ! -d "${EAGLE_I_CONF}" ]; then
    echo "ERROR, Eagle-i configuration directory not found (or not directory): ${EAGLE_I_CONF}"
    usage
    exit 1
fi
#
### eagle-i-apps.properties? - sanity-check it
if [ ! -r "${EAGLE_I_CONF}/eagle-i-apps.properties" ]; then
    echo "ERROR, file ${EAGLE_I_CONF}/eagle-i-apps.properties not found (or not readable)"
    usage
    exit 1
fi
#
if [ ! -d "${EAGLE_I_CREDS}" ]; then
    echo "ERROR, Eagle-i credentials directory not found (or not directory): ${EAGLE_I_CREDS}"
    usage
    exit 1
fi
if [ ! -r "${EAGLE_I_CREDS}/eagle-i-apps-credentials.properties" ]; then
    echo "ERROR, file ${EAGLE_I_CREDS}/eagle-i-apps-credentials.properties not found (or not readable)"
    usage
    exit 1
fi
#
# we need CATALINA_BASE, which, if not specified, defaults to CATALINA_HOME:
if [ -z "${CATALINA_BASE}" ]; then
    CATALINA_BASE=${CATALINA_HOME}
fi
#
#
if [ -z "${CATALINA_BASE}" ]; then
    echo "ERROR, neither \"CATALINA_BASE\" nor \"CATALINA_HOME\" is set (or exported); tomcat installation not found"
    exit 1
fi
WEBAPPS=${CATALINA_BASE}/webapps
#

#
### find Java:
if [ -z "$JRE_HOME" -a -n "$JAVA_HOME" ]; then
    echo "Setting JRE_HOME to current JAVA_HOME $JAVA_HOME"
    JRE_HOME="$JAVA_HOME"
fi
if [ -n "${JRE_HOME}" ]; then
    _RUNJAVA="$JRE_HOME"/bin/java
else
    _RUNJAVA=`which java`
fi
#
if [ -x "${_RUNJAVA}" ]; then
    echo "_RUNJAVA set to \"$_RUNJAVA\""
else
    echo "java command \"_RUNJAVA\" not found or not executable - cannot synchronize"
    echo "Please set and export either \"JAVA_HOME\" or \"JRE_HOME\" to the location of the java installation"
    exit -1\"
fi
#

#
sleep 1
#
cd ${EAGLE_I_HOME}  ## required for logs-directory to be found
#
# set classpath, synch-class
#
### config-files are read as resources, so the conf-dir must be in the classpath:
CLASSPATH=${EAGLE_I_CONF}:${EAGLE_I_CREDS}
## and the classes we need are just those used by the repository webapp, so:
REPO_WEBAPP=${WEBAPPS}/ROOT/WEB-INF/
REPO_CLASSES=${WEBAPPS}/ROOT/WEB-INF/classes
CLASSPATH=${CLASSPATH}:${REPO_CLASSES}
## now loop through the jars, adding each one:
REPO_LIBS=`ls ${REPO_WEBAPP}/lib/*.jar`
for jar in ${REPO_LIBS} ; do
    CLASSPATH=${CLASSPATH}:${jar}
done
#
SYNCHRONIZER_CLASS="org.eaglei.repository.sparqler.SynchronizerCommand" 
#
echo "Started at: `date`"
echo "Command: ${_RUNJAVA} -cp ${CLASSPATH} ${SYNCHRONIZER_CLASS} ${OPTIONS}"
${_RUNJAVA} -cp ${CLASSPATH} ${SYNCHRONIZER_CLASS} ${OPTIONS}
result=$?
echo "Finished with status ${result} at: `date`"
exit ${result}
#


