#!/bin/sh
#
# Copyright (c) 2015, President and Fellows of Harvard College
# Portions Copyright (c) 2015, VectorC, LLC
# Portions Copyright (c) 2015, Wonder Lake Software, LLC
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in the
# documentation and/or other materials provided with the distribution.
#
# 3. The name of the author may not be used to endorse or promote products
# derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
# EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
# TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
# PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

usage() {
    #### NOTE: this usage must be kept up-to-date with the usage provided by the java code;
    #### The options mentioned here are only a small subset of the java-command options:
    #### there, pretty much anything in the config-file can be overridden on the
    #### command-line, and so it can here, if you run the java-command with "--help"
    echo "Usage: "
    echo "  bash test-sparqler-synchronizer.sh"
    echo "The source- and sparqler-repositories must be running at the URLs specified "
	echo "in eagle-i-apps.properties.  For the test, we need admin-access to source and target"
}
# #
# # check command-line:
# if [ "$1" = "--version" -o "$1" = "-v" ]; then
#     echo "$0 from release 4.5.1 SCM revision 20108"
#     exit 0
# fi
# if [ "$1" = "--help" -o "$1" = "-h" ]; then
#     usage
#     exit 0
# fi
# ## default home:
EAGLE_I_HOME=`pwd`
# ### OPTIONS=""
# while [ $# -gt 0 ]; do
#     case "$1" in
#         -c)
#             EAGLE_I_HOME=$2; shift;shift;;
#         -d) 
#             OPTIONS="${OPTIONS} --dateAfter $2"; shift; shift;;
#         -e)
#             OPTIONS="${OPTIONS} --eIconfigFile $2"; shift; shift;;
#         *)
#             # all others are passed through:
#             OPTIONS="${OPTIONS} $1"; shift;;
#     esac
# done
# ## all other options are passed through to java - see usage:
# ## debugging:
# #echo EAGLE_I_HOME = "${EAGLE_I_HOME}"
# #echo OPTIONS = "${OPTIONS}"
# #exit
# #    
echo "Using directory ${EAGLE_I_HOME} for eagle-i-home"   
#
cd ${EAGLE_I_HOME}
SPARQLER_HOME=${EAGLE_I_HOME}/sparqler
EAGLE_I_CONF=${EAGLE_I_HOME}/conf
EAGLE_I_CREDS=${EAGLE_I_HOME}/.config
#
### Datamanagement-jar is a shaded jar, i.e. it contains not only the 
## Synchronizer classes, but everything they depend on, too - so we 
## need only the one jar in our classpath:
DATAMANAGEMENT_JAR="${SPARQLER_HOME}/lib/eagle-i-datatools-datamanagement.jar"
#
### sparqler home dir path - sanity-check it
if [ ! -d "${SPARQLER_HOME}" ]; then
    echo "ERROR, sparqler directory not found (or not directory): ${SPARQLER_HOME}"
    usage
    exit 1
fi
#
### eagle-i conf dir path - sanity-check it
if [ ! -d "${EAGLE_I_CONF}" ]; then
    echo "ERROR, Eagle-i configuration directory not found (or not directory): ${EAGLE_I_CONF}"
    usage
    exit 1
fi
#
### eagle-i-apps.properties? - sanity-check it
if [ ! -r "${EAGLE_I_CONF}/eagle-i-apps.properties" ]; then
    echo "ERROR, file ${EAGLE_I_CONF}/eagle-i-apps.properties not found (or not readable)"
    usage
    exit 1
fi
#
### eagle-i-apps-credentials.properties? - sanity-check it
if [ ! -r "${EAGLE_I_CREDS}/eagle-i-apps-credentials.properties" ]; then
    echo "ERROR, file ${EAGLE_I_CREDS}/eagle-i-apps-credentials.properties not found (or not readable)"
    usage
    exit 1
fi
#
### sanity-check the jar:
if [ ! -r "${DATAMANAGEMENT_JAR}" ]; then
    echo "ERROR, Synchronizer jar-file not found:  ${DATAMANAGEMENT_JAR}"
    usage
    exit 1
fi
#
# It'd be nice to "ping" the source & sparqler to verify they're running - but
# we'd have to pull the url from the config-file and....
# We'll leave that to the java-code....
#
### find Java:
if [ -z "$JRE_HOME" -a -n "$JAVA_HOME" ]; then
    echo "Setting JRE_HOME to current JAVA_HOME $JAVA_HOME"
    JRE_HOME="$JAVA_HOME"
fi
if [ -n "${JRE_HOME}" ]; then
    _RUNJAVA="$JRE_HOME"/bin/java
else
    _RUNJAVA="java"
fi
#
if [ -x "${_RUNJAVA}" ]; then
    echo "_RUNJAVA set to \"$_RUNJAVA\""
else
    echo "\"_RUNJAVA\" not found or not executable - cannot synchronize"
    exit -1
fi
#
sleep 1
#
cd ${EAGLE_I_HOME}  ## required for logs-directory to be found
### config-files are read as resources, so the conf-dir must be in the classpath:
CLASSPATH=${EAGLE_I_CONF}:${EAGLE_I_CREDS}:${DATAMANAGEMENT_JAR}
SYNCHRONIZER_CLASS="org.eaglei.datatools.datamanagement.sparqler.SynchronizerTest" 
#
echo "Started at: `date`"
echo "Command: ${_RUNJAVA} -cp ${CLASSPATH} ${SYNCHRONIZER_CLASS} ${OPTIONS}"
${_RUNJAVA} -cp ${CLASSPATH} ${SYNCHRONIZER_CLASS} ${OPTIONS}
result=$?
echo "Finished with status ${result} at: `date`"
exit ${result}
#


