#!/bin/sh
#
# Copyright (c) 2015, President and Fellows of Harvard College
# Portions Copyright (c) 2015, VectorC, LLC
# Portions Copyright (c) 2015, Wonder Lake Software, LLC
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in the
# documentation and/or other materials provided with the distribution.
#
# 3. The name of the author may not be used to endorse or promote products
# derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
# EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
# TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
# PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#



# Move "everything" from one repo to another
#
#   * * * * *    W A R N I N G    * * * * *
#
# THIS IS ANOTHER VERY DANGEROUS SCRIPT BY THE REPOSITORY TEAM
#
# IT WILL ATTEMPT TO UPGRADE DERBY WITH THE NEW DERBY JARS YOU PROVIDE
# YOU ARE RESPONSIBLE FOR:
#
# BACKING UP YOUR DERBY DB, DO NOT UPGRADE A LIVE DB!
# MAKE SURE NO APPLICATION IS USING YOUR DERBY DB
# MAKE SURE YOU WANT THE JARS YOU ARE PROVIDING TO UPPRADE THE DB
# COPY THE RIGHT JARS TO YOUR APPLICATION ENVIRONMENT ONCE YOU ARE DONE

# $Id: upgrade-derby.sh 8841 2011-04-14 03:15:05Z rd67 $
# Author: Ricardo De Lima




# Configuration  parameters:
EAGLE_I_DB_DIR="db"
EAGLE_I_DB_NAME="eagle-i-users.derby"
EAGLE_I_TBL_USERS="Users"
EAGLE_I_TBL_ROLES="Roles"
SLASH_LIB="/lib"

X_HOME=`dirname $0`/..

usage="usage: $0 [-newderbyjars jar-dir] [-oldderbyhome derbyhome] [-upgrade full|soft] <path to repository home> [-dbname (default: \"eagle-i-users.derby\")]"

unset USERNAME
newderbyjars=
oldderbyhome=

while [ $# -gt 0 ]
do
   case "$1" in
      --version)
            echo "$0 from release 4.5.1 SCM revision 20108"
            exit 0;;
      -newderbyjars) newderbyjars="$2"; shift;;
      -oldderbyhome) oldderbyhome="$2"; shift;;
      -dbname) EAGLE_I_DB_NAME="$2"; shift;;
      -*) echo >&2 \
          echo $usage
          exit 1;;
       *)  break;;      # terminate while loop
   esac
   shift
done



if [ $# -ne 1 ]; then
    echo $usage
	exit 1
fi


if [ -n "$1" ]; then
   REPOSITORY_HOME="$1"
fi

if [ -z "$REPOSITORY_HOME" ]; then
   echo    "!* ERROR:"
   echo    " * REPOSITORY_HOME was not provide/is not set."
   echo    " * ${usage}"
fi
if [ -d "${REPOSITORY_HOME}" ]
then
    echo "Using \"${REPOSITORY_HOME}\" as repository home"
else
    echo "!* Error, \"${REPOSITORY_HOME}\" does not exist, exiting..."
    exit 1
fi


DERBY_HOME=${oldderbyhome}
NEW_DERBY_HOME=${newderbyjars}

   if [ -d "${DERBY_HOME}" ]
   then
      echo " * The old derby jars have been found"
      echo " * `basename $0` will use the derby"
      echo " * libraries setup on this host. "
      DERBY_JARS=`echo ${DERBY_HOME}/derby*.jar | tr ' ' :`
   	  echo "old derby jars: ${DERBY_JARS}"
   else
      echo "!* Error, -olderbyhome \"${DERBY_HOME}\" does not exist, exiting..."
      exit 2
   fi

   if [ -d "${NEW_DERBY_HOME}" ]
   then
      echo " * The new derby jars have been found"
      echo " * `basename $0` will use the derby"
      echo " * libraries setup on this host. "
      NEW_DERBY_JARS=`echo ${NEW_DERBY_HOME}/derby*.jar | tr ' ' :`
   	  echo "new derby jars: ${NEW_DERBY_JARS}"
   else
      echo "!* Error, -newderbyjars \"${NEW_DERBY_HOME}\" does not exist, exiting..."
      exit 2
   fi




## backup the old derby db if found

   if [ -d "${REPOSITORY_HOME}/${EAGLE_I_DB_DIR}/${EAGLE_I_DB_NAME}" ]
   then
	  upgradedb="${REPOSITORY_HOME}/${EAGLE_I_DB_DIR}/${EAGLE_I_DB_NAME}"
      echo " * Found the derby db to upgrade: ${REPOSITORY_HOME}/${EAGLE_I_DB_DIR}/${EAGLE_I_DB_NAME}"
	  echo " * making a backup of this db to /tmp/${EAGLE_I_DB_NAME}"
	  cp -r ${REPOSITORY_HOME}/${EAGLE_I_DB_DIR}/${EAGLE_I_DB_NAME} /tmp/${EAGLE_I_DB_NAME}

   else
      echo "!* Error, \"${REPOSITORY_HOME}/${EAGLE_I_DB_DIR}/${EAGLE_I_DB_NAME}\" does not exist, exiting..."
      exit 2
   fi




if [ -z "$newderbyjars" ] || [ -z "$oldderbyhome" ] 
then
   echo "This script will update the derby db for the eagle-i repository."
   echo "The eagle-i repository home is set to: ${REPOSITORY_HOME}"
   echo -n "Do you want to continue? [y/N]: "
   read INPUT
   if ! expr "$INPUT" : ' *[yY].*' > /dev/null
   then
      echo Aborting - bye!
      exit 3
   fi
fi


DASHD_URL="-Dij.database=jdbc:derby:${upgradedb}"

echo "performing a soft upgrade" 
echo "exit;" | java  -cp "${NEW_DERBY_JARS}" "${DASHD_URL}" org.apache.derby.tools.ij #&>/dev/null


exit 0
