#!/bin/sh


# Configuration  parameters:
EAGLE_I_DB_DIR="db"
EAGLE_I_DB_NAME="eagle-i-users.derby"
EAGLE_I_TBL_USERS="Users"
EAGLE_I_TBL_ROLES="Roles"
SLASH_LIB="/lib"

X_HOME=`dirname $0`/..

unset USERNAME
uname=
pwd=
while [ $# -gt 0 ]
do
   case "$1" in
      -u) uname="$2"; shift;;
      -p) pwd="$2"; shift;;
      -*) echo >&2 \
          "usage: $0 [-u username] [-p password] <path to repository home>"
          echo "If username and password are provided, $0 will run non-interactive!"
          exit 1;;
       *)  break;;      # terminate while loop
   esac
   shift
done

if [ -n "$1" ]; then
   REPOSITORY_HOME="$1"
fi

if [ -z "$REPOSITORY_HOME" ]; then
   echo    "!* ERROR:"
   echo    " * REPOSITORY_HOME was not provide/is not set."
   echo    " * usage: $0 [-u username] [-p password] <path to repository home>"
   echo    " * or set environment variable REPOSITORY_HOME"
   echo -n " * or enter REPOSITORY HOME now:"
   read REPOSITORY_HOME
fi
if [ -d "${REPOSITORY_HOME}" ]
then
    echo "Using \"${REPOSITORY_HOME}\" as repository home"
else
    echo "!* Error, \"${REPOSITORY_HOME}\" does not exist, exiting..."
    exit 1
fi


if [ -z ${DERBY_HOME} ]; then
   echo "`basename $0` will use the derby distribution provided by the eagle-i repository!"
   DERBY_HOME=${X_HOME}
   DERBY_JARS=`echo ${DERBY_HOME}/lib/derby*.jar | tr ' ' :`
   echo ${DERBY_JARS}
else
   if [ -d "${DERBY_HOME}" ]
   then
      echo "!* WARNING:"
      echo " * `basename $0` detected Apache Derby at:"
      echo " * \"${DERBY_HOME}\" ."
      echo " * The DERBY_HOME environment parameter is"
      echo " * set. `basename $0` will use the derby"
      echo " * libraries setup on this host. "
      DERBY_JARS="${DERBY_HOME}${SLASH_LIB}/derby.jar:${DERBY_HOME}${SLASH_LIB}/derbytools.jar"
   else
      echo "!* Error, \"${DERBY_HOME}\" does not exist, exiting..."
      exit 2
   fi
fi

if [ -z "$uname" ] || [ -z "$pwd" ]
then
   echo "This script will create a superuser for the eagle-i repository."
   echo "The eagle-i repository home is set to: ${REPOSITORY_HOME}"
   echo -n "Do you want to continue? [y/N]: "
   read INPUT
   if ! expr "$INPUT" : ' *[yY].*' > /dev/null
   then
      echo Aborting - bye!
      exit 3
   fi
fi
DASHD_URL="-Dij.database=jdbc:derby:${REPOSITORY_HOME}/${EAGLE_I_DB_DIR}/${EAGLE_I_DB_NAME}"


unset PASSWORD
unset PASSWORD2

if [ -n "$uname" ]
then
   USERNAME="${uname}"
fi

if [ -n "$pwd" ]
then
   PASSWORD="${pwd}"
   PASSWORD2="${pwd}"
fi

until [ -n "${PASSWORD}" ] && \
      [ -n "${USERNAME}"  ] && \
      [ "${PASSWORD}" = "${PASSWORD2}" ]
do
      if [ "${PASSWORD}" != "${PASSWORD2}" ]
      then
         echo "!* ERROR:"
         echo " * The passwords do not match. Please try again..."
         echo
      fi
      if [ -z "$uname" ]
      then
         echo -n "What userid would you like create for the eagle-i superuser?: "
         read USERNAME
      fi

      if [ -z "$pwd"]
      then
         STTY_ORIG=`stty -g`
         stty -echo
         trap "stty echo ; echo 'Interrupted' ; exit 1" 1 2 15
         echo -n "Enter password: "
         read PASSWORD
         echo
         echo -n "Repeat the password: "
         read PASSWORD2
         echo
         stty $STTY_ORIG
         if [ -z ${USERNAME} ] || [ -z ${PASSWORD} ]
         then
            echo
            echo "!* ERROR:"
            echo " * Neither username nor password may be blank."
            echo " * Please try again..."
            echo
         fi
      fi
done

if [ -d "${REPOSITORY_HOME}/${EAGLE_I_DB_DIR}" ]
then
    echo "Found directory ${REPOSITORY_HOME}/${EAGLE_I_DB_DIR}  using it for the eagle-i database directory."
else
    echo "The eagle-i database directory '${REPOSITORY_HOME}/${EAGLE_I_DB_DIR}' does not exist. Creating..."
    mkdir "${REPOSITORY_HOME}/${EAGLE_I_DB_DIR}"
fi

if [ -d "${REPOSITORY_HOME}/${EAGLE_I_DB_DIR}/${EAGLE_I_DB_NAME}" ]
then
    echo "Found directory ${REPOSITORY_HOME}/${EAGLE_I_DB_DIR}/${EAGLE_I_DB_NAME}."
else
    echo "Eagle-I database '${REPOSITORY_HOME}/${EAGLE_I_DB_DIR}/${EAGLE_I_DB_NAME}' does not exist. Creating ..."
    echo  "CREATE TABLE Users (Username VARCHAR(64) PRIMARY KEY, Password VARCHAR(64) NOT NULL);
CREATE TABLE Roles (RoleName VARCHAR(64) NOT NULL, Username VARCHAR(64) NOT NULL);
ALTER TABLE Roles ADD CONSTRAINT PK_Roles PRIMARY KEY (RoleName, Username);
ALTER TABLE Roles ADD CONSTRAINT FK_Roles_Username FOREIGN KEY (Username) REFERENCES Users(Username);" | \
    java -cp "${DERBY_JARS}"  \
         "${DASHD_URL};create=true" \
         org.apache.derby.tools.ij #&>/dev/null
fi

echo "INSERT INTO Users VALUES ('${USERNAME}', '${PASSWORD}');
INSERT INTO Roles VALUES ('superuser', '${USERNAME}');
INSERT INTO Roles VALUES ('authenticated', '${USERNAME}');" | \
    java -cp "${DERBY_JARS}" \
             "${DASHD_URL}"  \
             org.apache.derby.tools.ij #&>/dev/null

echo
echo "Following users are superusers:"
echo "SELECT Username FROM Roles WHERE RoleName='superuser';" | \
        java -cp "${DERBY_JARS}" \
                 "${DASHD_URL}"  \
                 org.apache.derby.tools.ij

exit 0

