#!/bin/sh

# eagle-i Data Repository Installation - Final Step
# Create admin user metadata, AND load data model ontology
#
#  WARNING: THIS *MUST* be executed with tomcat running.
#
# Started Nov 2010
# $Id: finish-install.sh 5837 2010-11-30 00:55:42Z lcs14 $
# Author: Larry Stone

#-------- temp directory boilerplate - cleanup on exit
tmpDir="/tmp/ei-finish-install-$$"
mkdir $tmpDir
cleanup () {
  rm -rf $tmpDir
}
trap cleanup EXIT

usage="Usage: $0  [ -f firstname ] [ -l lastname ] [ -m mailbox ] admin-username  password  repository-URL-prefix"

firstname="x1=y"
lastname="x2=y"
mbox="x3=y"

if [ $1 = '--version' ]; then
    echo "$0 from release 1.1-MS5.00 SCM revision 7289"
    exit 0
fi
while [ $# -gt 4 ]; do
   case "$1" in
      -f)
            firstname="firstname=$2"; shift; shift;;
      -l)
            lastname="lastname=$2"; shift; shift;;
      -m)
            mbox="mbox=$2"; shift; shift;;
      *)
            echo "Unknown option $1"
            echo $usage
            exit 1;;
    esac
done
if [ $# -ne 3 ]; then
      echo $usage
      exit 1
fi
username=$1
password=$2
repoURL=$3

login="${username}:${password}"

#--------------  Step 1 - finish admin user creation by adding RDF metadata
out=${tmpDir}/whoami.out
status=`curl -k -s -S -o "$out" -u "$login" -d create=true -d "$firstname" \
 -d "$lastname" -d "$mbox" --write-out '%{http_code}\n' "${repoURL}/repository/whoami"`
cmd=$?
if [ "${cmd}" -ne 0 ]; then
    echo "FAILED to send whoami command to repository: curl command status: $cmd"
    exit 1
elif [ "$status" = "409" ]; then
    echo "User \"${username}\" already has metadata, skipping."
elif [ "$status" != "201" ]; then
    echo "FAILED to create metadata for user, HTTP status=$status"
    test -f "$out" && cat "$out"
    exit 2
else
    echo "User metadata created."
fi

#---------- step 2 - load data model ontology from jar

out2=${tmpDir}/model.out
status=`curl -k -s -S -o "$out2" -u "$login" -d action=load -d source=jar \
    --write-out '%{http_code}\n' "${repoURL}/repository/model"`
cmd=$?
if [ "${cmd}" -ne 0 ]; then
    echo "FAILED to send model command to repository: curl command status: $cmd"
    exit 4
elif [ "$status" = "200" -o "$status" = "201" ]; then
    echo "Loaded data model ontology from jar."
else
    echo "FAILED to load data model, HTTP status=$status"
    test -f "$out2" && cat "$out2"
    exit 3
fi
