#!/bin/bash

# Move "everything" from one repo to another
#
#   * * * * *    W A R N I N G    * * * * *
#
# THIS IS VERY DANGEROUS AND EVEN WHEN IT WORKS AS INTENDED IT IS A BAD IDEA.
#
# It makes a quasi-functional clone of a repo's data
# This script grabs ALL of the resource and user data from one repo,
# EDITS it to replace all of the locally-prefixed URIs with the prefix for
# the destination site so they appear to be "local" there.  Since it is
# replacing all of the data on the destination repo there is no possibility
# of colliding with URIs already present there; in that sense this is
# fairly "safe".  However, it still has the following problems:
#
# 1. Since the resources are such accurate copies they might be confused
#    with the prototypes.  This would be bad.
#
# 2. If users are in a position to access both the copy and the original
#    they might not be able to tell the difference and would make updates
#    to the wrong site.
#
# 3. Claims and other admin metadata are preserved.  Caveat emptor.
#
# 4. The same user accounts, INCLUDING PASSWORDS, will work on destination.
#
# Copies made with this script MUST be treated as TEMPORARY AND DISPOSABLE
# for these reasons.
#
# $Id: move-everything.sh 8841 2011-04-14 03:15:05Z rd67 $
# Author: Larry Stone

#------- Constants

format=application/x-trig

# useful namespace prefixs
repo="http://eagle-i.org/ont/repo/1.0/"
owl="http://www.w3.org/2002/07/owl#"
rdfs="http://www.w3.org/2000/01/rdf-schema#"

#-------- boilerplate
# keep files in /tmp subdir, cleanup on exit
tmpDir="/tmp/repo-moveevery-$$"
mkdir $tmpDir

cleanup () {
  ## XXX insert echo here to retain the tmp work dir
  rm -rf $tmpDir
}
trap cleanup EXIT

# dump resources
# Usage: $0  login url  file
doGetResources () {
    local login=${1}
    local repoURL=$2
    local toFile=$3

    local status=""
    if status=`curl -k -s -G -u "${login}" -o "${toFile}" -d all=true \
      --write-out '%{http_code}' -d "format=${format}" "${repoURL}/repository/graph"`; then
        if [ "$status" != "200" ]; then
            echo "HTTP Request to get graph dump failed, status=${status}"
            if [ -f "$toFile" ]; then
                echo "Response document:"
                cat "$toFile"
            fi
            return 1
        fi
    else
        echo "curl failed to send HTTP request to get graph dump."
        return 1
    fi
    return 0
}

# dump users
# Usage: $0  login url  file
doGetUsers () {
    local login=${1}
    local repoURL=$2
    local toFile=$3

    local status=""
    if status=`curl -k -s -G -u "${login}" -o "${toFile}" -d type=user -d "exclude=${excludeUsers}" \
        --write-out '%{http_code}' -d "format=${format}" "${repoURL}/repository/export"` ; then
        if [ "$status" != "200" ]; then
            echo "HTTP Request to get user dump failed, status=${status}"
            if [ -f "$toFile" ]; then
                echo "Response document:"
                cat "$toFile"
            fi
            return 1
        fi
    else
        echo "curl failed to send HTTP request to get user dump."
        return 1
    fi
    return 0
}


# upload resources to destination
# Usage: $0  login url  file
doPutResources () {
    local login=${1}
    local repoURL=$2
    local fromFile=$3

    local status=""
    if status=`curl -k -s -u "${login}" -F all=true -F action=replace \
      -F "format=${format}" -F "content=@$fromFile" \
      --write-out '%{http_code}' "${repoURL}/repository/graph"`; then
        if [ "$status" != "201" ]; then
            echo "HTTP Request to PUT graph dump failed, status=${status}"
            return 1
        fi
    else
        echo "curl failed to send HTTP request to PUT graph dump."
        return 1
    fi
    return 0
}

# upload users to destination
# Usage: $0  login url  file
doPutUsers () {
    local login=${1}
    local repoURL=$2
    local fromFile=$3

    local status=""
    if status=`curl -k -s -u "${login}" -F type=user -F duplicate=replace \
      -F transform=no -F "format=${format}" -F "content=@$fromFile" \
      --write-out '%{http_code}' "${repoURL}/repository/import"`; then
        if [ "$status" != "200" ]; then
            echo "HTTP Request to /import users failed, status=${status}"
            return 1
        fi
    else
        echo "curl failed to send HTTP request to /import users."
        return 1
    fi
    return 0
}

# Usage: $0  login  url
# returns the URI prefix of the repo
getPrefix () {
    local login=${1}
    local repoURL=$2

    local tmp=${tmpDir}/prefix.txt
    local status=""
    rm -f ${tmp}

    if status=`curl -k -s -u "${login}" -o "${tmp}" -d format=text/plain \
                --write-out '%{http_code}' "${repoURL}/repository/new"`; then
        if [ "$status" != "200" ]; then
            echo "HTTP Request /new to get URI prefix failed, status=${status}"
            if [ -f "$tmp" ]; then
                echo "Response document:"
                cat "$tmp"
            fi
            return 1
        fi
    else
        echo "curl failed to send HTTP request to get URI prefix."
        return 1
    fi
    tail -n +2 "${tmp}" | egrep -o '^(.+/)'
}

# Usage: $0 login repoURL username filepath
saveAdminUser () {
    local login=${1}
    local repoURL=$2
    local username=$3
    local out=$4
    local status=""
    rm -f "$out"

    # export the admin user's state
    if status=`curl -k -s -S -G -u "${login}" -o "${out}" -d type=user \
                -d "include=$username" -d format=${format} \
                --write-out '%{http_code}' "${repoURL}/repository/export"`; then
        if [ "$status" != "200" ]; then
            echo "HTTP Request /export to get admin user failed, status=${status}"
            if [ -f "$out" ]; then
                echo "Response document:"
                cat "$out"
            fi
            return 1
        fi
    else
        echo "curl failed to send HTTP request to get /export, status=$?"
        return 1
    fi
}


# Usage: $0 login repoURL username filepath
# fix admin login user if necessary - check if it has URI, if not, invoke /whoami to create
restoreAdminUser () {
    local login=${1}
    local repoURL=$2
    local username=$3
    local in=$4
    local status=""
    local out=${tmpDir}/restore.out

    if status=`curl -k -s -u "${login}" -F type=user -F duplicate=replace \
      -F "include=$username" -F transform=no -F "format=${format}" -F "content=@$in" \
      --write-out '%{http_code}' "${repoURL}/repository/import"`; then
        if [ "$status" != "200" ]; then
            echo "HTTP Request to import admin user failed, status=${status}"
            return 1
        fi
    else
        echo "curl failed to send HTTP request to import admin user."
        return 1
    fi
    return 0
}

# move to-repo from a file-based resource file (trig format)

moveResourcesFromFile() {
		
		if toPrefix=`getPrefix "$toLogin" "$toURL"` ; then
		    true
		else
		    echo "Failed getting prefix for destination."
		    echo $toPrefix
		    exit 1
		fi
		
		
		
		     
		## Transform
		prog="\$f=quotemeta('${fromPrefix}'); while (<>) {s@<\${f}@<${toPrefix}@g;print}"
		if perl -CSD -e "$prog" < $resources > $newResources ; then
		    true
		else
		    echo "Transformation of resource data failed, see error messages above."
		    exit 1
		fi
		
		
		
		echo -n "  uploading RDF contents to ${toURL}...."
		if doPutResources "$toLogin" "$toURL" "$newResources" ; then
		    echo "done."
		else
		    echo "FAILED uploading resource contents."
		    exit 1
		fi


}

#
# canonical move everything from-repo to-repo

moveEverythingFromRepo() {
		
		## Get URL prefixes
		if fromPrefix=`getPrefix "$fromLogin" "$fromURL"` ; then
		    true
		else
		    echo "Failed getting prefix for source."
		    echo $fromPrefix
		    exit 1
		fi
		
		
		if toPrefix=`getPrefix "$toLogin" "$toURL"` ; then
		    true
		else
		    echo "Failed getting prefix for destination."
		    echo $toPrefix
		    exit 1
		fi
		
		# Save current state of the admin user for later restoration:
		adminUser=${tmpDir}/adminUser.trig
		if saveAdminUser "$toLogin" "$toURL" "$toUsername" "$adminUser" ; then
		    echo "  Saved state of user $toUsername"
		else
		    echo "Failed to save state of user $toUsername"
		    exit 1
		fi
		
		echo -n "  fetching RDF contents from ${fromURL}..."
		if doGetResources "$fromLogin" "$fromURL" "$resources" ; then
		    echo "done."
		else
		    echo "FAILED fetching source contents."
		    exit 1
		fi
		
		if $moveUsers ; then
		    echo -n "  fetching users from ${fromURL}..."
		    if doGetUsers "$fromLogin" "$fromURL" "$users" ; then
		        echo "done."
		    else
		        echo "FAILED fetching source users."
		        exit 1
		    fi
		fi
		     
		## Transform
		prog="\$f=quotemeta('${fromPrefix}'); while (<>) {s@<\${f}@<${toPrefix}@g;print}"
		if perl -CSD -e "$prog" < $resources > $newResources ; then
		    true
		else
		    echo "Transformation of resource data failed, see error messages above."
		    exit 1
		fi
		
		if $moveUsers ; then
		    if perl -CSD -e "$prog" < $users > $newUsers ; then
		        true
		    else
		        echo "Transformation of user data failed, see error messages above."
		        exit 1
		    fi
		fi
		
		echo -n "  uploading RDF contents to ${toURL}...."
		if doPutResources "$toLogin" "$toURL" "$newResources" ; then
		    echo "done."
		else
		    echo "FAILED uploading resource contents."
		    exit 1
		fi
		
		if $moveUsers ; then
		    echo -n "  uploading users to ${toURL}..."
		    if doPutUsers "$toLogin" "$toURL" "$newUsers" ; then
		        echo "done."
		    else
		        echo "FAILED uploading users"
		        exit 1
		    fi
		fi
		
		if restoreAdminUser "$toLogin" "$toURL" "$toUsername" "$adminUser"; then
		    echo "  Restored state of user $toUsername"
		else
		    echo "Failed to restore state of user $toUsername"
		    exit 1
		fi


}


#------------------  Main ----------------------------
usage="Usage: $0  [--version] [ -f | --force ] [ --nousers ] [ --exclude-users userlist ] from-username  from-password  from-repo-URL  to-username  to-password  to-repo-URL"
usage="${usage} \nUsage: $0  [--version] [ -f | --force ] [--resourcefile path-to-resource-file] from-prefix to-username  to-password  to-repo-URL "
excludeUsers=""
moveUsers=true

while echo "$1" | grep -q "^-"; do
    case "$1" in
        --version)
            echo "$0 from release ${project.version} SCM revision ${buildNumber}"
            exit 0 ;;
        -f|--force)
            forceOption=true ;;
        --exclude-users)
            shift;
            excludeUsers="$1" ;;
        --nousers)
            moveUsers=false ;;
        --resourcefile)
        	shift;
            resourceFilemove=true;
            resourceFile="$1" ;;  
        -*)
              echo "Unknown option $1"
              echo -e $usage
              exit 1;;
    esac
    shift
done

# check to see if we are copying resources from a local file 
# and check that the file exists

if [ "${resourceFilemove:false}" != true ]; then 
	if [ $# -ne 6 ]; then
	    echo -e $usage
	    exit 1
	fi
else
	if [ $# -ne 4 ]; then
		echo $usage
		exit 1
	fi
	if [ ! -f ${resourceFile} ]; then
		echo "resource file doesn't exist"
		exit 1
	fi
fi

if [ "${forceOption:false}" != true ]; then

    echo "*************************************"
    echo "*****  DANGER! DANGER! DANGER!  *****   This is a VERY DANGEROUS procedure, and"
    echo "*****  DANGER! DANGER! DANGER!  *****   even when it works as intended it is a"
    echo "*****  DANGER! DANGER! DANGER!  *****   VERY BAD IDEA.  Reply YES below ONLY "
    echo "*****  DANGER! DANGER! DANGER!  *****   if you KNOW what will happen and are "
    echo "*****  DANGER! DANGER! DANGER!  *****   STILL SURE you want to continue."
    echo "*****  DANGER! DANGER! DANGER!  ***** "
    echo "*****  DANGER! DANGER! DANGER!  *****   This will ***DESTROY*** ALL contents"
    echo "*****  DANGER! DANGER! DANGER!  *****   of the repository on the repository at:"
    echo "*****  DANGER! DANGER! DANGER!  *****      $toURL "
    echo "*************************************"
    echo ""
    echo -n "Are you STILL sure you want to continue? "
    read answer
    if echo "$answer" | egrep -iq '^[[:space:]]*y(es)?'; then
        echo "OK, continuing..."
    else
        echo "Aborting."
        exit 0
    fi
fi

#  invoke moveResourcesFromFile or moveEverythingFromRepo depending on the 
# --resourcefile option being used

if [ "${resourceFilemove:false}" != true ]; then
	fromLogin="${1}:$2"
	fromURL=$3
	toLogin="${4}:$5"
	toURL=$6
	toUsername=$4
	# paths
	resources=${tmpDir}/resources.trig
	users=${tmpDir}/users.trig
	newResources=${tmpDir}/newResources.trig
	newUsers=${tmpDir}/newUsers.trig
	moveEverythingFromRepo
else
	# TODO: parse fromPrefix in a more sane way, this is hacky and brittle
	fromPrefix="${1}/i/"
	toLogin="${2}:$3"
	toURL=$4
	# paths
	resources=${resourceFile}
	users=${tmpDir}/users.trig
	newResources=${tmpDir}/newResources.trig
	moveResourcesFromFile	
fi







