package org.eaglei.repository.servlet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletException;

import org.apache.log4j.Logger;
import org.apache.log4j.LogManager;
import org.openrdf.query.impl.DatasetImpl;

import org.openrdf.model.vocabulary.RDFS;

import org.eaglei.repository.View;
import org.eaglei.repository.NamedGraph;
import org.eaglei.repository.vocabulary.REPO;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.status.BadRequestException;

/**
 * Returns a listing of available named graphs.
 * Optional type param narrows it down to a given ngType.
 *
 * XXX This really needs to be reimplemented with NamedGraph class,
 *     but since it works for now that is not a priority.
 *
 *   XXX the spec calls for filtering list on "add" and "remove" access
 *   XXX controls, but we're not doing it yet (if ever).
 *
 * @author Larry Stone
 * @version $Id: $
 */
public class ListGraphs extends RepositoryServlet
{
    private static Logger log = LogManager.getLogger(ListGraphs.class);

    /** {@inheritDoc} */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
        throws ServletException, java.io.IOException
    {
        doGet(request, response);
    }

    /** {@inheritDoc} */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
        throws ServletException, java.io.IOException
    {
        String format = request.getParameter("format");
        String type = request.getParameter("type");

        DatasetImpl uds = new DatasetImpl();
        View.addGraphs(request, uds, View.USER);

        StringBuilder query = new StringBuilder();
        query.append("SELECT DISTINCT * WHERE { ?namedGraphURI a <").
          append(REPO.NAMED_GRAPH).append("> . \n").
          append(" OPTIONAL { ?namedGraphURI <").
          append(RDFS.LABEL).append("> ?namedGraphLabel } \n").
          append(" OPTIONAL { ?namedGraphURI <").append(REPO.NG_TYPE).
          append("> ?typeURI . ?typeURI <").append(RDFS.LABEL).append("> ?typeLabel } \n");

        // sanity-check and add type predicate if arg was specified..
        if (type != null) {
            NamedGraph.Type ngt = NamedGraph.Type.parse(type);
            if (ngt == null)
                throw new BadRequestException("Unrecognized graph type: "+type);
            query.append(" FILTER( ?typeURI = <"+ngt.uri+"> )");
        }

        // XXX the spec calls for filtering list on "add" and "remove" access
        // XXX controls, but we're not doing it yet (if ever).

        query.append(" }");
        SPARQL.tupleQueryRequest(request, response, query.toString(), format, SPARQL.InternalGraphs);
    }
}
