package org.eaglei.repository.servlet;

import org.eaglei.repository.*;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.ServletException;

import java.io.IOException;

import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;

import org.apache.log4j.Logger;
import org.apache.log4j.LogManager;

/**
 * Give wrapped servlet a Sesame repository connection with
 * automatic cleanup.
 *
 * @author Larry Stone
 * @version $Id: $
 */
public class WithRepositoryConnection implements Filter
{
    private static Logger log = LogManager.getLogger(WithRepositoryConnection.class);

    private static final String ATTR_CONNECTION = "org.eaglei.repository.RepositoryConnection";

    /** {@inheritDoc} */
    public void init(FilterConfig fc)
        throws ServletException
    {}
    /**
     * <p>destroy</p>
     */
    public void destroy()
    {}

    /**
     * Gets RepositoryConnection from where the filter stashed it.
     *
     * @param request a {@link javax.servlet.ServletRequest} object.
     * @return a {@link org.openrdf.repository.RepositoryConnection} object.
     */
    public static RepositoryConnection get(ServletRequest request)
    {
        return (RepositoryConnection)request.getAttribute(ATTR_CONNECTION);
    }

    // XXX this should use a pool for efficiency, if we can figure
    //  see http://commons.apache.org/pool/
    //   out when it is safe to reuse a connection.. (and do commit/rollback)
    /** {@inheritDoc} */
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain fc)
        throws IOException, ServletException
    {
        RepositoryConnection rc = null;
        try {
            try {
                rc = DataRepository.getInstance().getSesameRepository().getConnection();
                rc.setAutoCommit(false);
                req.setAttribute(ATTR_CONNECTION, rc);
                log.debug("Providing RepositoryConnection = "+rc);
                fc.doFilter(req, resp);

            } finally {

                // XXX NOTE:
                // XXX If we get here without commit(), changes are lost!

                if (rc != null) {
                    log.debug("Closing RepositoryConnection = "+rc);
                    rc.close();
                }
                req.setAttribute(ATTR_CONNECTION, null);
            }
        } catch (RepositoryException e) {
            throw new ServletException(e);
        }
    }
}
