/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.DataRepository;
import org.eaglei.repository.Formats;
import org.eaglei.repository.NamedGraph;
import org.eaglei.repository.View;
import org.eaglei.repository.servlet.Harvest;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.HttpStatusException;
import org.eaglei.repository.status.InternalServerErrorException;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.vocabulary.DCTERMS;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.query.resultio.QueryResultIO;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultWriter;
import org.openrdf.repository.RepositoryConnection;

public class Harvest
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(Harvest.class);
    private static final String DELETED_PREFIX = "info:/deleted#";
    private static final String[] column = new String[]{"subject", "predicate", "object"};
    private static List<String> columnNames = null;
    private static final String detailIdNoTimeQuery = "SELECT DISTINCT ?subject WHERE \n{ ?subject a ?typ}";
    private static final String detailFullNoTimeQuery;
    private static final String deletedFromTimeQueryProlog;
    private static final String deletedAndWithdrawnFromTimeQuery;
    private static final String deletedNotWithdrawnFromTimeQuery;
    private static final String identifierFromTimeQuery;
    private static final String fullFromTimeQuery;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String format = request.getParameter("format");
        String rawview = request.getParameter("view");
        String rawws = request.getParameter("workspace");
        boolean inferred = Utils.parseBooleanParameter((String)request.getParameter("inferred"), (String)"inferred", (boolean)false, (boolean)false);
        String rawfrom = request.getParameter("from");
        String rawdetail = request.getParameter("detail");
        View view = null;
        if (request.getParameter("until") != null) {
            throw new HttpStatusException(501, "The 'until' arg is not implemented yet.");
        }
        DetailArg detail = (DetailArg)Utils.parseKeywordArg(DetailArg.class, (String)rawdetail, (String)"detail", (boolean)true, null);
        XMLGregorianCalendar from = null;
        if (rawfrom != null) {
            from = Utils.parseXMLDate((String)rawfrom);
        }
        if (detail == DetailArg.identifier && inferred) {
            throw new BadRequestException("The 'inferred' arg is not allowed when detail = identifier.");
        }
        if (rawws != null && rawview != null) {
            throw new BadRequestException("The 'view' and 'workspace' arguments are mutually exclusive.  Choose only one.");
        }
        URI workspace = Utils.parseURI((String)rawws, (String)"workspace", (boolean)false);
        try {
            TupleQuery q;
            NamedGraph.Type ngt;
            String mimeType = Formats.negotiateTupleContent((HttpServletRequest)request, (String)format, (String)"application/sparql-results+xml");
            TupleQueryResultFormat tqf = QueryResultIO.getWriterFormatForMIMEType((String)mimeType);
            if (tqf == null) {
                throw new InternalServerErrorException("Failed to get tuple query format that SHOULD have been available, for mime=" + mimeType);
            }
            response.setContentType(mimeType);
            TupleQueryResultWriter out = QueryResultIO.createWriter((TupleQueryResultFormat)tqf, (OutputStream)response.getOutputStream());
            Date lm = DataRepository.getInstance().getLastModified();
            response.addDateHeader("Last-Modified", lm.getTime());
            if (from != null) {
                if (lm.before(from.toGregorianCalendar().getTime())) {
                    log.debug((Object)("Optimizing result since last-modified mark is earlier than from: last-mod = " + lm));
                    out.startQueryResult(columnNames);
                    out.endQueryResult();
                    return;
                }
                log.debug((Object)("Going ahead with query, last-modified mark is after 'from': last-mod = " + lm));
            }
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            ValueFactory vf = rc.getValueFactory();
            DatasetImpl ds = new DatasetImpl();
            if (workspace != null) {
                View.addWorkspaceGraphs((HttpServletRequest)request, (DatasetImpl)ds, (URI)workspace);
            } else {
                View view2 = view = rawview == null ? View.PUBLISHED_RESOURCES : View.parseView((String)rawview);
                if (view == null) {
                    throw new BadRequestException("Unknown view: " + rawview);
                }
                View.addGraphs((HttpServletRequest)request, (DatasetImpl)ds, (View)view);
            }
            log.debug((Object)("Dataset derived from initial 'view' or 'workspace' args = " + Utils.prettyPrint((Dataset)ds)));
            DatasetImpl resDS = new DatasetImpl();
            for (URI g : ds.getDefaultGraphs()) {
                if (REPO.NG_USERS.equals(g)) continue;
                NamedGraph ng = NamedGraph.find((HttpServletRequest)request, (URI)g);
                NamedGraph.Type type = ngt = ng == null ? null : ng.getType();
                if (ngt != NamedGraph.Type.published && ngt != NamedGraph.Type.workspace) continue;
                SPARQL.addGraph((DatasetImpl)resDS, (URI)g);
            }
            if (from == null) {
                log.debug((Object)("Resource Dataset = " + Utils.prettyPrint((Dataset)resDS)));
                if (detail == DetailArg.identifier) {
                    log.debug((Object)("HARVEST QUERY NO TIME (detail=" + detail + ") = \n" + detailIdNoTimeQuery));
                    TupleQuery q2 = rc.prepareTupleQuery(QueryLanguage.SPARQL, detailIdNoTimeQuery);
                    q2.setDataset((Dataset)resDS);
                    q2.setIncludeInferred(false);
                    q2.evaluate((TupleQueryResultHandler)out);
                } else {
                    Set dg = resDS.getDefaultGraphs();
                    URI[] resGraphs = dg.toArray(new URI[dg.size()]);
                    if (inferred) {
                        SPARQL.addGraph((DatasetImpl)resDS, (URI)REPO.NG_INFERRED);
                    }
                    log.debug((Object)("HARVEST QUERY NO TIME (detail=" + detail + ") = \n" + detailFullNoTimeQuery));
                    q = rc.prepareTupleQuery(QueryLanguage.SPARQL, detailFullNoTimeQuery);
                    q.setDataset((Dataset)resDS);
                    q.setIncludeInferred(inferred);
                    out.startQueryResult(columnNames);
                    for (URI graph : resGraphs) {
                        log.debug((Object)("Getting FULL Resource Instances from graph=" + graph));
                        q.clearBindings();
                        q.setBinding("graph", (Value)graph);
                        q.evaluate((TupleQueryResultHandler)new wrappedHandler((TupleQueryResultHandler)out));
                    }
                    out.endQueryResult();
                }
            } else {
                DatasetImpl dds = new DatasetImpl();
                for (NamedGraph ng : NamedGraph.findAll((HttpServletRequest)request)) {
                    ngt = ng.getType();
                    log.debug((Object)("for DDS, Trying NamedGraph type=" + ngt + ", name=" + ng.getName()));
                    if (ngt != NamedGraph.Type.published && ngt != NamedGraph.Type.workspace && ngt != NamedGraph.Type.metadata) continue;
                    SPARQL.addGraph((DatasetImpl)dds, (URI)ng.getName());
                }
                String qs = REPO.NG_WITHDRAWN.equals(workspace) ? deletedNotWithdrawnFromTimeQuery : deletedAndWithdrawnFromTimeQuery;
                log.debug((Object)("Resource DELETE Dataset = " + Utils.prettyPrint((Dataset)dds)));
                log.debug((Object)("HARVEST QUERY DELETED/WITHDRAWN (detail=" + detail + ") = \n" + qs));
                q = rc.prepareTupleQuery(QueryLanguage.SPARQL, qs);
                q.setDataset((Dataset)dds);
                q.setIncludeInferred(false);
                q.setBinding("from", (Value)vf.createLiteral(from));
                out.startQueryResult(detail == DetailArg.identifier ? columnNames.subList(0, 1) : columnNames);
                q.evaluate((TupleQueryResultHandler)new deletedHandler((TupleQueryResultHandler)out, detail));
                Set dg = resDS.getDefaultGraphs();
                URI[] resGraphs = dg.toArray(new URI[dg.size()]);
                SPARQL.addGraph((DatasetImpl)resDS, (URI)REPO.NG_METADATA);
                if (inferred) {
                    SPARQL.addGraph((DatasetImpl)resDS, (URI)REPO.NG_INFERRED);
                }
                q = rc.prepareTupleQuery(QueryLanguage.SPARQL, detail == DetailArg.identifier ? identifierFromTimeQuery : fullFromTimeQuery);
                q.setDataset((Dataset)resDS);
                q.setIncludeInferred(inferred);
                Literal lfrom = vf.createLiteral(from);
                for (URI graph : resGraphs) {
                    log.debug((Object)("Getting non-deleted Resource Instances mod. since=" + from + ", from graph=" + graph));
                    q.clearBindings();
                    q.setBinding("from", (Value)lfrom);
                    q.setBinding("graph", (Value)graph);
                    q.evaluate((TupleQueryResultHandler)new wrappedHandler((TupleQueryResultHandler)out));
                }
                out.endQueryResult();
            }
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
    }

    static /* synthetic */ List access$000() {
        return columnNames;
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }

    static /* synthetic */ String[] access$200() {
        return column;
    }

    static {
        columnNames = Arrays.asList(column);
        detailFullNoTimeQuery = "SELECT ?subject ?predicate ?object WHERE \n{{GRAPH ?graph {?subject a ?typ . GRAPH <" + REPO.NG_INFERRED + "> {?subject ?predicate ?object}}}\n" + " UNION {GRAPH ?graph {?subject a ?typ; ?predicate ?object}}} ORDER BY ?subject";
        deletedFromTimeQueryProlog = "SELECT DISTINCT ?subject WHERE \n{ GRAPH <" + REPO.NG_METADATA + "> { ?subject <" + DCTERMS.MODIFIED + "> ?mod}\n" + " FILTER(?mod >= ?from)\n" + " OPTIONAL{ GRAPH ?g {?subject a ?t}} \n";
        deletedAndWithdrawnFromTimeQuery = deletedFromTimeQueryProlog + "  FILTER(!bound(?t) || ?g = <" + REPO.NG_WITHDRAWN + ">) }\n" + "ORDER BY ?subject";
        deletedNotWithdrawnFromTimeQuery = deletedFromTimeQueryProlog + "  FILTER(!bound(?t)) }\n" + "ORDER BY ?subject";
        identifierFromTimeQuery = "SELECT DISTINCT ?subject WHERE \n{ GRAPH <" + REPO.NG_METADATA + "> { ?subject <" + DCTERMS.MODIFIED + "> ?mod}\n" + " FILTER( ?mod >= ?from )" + " GRAPH ?graph {?subject a ?type}} ORDER BY ?mod";
        fullFromTimeQuery = "SELECT DISTINCT ?subject ?predicate ?object WHERE \n{ GRAPH <" + REPO.NG_METADATA + "> { ?subject <" + DCTERMS.MODIFIED + "> ?mod}\n" + " FILTER( ?mod >= ?from )" + " {{GRAPH ?graph {?subject a ?type; ?predicate ?object}} UNION \n" + "  {GRAPH <" + REPO.NG_INFERRED + "> {?subject ?predicate ?object}}}} ORDER BY ?subject";
    }
}

