<!--
   The Eagle-I Data Repository backup GUI page.
-->
<%@ page import="org.eaglei.repository.DataRepository" %>
<jsp:useBean id="adminBean" class="org.eaglei.repository.admin.AuthAdminBean" scope="session"/>
<jsp:setProperty name="adminBean" property="request" value="<%= request %>" />

<html>
  <head>
    <title>Eagle-I Administration - Database Backup</title>
  </head>
    <body bgcolor=lightyellow>
    <%@ include file="/repository/admin/banner.jsp" %>
        <h3>Authentication Database Backup</h3>
        <p>This backup only covers the repository internal user authentication data. The user authorization data is a separate data set
        contained within the repository data itself. It is contained in a full backup of the RDF data. To backup the user-authorization data please consult the
        <a href=https://sites.google.com/a/eagle-i.org/workspace/build-team-workspace/data-repository-workspace/cycle-1-repository-documentation/>Backup and Restore RDF Contents</a>
        section of the manual.</p>
        <p>An Authentication Database Backup is a set of files that is written into a target directory onto the server. A backup can only be written into the server side
        dedicated backup directory.</p>
        <h4>Create a new backup folder:</h4>
        <form method="POST" action="/repository/admin/backup.jsp" >
          <table border="0" cellspacing="5">
            <tr>
              <th align="right"><tt><b><%= DataRepository.getInstance().getBackupDirectory().toString() %>/</tt></b></th>
              <td align="left"><input type="text" name="backupDir"></td>
            </tr>
            <tr>
              <td align=right><input type=reset></td>
              <td align=left><input type=submit value="Backup now!"></td>
            </tr>
          </table>
        </form>
        <h4>...or select an existing folder to overwrite from the list:</h4>
        <form method="POST" action="/repository/admin/backup.jsp" >
          <table border="0" cellspacing="5">
            <tr>
              <th valign=top align=right><tt><b><%= DataRepository.getInstance().getBackupDirectory().toString() %>/</tt></b></th>
              <td align="left"><SELECT NAME="backupDir" SIZE=20>
<%
   java.util.ArrayList<String> list = adminBean.getBACKUPList();
   if (list.isEmpty()){
      out.println("<OPTION><i>&lt;directory is empty&gt;</i></OPTION>");
   } else {
      java.util.Iterator<String> itr = list.iterator();
      while (itr.hasNext()) {
         String fname = itr.next();
         out.println( "<OPTION> " + String.valueOf( fname ) + "</OPTION>");
      }
   }
%>
      </SELECT></td>
            </tr>
            <tr>
              <td align="right"><input type="reset"></td>
              <td align="left"><input type="submit" value="Backup now!"></td>
            </tr>
          </table>
        </form>
        <a href="/repository/admin/index.jsp">Back to the repository admin main page</a>
  </body>
</html>
