<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
<%--
   -  "Portal" (or frame-content) page to change user password, and
   -  optionally, other user metadata.
   -
   -  Invoke it with the only_password arg (no value needed) to get a form
   -  that only offers inputs to change the password.
   -
   -  OPTIONAL ARGS: (also passed through form)
   -   username  - principal name of user to change, defaults to authenticated
   -   only_password - if specified, do not include other metadata inputs.
   -  Args set by form:
   -   password - new password
   -   password_confirm - must match new password
   -   first - first name
   -   last - last name
   -   mailbox - mailbox
   -   submit - present when "submit" button is pressed
   -
   -  @author Larry Stone
   -  Started Jul 2010, @version $Id: $
  --%>
<%@ page import="java.sql.Connection" %>
<%@ page import="org.apache.commons.lang.StringEscapeUtils" %>
<%@ page import="org.openrdf.model.URI" %>
<%@ page import="org.eaglei.repository.status.ErrorSendingException" %>
<%@ page import="org.apache.log4j.Logger" %>
<%@ page import="org.apache.log4j.LogManager" %>
<%@ page import="org.eaglei.repository.Access" %>
<%@ page import="org.eaglei.repository.User" %>
<%@ page import="org.eaglei.repository.admin.AuthUser" %>
<%@ page import="org.eaglei.repository.status.BadRequestException" %>
<%@ page import="org.eaglei.repository.status.NotFoundException" %>
<%!
    private static boolean isDifferent(String a, String b)
    {
        return a == null && b != null ||
                a != null && b == null ||
                !((a == null && b == null) || a.equals(b));
    }
%>
<%
    Logger log = LogManager.getLogger("org.eaglei.repository.admin.editUserPortlet.jsp");

    // feedback message about status of any chosen operation
    String message = null;
    boolean messageSuccess = true;

    boolean onlyPassword = request.getParameter("only_password") != null;
    String password = request.getParameter("password");
    String password_confirm = request.getParameter("password_confirm");
    String first = request.getParameter("first");
    String last = request.getParameter("last");
    String mailbox = request.getParameter("mailbox");
    String submit = request.getParameter("submit");
    String username = request.getParameter("username");
    final String empty = "";
    if (empty.equals(first))
        first = null;
    if (empty.equals(last))
        last = null;
    if (empty.equals(mailbox))
        mailbox = null;

    try {
        User uu = null;
        if (username == null) {
            uu = Access.getPrincipalUser(request);
            if (uu == null)
                throw new BadRequestException("There is no authenticated user.");
            else
                username = uu.getUsername();
        } else {
            uu = User.findUsername(request, username);
            if (uu == null)
                throw new NotFoundException("Cannot find a user named: "+username);
        }

        if (submit == null) {
            if (first == null)
                first = uu.getFirstName();
            if (last == null)
                last = uu.getLastName();
            if (mailbox == null)
                mailbox = uu.getMbox();
        } else {
            boolean passwordChanged = false;

            // NOTE: input of type password will be "", not null, even when nothing was entered.
            if (password != null && password.length() > 0) {
                if (password_confirm != null && password.equals(password_confirm)) {
                    // XXX log.debug("Got password = \""+password+"\", confirm = \""+password_confirm+"\"");
                    AuthUser au = AuthUser.find(username);
                    if (au == null) {
                        message = "User not found in authentication database: "+username;
                        messageSuccess = false;
                    } else {
                        au.setPassword(password);
                        Connection c = AuthUser.startTransaction();
                        try {
                            au.update(c);
                            AuthUser.commitTransaction(c);
                            c = null;
                            log.debug("Changed the password.");
                            passwordChanged = true;
                        } finally {
                            if (c != null)
                                AuthUser.abortTransaction(c);
                        }
                    }
                } else {
                    message = "Password was not confirmed or versions do not match.";
                    messageSuccess = false;
                }
            }

            boolean changed = false;
            if (messageSuccess && !onlyPassword) {
                if (isDifferent(first, uu.getFirstName())) {
                    uu.setFirstName(request, first);
                    log.debug("Changed first name = "+first);
                    changed = true;
                }
                if (isDifferent(last, uu.getLastName())) {
                    uu.setLastName(request, last);
                    log.debug("Changed last name = "+last);
                    changed = true;
                }
                if (isDifferent(mailbox, uu.getMbox())) {
                    uu.setMbox(request, mailbox);
                    log.debug("Changed mbox = "+mailbox);
                    changed = true;
                }
                if (changed)
                    uu.update(request);
            }
            if ((changed || passwordChanged) && messageSuccess)
                message = "User has been modified.";
        }
    } catch (ErrorSendingException e) {
        response.sendError(e.getStatus(), e.getMessage());
    }
%>
  <head>
    <title>Eagle-I Data Repository - Edit User Metadata</title>
  </head>
  <body>
<%
    if (message != null) {
%>
      <h3><font color="<%= messageSuccess ? "GREEN" : "RED" %>">
          <%= messageSuccess ? "Success" : "FAILED" %>: <%= StringEscapeUtils.escapeHtml(message) %>
          </font>
     </h3>
<%
    }
%>

    <form action="">
      <input type="hidden" name="username" value="<%= username %>"/>
<%
    if (onlyPassword) {
%>
      <input type="hidden" name="only_password" value="true"/>
<%
    } else {
%>
      <label for="id_first"><b>First Name:</b> </label>
      <input type="text" name="first" id="id_first" size="30" value="<%= first == null ?  "" :  first %>"/>
      <br/>
      <label for="id_last"><b>Last Name:</b> </label>
      <input type="text" name="last" id="id_last" size="30" value="<%= last == null ? "" : last %>"/>
      <br/>
      <label for="id_mailbox"><b>Mailbox:</b> </label>
      <input type="text" name="mailbox" id="id_mailbox" size="40" value="<%= mailbox == null ? "" : mailbox %>"/>
<%
    }
%>
      <br/>
      <label for="id_password"><b>Password:</b> </label>
      <input type="password" name="password" id="id_password" size="20"/>
      <br/>
      <label for="id_password_confirm"><b>Confirm Password:</b> </label>
      <input type="password" name="password_confirm" id="id_password_confirm" size="20"/>
      <br/>
      &nbsp;&nbsp;&nbsp;&nbsp;
      <button type="reset">Reset Form</button>
      &nbsp;&nbsp;&nbsp;&nbsp;
      <button name="submit" value="submit" type="submit">Submit</button>
    </form>

  </body>
</html>
