<%@ page import="org.eaglei.repository.DataRepository" %>
<jsp:useBean id="adminBean" class="org.eaglei.repository.admin.AuthAdminBean" scope="session"/>
<% adminBean.reset(); %>
<jsp:setProperty name="adminBean" property="remoteUser" value="<%= request.getRemoteUser() %>" />
<jsp:setProperty name="adminBean" property="remoteIsSuperuser" value="<%= request.isUserInRole(adminBean.getSymbol_RoleSuperuser()) %>" />
<jsp:setProperty name="adminBean" property="request" value="<%= request %>" />
<% adminBean.initRoles(request); %>
<html>
  <head>
    <title>Eagle-I Repository Administration - Welcome!</title>
  </head>
        <body bgcolor=lightyellow>
    <%@ include file="/repository/admin/banner.jsp" %>
    <h3>Status and Configuration</h3>
    <ul>
      <li>Logged in as: <tt><b><%= request.getRemoteUser() %></b></tt></li>
      <li>Repository webapp version: <tt><b><%= DataRepository.getInstance().getProjectVersion() %></b></tt>,
          built on <tt><b><%= DataRepository.getInstance().getTimestamp() %></b></tt>,
          from source version <tt><b><%= DataRepository.getInstance().getRevision() %></b></tt>
          </li>
      <li>Java info:  <a href="<%= System.getProperty("java.vendor.url") %>">
                  <%= System.getProperty("java.vendor") %></a>
                version <tt><b><%= System.getProperty("java.version") %></b></tt>
          </li>
      <li>JVM info:  <%= System.getProperty("java.vm.vendor") %>
                version <tt><b><%= System.getProperty("java.vm.version") %></b></tt>,
                named <tt><b><%= System.getProperty("java.vm.name") %></b></tt>,
                installed in <tt><b><%= System.getProperty("java.home") %></b></tt>
          </li>
      <li>JVM Memory: <tt><b><%= String.format("%,d", Runtime.getRuntime().totalMemory()) %></b></tt>  bytes allocated,
                      <tt><b><%= String.format("%,d", Runtime.getRuntime().freeMemory()) %></b></tt>  bytes free,
                      <tt><b><%= String.format("%,d", Runtime.getRuntime().maxMemory()) %></b></tt>  bytes maximum available.
                          <a href="memory-report.jsp"><i>More Details...</i></a>
          <br></li>
      <li>Default RDF Namespace: <tt><b><%= DataRepository.getInstance().getDefaultNamespace() %></b></tt></li>
      <li>Home Directory: <tt><b><%= DataRepository.getInstance().getHomeDirectory().toString() %></b></tt></li>
      <li>Log Directory: <tt><b><%= DataRepository.getInstance().getConfigurationProperty("eaglei.repository.log.dir", "<i>not set, defaults to home-dir</i><tt>/logs</tt>") %></b></tt></li>
<%
        String xslt = DataRepository.getInstance().getConfigurationProperty("eaglei.repository.instance.xslt");
        if (xslt != null) {
%>
      <li>Dissemination XSLT stylesheet: <tt><b><%= xslt %></b></tt></li>
<%
        }
%>
    </ul>

        <h3>User Tasks</h3>
        <ul>
          <li>
            <A HREF="/repository/logout">Logout</A>
<i>(You must also clear browser credentials, see <a href="#f1">[1]</a> below.)</I>
          </li>
          <li>
            <A HREF="/repository/query/">SPARQL Query Workbench</A>
          </li>
          <li>
            <A HREF="/repository/admin/updateUserIfc.jsp?username=<%= adminBean.getRemoteUser() %>">Manage your login account...</A>
          </li>
        </ul>

<% if (request.isUserInRole(adminBean.getSymbol_RoleSuperuser())){ %>
        <h3>Administrator Tasks</h3>
        <ul>
          <li>
            <A HREF="/repository/admin/addUserIfc.jsp">Add a new user.</A>
          </li>
          <li>
            <A HREF="/repository/admin/selectUserIfc.jsp">Manage an existing user...</A>
          </li>
          <li>
            <A HREF="/repository/admin/retireUserIfc.jsp">Retire a user from the Repository...</A>
          </li>
          <li>
            <A HREF="/repository/admin/backupDbIfc.jsp">Backup the Authentication Database...</A>
          </li>
          <li>
            <a href="/repository/admin/namedGraphs.jsp">Manage Named Graphs</a>
          </li>
          <li>
            <a href="/repository/model">Show Data Model Ontology versions</a>
          </li>
        </ul>
<% } %>

<h3>Help Topics</h3>
<ol>
  <li>
<p><a name="f1"><b>Clearing Browser Authentication:</b></a>
The repository uses
<a href="http://www.ietf.org/rfc/rfc2617.txt">
HTTP Basic Authentication</a> to identify users.
Most web browsers cache the last basic auth entry and don't offer an easy
way to clear it.</p>
<p>
For Mozilla Firefox 3, try the
<a href="https://addons.mozilla.org/en-US/firefox/addon/60/">Web Developer add-on</a>
and select <b>Miscellaneous->Clear Private Data->HTTP Authentication</b> from
its menus.</p>
  </li>
</ol>


  </body>
</html>

 
