package org.eaglei.repository.status;

import org.eaglei.repository.status.ErrorSendingException;

/**
 * Superclass for exceptions that get turned into HTTP status codes in
 * the response by a servlet wrapper class.  Since it is a subclass of
 * RuntimeException, methods can throw without bothering to declare it.
 * These are picked up by the RepositoryServlet.service() wrapper
 * and, if possible, turned into status codes in the HTTP response.
 *
 * @author lcs
 * @version $Id: $
 */
public class HttpStatusException extends ErrorSendingException
{
    private int status = 0;

    /**
     * <p>Getter for the field <code>status</code>.</p>
     *
     * @return a int.
     */
    public int getStatus()
    {
        return status;
    }

    /**
     * <p>Constructor for HttpStatusException.</p>
     *
     * @param status a int.
     * @param message a {@link java.lang.String} object.
     */
    public HttpStatusException(int status, String message)
    {
        super(message);
        this.status = status;
    }
}
