/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.format;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import org.openrdf.query.BindingSet;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultWriter;

public class SPARQLTextWriter
implements TupleQueryResultWriter {
    public static TupleQueryResultFormat theFormat = new TupleQueryResultFormat("Plain Old Text", "text/plain", ".txt");
    private PrintStream out = null;
    private List<String> columns = null;

    public SPARQLTextWriter(OutputStream out) {
        this.out = new PrintStream(out);
    }

    public TupleQueryResultFormat getTupleQueryResultFormat() {
        return theFormat;
    }

    public void startQueryResult(List<String> bindingNames) throws TupleQueryResultHandlerException {
        this.columns = bindingNames;
        for (String bn : bindingNames) {
            this.out.print(bn + "\t");
        }
        this.out.println();
    }

    public void endQueryResult() throws TupleQueryResultHandlerException {
    }

    public void handleSolution(BindingSet bs) throws TupleQueryResultHandlerException {
        for (String bn : this.columns) {
            this.out.print(bs.hasBinding(bn) ? bs.getValue(bn).toString() : " ");
            this.out.print("\t");
        }
        this.out.println();
    }
}

