/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Access;
import org.eaglei.repository.DataRepository;
import org.eaglei.repository.EditToken;
import org.eaglei.repository.FakeFlow;
import org.eaglei.repository.NamedGraph;
import org.eaglei.repository.Provenance;
import org.eaglei.repository.View;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.servlet.Update;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.ConflictException;
import org.eaglei.repository.status.ForbiddenException;
import org.eaglei.repository.status.HttpStatusException;
import org.eaglei.repository.status.NotFoundException;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.util.Utils;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Graph;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.BooleanLiteralImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.Dataset;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.query.impl.MapBindingSet;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;

/*
 * Exception performing whole class analysis ignored.
 */
public class Update
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(Update.class);

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String rawaction = null;
        String deleteMIMEType = null;
        Reader deleteStream = null;
        String insertMIMEType = null;
        Reader insertStream = null;
        String format = null;
        String workspace = null;
        String rawuri = null;
        String rawtoken = null;
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            try {
                ServletFileUpload upload = new ServletFileUpload();
                upload.setFileItemFactory((FileItemFactory)new DiskFileItemFactory(100000, (File)this.getServletConfig().getServletContext().getAttribute("javax.servlet.context.tempdir")));
                for (DiskFileItem item : upload.parseRequest(request)) {
                    String ifn = item.getFieldName();
                    if (ifn.equals("action")) {
                        rawaction = item.getString();
                        continue;
                    }
                    if (ifn.equals("delete")) {
                        deleteStream = new InputStreamReader(item.getInputStream());
                        deleteMIMEType = item.getContentType();
                        continue;
                    }
                    if (ifn.equals("insert")) {
                        insertStream = new InputStreamReader(item.getInputStream());
                        insertMIMEType = item.getContentType();
                        continue;
                    }
                    if (ifn.equals("format")) {
                        format = item.getString();
                        continue;
                    }
                    if (ifn.equals("workspace")) {
                        workspace = item.getString();
                        continue;
                    }
                    if (ifn.equals("uri")) {
                        rawuri = item.getString();
                        continue;
                    }
                    if (ifn.equals("token")) {
                        rawtoken = item.getString();
                        continue;
                    }
                    log.warn((Object)("Unrecoginized request argument: " + ifn));
                }
            }
            catch (FileUploadException e) {
                log.error((Object)e);
                throw new BadRequestException("failed parsing multipart request");
            }
        } else {
            String insert;
            rawaction = request.getParameter("action");
            String delete = request.getParameter("delete");
            if (delete != null) {
                deleteStream = new StringReader(delete);
            }
            if ((insert = request.getParameter("insert")) != null) {
                insertStream = new StringReader(insert);
            }
            format = request.getParameter("format");
            workspace = request.getParameter("workspace");
            rawuri = request.getParameter("uri");
            rawtoken = request.getParameter("token");
        }
        if (rawaction == null) {
            throw new BadRequestException("Missing required argument 'action'");
        }
        Action action = null;
        try {
            action = Action.valueOf((String)rawaction);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Illegal value for 'action', must be one of: " + Arrays.deepToString(Action.values()));
        }
        if (rawuri == null) {
            String pi = request.getPathInfo();
            if (pi == null || pi.length() == 0) {
                throw new BadRequestException("Missing required instance URI to view.");
            }
            rawuri = DataRepository.getInstance().getDefaultNamespace() + pi.substring(1);
        }
        if (!Utils.isValidURI((String)rawuri)) {
            throw new BadRequestException("Instance URI must be a legal absolute URI: " + rawuri);
        }
        log.debug((Object)("Got request uri=" + rawuri));
        if (action != Action.gettoken) {
            if (workspace == null) {
                if (action == Action.create) {
                    throw new BadRequestException("The 'workspace' argument is required when creating a new instance.");
                }
            } else if (!Utils.isValidURI((String)workspace)) {
                throw new BadRequestException("The 'workspace' must be a legal absolute URI: " + workspace);
            }
        }
        try {
            URI wsURI;
            boolean hasCreator = false;
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            ValueFactory vf = rc.getValueFactory();
            URI uri = null;
            try {
                uri = vf.createURI(rawuri);
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException("Resource URI is malformed: " + rawuri);
            }
            DatasetImpl ds = new DatasetImpl();
            View.addGraphs((HttpServletRequest)request, (DatasetImpl)ds, (View)View.USER);
            log.debug((Object)("Dataset for SPARQL query = " + Utils.prettyPrint((Dataset)ds)));
            URI uRI = wsURI = workspace == null ? null : vf.createURI(workspace);
            if (action == Action.create) {
                if (rc.hasStatement((Resource)uri, RDF.TYPE, null, false, new Resource[0])) {
                    throw new BadRequestException("This resource already exists so 'create' is not allowed: " + uri);
                }
            } else {
                URI homeGraph = this.getHomeGraph(rc, uri, (Dataset)ds);
                if (homeGraph == null) {
                    throw new NotFoundException("Resource not found in this repository: " + uri.toString());
                }
                if (wsURI == null) {
                    wsURI = homeGraph;
                } else if (!wsURI.equals(homeGraph)) {
                    throw new BadRequestException("Resource not found in specified workspace, its home graph is: " + homeGraph.toString());
                }
            }
            log.debug((Object)("Final workspace URI = " + wsURI.toString()));
            if (action == Action.gettoken) {
                boolean created = false;
                EditToken et = EditToken.find((HttpServletRequest)request, (URI)uri);
                if (et == null) {
                    created = true;
                    et = EditToken.create((HttpServletRequest)request, (URI)uri);
                    WithRepositoryConnection.get((ServletRequest)request).commit();
                }
                ArrayList<MapBindingSet> results = new ArrayList<MapBindingSet>(1);
                MapBindingSet bs = new MapBindingSet(5);
                bs.addBinding("token", (Value)et.getURI());
                bs.addBinding("created", (Value)new LiteralImpl(et.getCreated(), XMLSchema.DATETIME));
                bs.addBinding("creator", (Value)et.getCreator());
                bs.addBinding("creatorLabel", (Value)new LiteralImpl(et.getCreatorLabel()));
                bs.addBinding("new", (Value)new BooleanLiteralImpl(created));
                results.add(bs);
                SPARQL.sendTupleQueryResults((HttpServletRequest)request, (HttpServletResponse)response, (String)format, results);
                return;
            }
            NamedGraph wng = NamedGraph.find((HttpServletRequest)request, (URI)wsURI);
            if (wng == null) {
                throw new BadRequestException("Invalid workspace, this is not a named graph: " + wsURI);
            }
            NamedGraph.Type wngt = wng.getType();
            if (wngt != NamedGraph.Type.published && wngt != NamedGraph.Type.workspace) {
                throw new BadRequestException("Resource is not in an appropriate workspace, ws = " + wsURI);
            }
            if (action == Action.create && deleteStream != null) {
                throw new BadRequestException("Delete is not allowed when creating a new resource.");
            }
            if (action == Action.update) {
                if (rawtoken == null) {
                    throw new BadRequestException("Missing the argument 'token', which is required when updating.");
                }
                URI token = null;
                try {
                    token = vf.createURI(rawtoken);
                }
                catch (IllegalArgumentException e) {
                    throw new BadRequestException("URI for token is malformed: " + rawtoken);
                }
                EditToken et = EditToken.find((HttpServletRequest)request, (URI)uri);
                if (et == null) {
                    log.info((Object)("Update was not accepted because token was already gone: " + uri));
                    throw new ConflictException("The resource instance you were updating has already been changed, so this update cannot be accepted since it would undo the previous update. If you still wish to make changes to this resource, you must open it for editing again: " + uri);
                }
                if (!et.getURI().equals(token)) {
                    log.info((Object)("Update was not accepted because token did not match: " + uri + ", current token=" + et));
                    throw new ConflictException("The resource instance you were updating has already been changed, AND ANOTHER UPDATE IS IN PROGRESS.  This update cannot be accepted since it would undo the previous update.  If you still wish to make changes to this resource, you must open it for editing again, but be warned that an update session was started at " + et.getCreated() + " by the user " + et.getCreatorLabel());
                }
                et.clear(request);
            }
            if (action == Action.create) {
                if (insertStream != null && !Access.hasPermission((HttpServletRequest)request, (Resource)wsURI, (Access)Access.ADD)) {
                    throw new ForbiddenException("User is not permitted to create new resource instance in named graph: " + wsURI);
                }
            } else {
                if (insertStream != null && !Access.hasPermission((HttpServletRequest)request, (Resource)uri, (Access)Access.ADD)) {
                    throw new ForbiddenException("User is not permitted to insert into resource instance: " + uri);
                }
                if (deleteStream != null && !Access.hasPermission((HttpServletRequest)request, (Resource)uri, (Access)Access.REMOVE)) {
                    throw new ForbiddenException("User is not permitted to delete from resource instance: " + uri);
                }
            }
            Graph removes = null;
            Graph inserts = null;
            if (deleteStream != null) {
                removeHandler rh = new removeHandler(this, rc, uri, wsURI);
                removes = this.parseGraph(deleteStream, "delete", format == null ? deleteMIMEType : format, (graphHandler)rh, vf);
            }
            if (insertStream != null) {
                insertHandler ih = new insertHandler(this, rc, action, uri, wsURI);
                inserts = this.parseGraph(insertStream, "insert", format == null ? insertMIMEType : format, (graphHandler)ih, vf);
                hasCreator = insertHandler.access$000((insertHandler)ih);
                insertHandler.access$100((insertHandler)ih);
            }
            if (removes != null && inserts != null) {
                Iterator ri = removes.iterator();
                while (ri.hasNext()) {
                    Statement rs = (Statement)ri.next();
                    if (!inserts.contains((Object)rs)) continue;
                    ri.remove();
                    log.debug((Object)("Optimized out statement remove+insert: " + rs));
                    if (inserts.remove((Object)rs)) continue;
                    log.debug((Object)("Failed to remove statement from inserts too: " + rs));
                }
            }
            if (removes != null) {
                rc.remove(removes, new Resource[]{wsURI});
            }
            if (inserts != null) {
                rc.add(inserts, new Resource[]{wsURI});
            }
            log.info((Object)(action + ": Deleted " + String.valueOf(removes == null ? 0 : removes.size()) + " statements and added " + String.valueOf(inserts == null ? 0 : inserts.size()) + " statements for " + uri + " in workspace " + wsURI.toString()));
            if (action == Action.create) {
                if (inserts == null) {
                    throw new BadRequestException("Request to create an instance must include the insert graph.");
                }
                FakeFlow ff = FakeFlow.create((HttpServletRequest)request, (URI)uri);
                log.debug((Object)("Started fake workflow on resource inst=" + uri + ", WF state=" + ff.getState()));
            } else if (action == Action.update) {
                if (rc.hasStatement((Resource)uri, null, null, false, new Resource[]{wsURI})) {
                    if (!rc.hasStatement((Resource)uri, RDF.TYPE, null, false, new Resource[]{wsURI})) {
                        throw new BadRequestException("This update request would leave the resource instance without any rdf:type statements, which is not allowed unless ALL statements are removed.");
                    }
                } else {
                    log.info((Object)("Deleted resource: " + uri));
                }
            }
            if (inserts != null || removes != null) {
                Date now = new Date();
                Provenance p = new Provenance(uri);
                if (action == Action.create) {
                    if (hasCreator) {
                        p.setMediated(request, now);
                    } else {
                        p.setCreated(request, now);
                    }
                } else {
                    p.setModified(request, now);
                }
            } else {
                throw new BadRequestException("Request must include at least one of the insert or delete graphs.");
            }
            rc.commit();
        }
        catch (UnsupportedOperationException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        catch (RepositoryException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
    }

    private Graph parseGraph(Reader graphStream, String mode, String rawFormat, graphHandler gh, ValueFactory vf) throws ServletException, IOException {
        if (rawFormat == null) {
            throw new BadRequestException("Content-type (MIME Type) of the insert argument was not specified.");
        }
        RDFFormat rf = RDFFormat.forMIMEType((String)rawFormat);
        if (rf == null) {
            throw new HttpStatusException(415, "MIME type of " + mode + " argument is not supported: \"" + rawFormat + "\"");
        }
        RDFParser parser = Rio.createParser((RDFFormat)rf, (ValueFactory)vf);
        parser.setRDFHandler((RDFHandler)gh);
        try {
            parser.parse(graphStream, "");
        }
        catch (RDFParseException e) {
            throw new BadRequestException("Error parsing " + mode + " statements: " + e.toString());
        }
        catch (RDFHandlerException e) {
            throw new ServletException((Throwable)e);
        }
        return graphHandler.access$200((graphHandler)gh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URI getHomeGraph(RepositoryConnection rc, URI instance, Dataset ds) throws RepositoryException {
        URI result = null;
        RepositoryResult rr = null;
        try {
            rr = rc.getStatements((Resource)instance, RDF.TYPE, null, false, new Resource[0]);
            while (rr.hasNext()) {
                Statement s = (Statement)rr.next();
                Resource ctx = s.getContext();
                log.debug((Object)("Found statement: " + instance + " rdf:type " + s.getObject() + ", in graph " + ctx));
                if (ctx == null || !(ctx instanceof URI) || !ds.getDefaultGraphs().contains(ctx) && !ds.getNamedGraphs().contains(ctx)) continue;
                if (result == null) {
                    result = (URI)ctx;
                    continue;
                }
                if (result.equals(ctx)) continue;
                log.warn((Object)("Found rdf:type statements for instance=<" + instance + "> in two different graphs: " + ctx + ", " + result));
            }
        }
        finally {
            rr.close();
        }
        return result;
    }

    static /* synthetic */ Logger access$400() {
        return log;
    }
}

