<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
<%--
   -  Admin - display and edit the properties of a single Named Graph
   -  Also offer link to the page to edit its ACL.
   -  REQUIRED ARGS:
   -   name = (uri) name of the named graph
   -  ARGS TO CHANGE PROPERTIES:
   -   label = textual label for the graph
   -   type = type of graph
   -   submit
  --%>

<%@ page import="java.io.IOException" %>
<%@ page import="java.util.Arrays" %>
<%@ page import="java.util.Collection" %>
<%@ page import="org.apache.commons.lang.StringEscapeUtils" %>
<%@ page import="org.openrdf.model.URI" %>
<%@ page import="org.openrdf.repository.RepositoryConnection" %>
<%@ page import="org.eaglei.repository.NamedGraph" %>
<%@ page import="org.eaglei.repository.Provenance" %>
<%@ page import="org.eaglei.repository.servlet.WithRepositoryConnection" %>
<%@ page import="org.eaglei.repository.status.ErrorSendingException" %>
<%@ page import="org.eaglei.repository.vocabulary.DCTERMS" %>

<%@ page import="javax.servlet.http.HttpServletResponse" %>
<%@ page import="org.apache.log4j.Logger" %>
<%@ page import="org.apache.log4j.LogManager" %>
<%@ page import="org.openrdf.model.Literal" %>
<%@ page import="org.openrdf.model.Value" %>
<%@ page import="org.openrdf.model.URI" %>
<%@ page import="org.openrdf.model.impl.URIImpl" %>
<%@ page import="org.eaglei.repository.NamedGraph" %>
<%@ page import="org.eaglei.repository.status.ErrorSendingException" %>
<%@ page import="org.eaglei.repository.servlet.WithRepositoryConnection" %>
  <head>
    <title>Eagle-I Data Repository Admin - Edit Named Graph Metadata</title>
  </head>

<%!
    // output a provenance "entry" for created or modified, they are similar.
    private void provEntry(HttpServletRequest request, JspWriter out, Provenance p, String label, String when, String who)
        throws IOException
    {
        if (when == null)
            return;
        String whoLabel = null;
        if (who != null)
            whoLabel = p.getField(request, new URIImpl(who));
        out.append("<li><b>").append(label).append(":</b> <tt>").
            append(when).append("</tt>");
        if (who != null) {
            out.append(", by ");
            if (whoLabel == null)
                out.append(who);
            else
                out.append("<a href=\"").append(who).append("\">").
                    append(whoLabel).append("</a>");
        }
        out.append("</li>");
    }
%>


<%
    try {
        // feedback message about status of any chosen operation
        String message = null;
        boolean messageSuccess = false;

        // sanity-check args
        String rawname = request.getParameter("name");
        if (rawname == null) {
            response.sendError(HttpServletResponse.SC_BAD_REQUEST, "Missing the required argument 'name'");
            return;
        }

        URI name = null;
        try {
            name = new URIImpl(rawname);
        } catch (IllegalArgumentException e) {
            response.sendError(HttpServletResponse.SC_BAD_REQUEST, "Illegal URI for name: "+e);
            return;
        }
        NamedGraph ng = NamedGraph.find(request, name);
        if (ng == null) {
            response.sendError(HttpServletResponse.SC_BAD_REQUEST, "Not a named graph or unmanaged context URI: "+name);
            return;
        }

        // if request to modify properties was submitted there will be
        // value for 'submit' and others:
        String type = request.getParameter("type");
        String label = request.getParameter("label");
        if (request.getParameter("submit") != null) {
            if (type != null && type.length() > 0 &&
                label != null && label.length() > 0) {
                URI utype = null;
                try {
                    utype = new URIImpl(type);
                } catch (IllegalArgumentException e) {
                    response.sendError(HttpServletResponse.SC_BAD_REQUEST, "Illegal URI for type: "+e);
                    return;
                }
                ng.setLabel(request, label);
                ng.setType(request, utype);
                ng.commit(request);
                messageSuccess = true;
                message = "Named Graph has been modified.";
            } else {
                messageSuccess = false;
                message = "You must supply values for label and type.";
            }
        }

        String slabel = ng.getLabel();
        if (slabel == null)
            slabel = "";
%>
  <body>
    <%@ include file="/repository/admin/banner.jsp" %>
    <h2 align="center">Edit Named Graph Metadata</h2>
    <h3 align="center"><tt><%= name.toString() %></tt></h3>
<%
    if (message != null) {
%>
      <h3><font color="<%= messageSuccess ? "GREEN" : "RED" %>">
          <%= messageSuccess ? "Success" : "FAILED" %>: <%= StringEscapeUtils.escapeHtml(message) %>
          </font>
     </h3>
<%
    }
%>

<%
    Provenance p = new Provenance(name);
    String created = p.getField(request, DCTERMS.CREATED);
    String creator = p.getField(request, DCTERMS.CREATOR);
    String modified = p.getField(request, DCTERMS.MODIFIED);
    String contributor = p.getField(request, DCTERMS.CONTRIBUTOR);
    String sourceIdentifier = p.getField(request, DCTERMS.SOURCE_IDENTIFIER);
    String sourceModified = p.getField(request, DCTERMS.SOURCE_MODIFIED);
    if (created != null || modified != null || sourceIdentifier != null) {
%>
    <h3>Provenance Metadata:</h3>
    <ul>
<%
        provEntry(request, out, p, "Created", created, creator);
        provEntry(request, out, p, "Last modified", modified, contributor);
%>

<%
        if (sourceIdentifier != null) {
%>
        <li><b>From:</b> <tt><%= sourceIdentifier %></tt>
<%
            if (sourceModified != null) {
%>, last modified <tt><%= sourceModified %></tt>
<%
            }
%>
        </li>
<%
        }
%>
    </ul>
<%
    }
%>

    <form action="">
      <fieldset style="width: 80%; align: center;">
       <legend><b>Modify Named Graph Properties</b></legend>
       <input type="hidden" name="name" value="<%= name.toString() %>"/>
       <p><b>Label:</b> <input type="text" name="label" size="50" value="<%= slabel %>"/>
       </p>
       <p><b>Named Graph Type:</b> <select name="type">
<%
    if (ng.getType() == null) {
%>
          <option selected="t" value=""> --none-- </option>
<%
    }
    for (NamedGraph.Type t : NamedGraph.Type.values()) {
%>
          <option <%= t == ng.getType() ? "selected=\"t\"" : "" %>
            value="<%= t.uri %>">
            <%= StringEscapeUtils.escapeHtml(t.getTitle()) %>
          </option>
<%
    }
%>
        </select>
        </p>
        <div width="50%" align="left">
          <div width="50%" align="center">
            <button type="reset">Reset Form</button>
            &nbsp;&nbsp;&nbsp;&nbsp;
            <button name="submit" value="submit" type="submit">Submit</button>
          </div>
        </div>
      </fieldset>
    </form>

    <form  action="/repository/admin/editGrants.jsp">
      <fieldset style="width: 80%; align: center;">
       <legend><b>Change Named Graph Access</b></legend>
      <input type="hidden" name="type" value="Named Graph" />
      <input type="hidden" name="label" value="<%= slabel %>"/>
      <input type="hidden" name="uri" value="<%= ng.getName() %>"/>
      <button type="submit">Edit ACL</button><i> (Leaves this page)</i>
     </fieldset>
    </form>
    <p></p>
    <p>
    <a href="/repository/admin/namedGraphs.jsp">Return to Named Graphs</a>
    </p>
    <p>
    <a href="/repository/admin/index.jsp">Return to Admin top level</a>
    </p>
  </body>
<%
    // see "try" at start of body tag.
    } catch (ErrorSendingException e) {
        response.sendError(e.getStatus(), e.getMessage());
    }
%>
</html>
