package org.eaglei.repository.status;

import org.eaglei.repository.status.ErrorSendingException;
import javax.servlet.http.HttpServletResponse;

/**
 * Signal a fatal runtime error that should result in a
 * 406 (Not Acceptable) status returned to the HTTP client.
 *
 * @author lcs
 * @version $Id: $
 */
public class NotAcceptableException extends ErrorSendingException
{

    private static final long serialVersionUID = 1L;
    
    /**
     * <p>getStatus</p>
     *
     * @return a int.
     */
    public int getStatus()
    {
        return HttpServletResponse.SC_NOT_ACCEPTABLE;
    }
    /**
     * <p>Constructor for NotAcceptableException.</p>
     *
     * @param message a {@link java.lang.String} object.
     */
    public NotAcceptableException(String message)
    {
        super(message);
    }
    /**
     * <p>Constructor for NotAcceptableException.</p>
     *
     * @param message a {@link java.lang.String} object.
     * @param cause a {@link java.lang.Throwable} object.
     */
    public NotAcceptableException(String message, Throwable cause)
    {
        super(message, cause);
    }
    /**
     * <p>Constructor for NotAcceptableException.</p>
     *
     * @param cause a {@link java.lang.Throwable} object.
     */
    public NotAcceptableException(Throwable cause)
    {
        super(cause);
    }
}
