package jsp.repository.admin;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import java.sql.Connection;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.openrdf.model.impl.URIImpl;
import org.eaglei.repository.status.ErrorSendingException;
import org.apache.log4j.Logger;
import org.apache.log4j.LogManager;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.Access;
import org.eaglei.repository.Role;
import org.eaglei.repository.User;
import org.eaglei.repository.admin.AuthUser;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.ForbiddenException;
import org.eaglei.repository.status.NotFoundException;
import org.eaglei.repository.DataRepository;

public final class editUserPortlet_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {


    private static boolean isDifferent(String a, String b)
    {
        return a == null && b != null ||
                a != null && b == null ||
                !((a == null && b == null) || a.equals(b));
    }
    // return null if param is empty string
    private String getNonEmptyParameter(HttpServletRequest request, String name)
    {
        String result = request.getParameter(name);
        if (result != null && result.length() == 0)
            return null;
        return result;
    }
    private String acceptCharset = "UTF-8";

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List _jspx_dependants;

  static {
    _jspx_dependants = new java.util.ArrayList(1);
    _jspx_dependants.add("/repository/admin/banner.jsp");
  }

  private javax.el.ExpressionFactory _el_expressionfactory;
  private org.apache.AnnotationProcessor _jsp_annotationprocessor;

  public Object getDependants() {
    return _jspx_dependants;
  }

  public void _jspInit() {
    _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
    _jsp_annotationprocessor = (org.apache.AnnotationProcessor) getServletConfig().getServletContext().getAttribute(org.apache.AnnotationProcessor.class.getName());
  }

  public void _jspDestroy() {
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;


    try {
      response.setContentType("text/html;charset=UTF-8");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;

      out.write("\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\" xml:lang=\"en\">\n");
      out.write("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
      out.write('\n');

    Logger log = LogManager.getLogger("org.eaglei.repository.admin.editUserPortlet.jsp");

    // feedback message about status of any chosen operation
    String message = null;
    boolean messageSuccess = true;

    // MUST call this before getting any parameters
    request.setCharacterEncoding(acceptCharset);
    boolean standalone = request.getParameter("standalone") != null;
    boolean onlyPassword = request.getParameter("only_password") != null;
    boolean createAuth = request.getParameter("create_auth") != null;
    String submit = request.getParameter("submit");
    String password = getNonEmptyParameter(request, "password");
    String password_confirm = getNonEmptyParameter(request, "password_confirm");
    String first = getNonEmptyParameter(request, "first");
    String last = getNonEmptyParameter(request, "last");
    String mailbox = getNonEmptyParameter(request, "mailbox");
    String username = getNonEmptyParameter(request, "username");
    String roleURI[] = request.getParameterValues("role");

    if (log.isDebugEnabled()) {
        if (first != null)
            log.debug("first=\""+first+"\", bytes="+Utils.toString(first.getBytes(acceptCharset)));
        if (last != null)
            log.debug("last=\""+last+"\", bytes="+Utils.toString(last.getBytes(acceptCharset)));
    }
    try {

        // Get user metadata object UNLESS putting up form to create new user
        // Create MD object if necessary, assuming an "undocumented" auth user.
        User uu = null;
        if (!(createAuth && username == null)) {
            if (username == null) {
                uu = Access.getPrincipalUser(request);
                if (uu == null)
                    throw new BadRequestException("There is no authenticated user.");
                else
                    username = uu.getUsername();
            } else {
                uu = User.findUsername(request, username);
            }
        }

        // are we editing current user?
        boolean currentUser = request.getParameter("username") == null ||
            (uu != null && uu.getURI().equals(Access.getPrincipalURI(request)));

        // present the form, with existing values filled in
        if (submit == null) {
            if (uu != null) {
                first = uu.getFirstName();
                last = uu.getLastName();
                mailbox = uu.getMbox();
            }

        // execute the requested changes
        } else {

            // sanity check: username and password required
            if (username == null)
                throw new BadRequestException("You must enter a Username.");

            // sanity check password
            if (password != null || password_confirm != null) {
                if (!(password != null && password_confirm != null &&
                      password.equals(password_confirm)))
                    throw new BadRequestException("Password values do not match.");
            }

            // create or reinstate a user - must be admin!
            if (createAuth) {
                if (!Access.isSuperuser(request))
                    throw new ForbiddenException("Only an Administrator may create or reinstate a user.");

                if (password == null)
                    throw new BadRequestException("You must enter a Password when creating or reinstating a user.");

                Connection c = AuthUser.startTransaction();
                try {
                    AuthUser.create(c, username, password, false);
                    AuthUser.commitTransaction(c);
                    c = null;
                } finally {
                    if (c != null)
                        AuthUser.abortTransaction(c);
                }

                // also create metadata object in RDF if necessary
                if (uu == null) {
                    uu = User.create(request, username);
                    uu.update(request);
                    log.debug("Created new authUser, username="+username);
                    message = "New user created.";
                } else {
                    log.debug("Reinstated authUser, username="+username);
                    message = "User reinstated.";
                }
                createAuth = false;

            // change password in exsiting AuthUser
            } else if (password != null) {
                if (!Access.hasPermissionOnUser(request, username))
                    throw new ForbiddenException("Not allowed to modify user: "+username);
                AuthUser au = AuthUser.find(username);
                if (au == null)
                    throw new NotFoundException("User not found in authentication database: "+username);
                if (currentUser) {
                    String oldPassword = request.getParameter("old_password");
                    if (oldPassword == null || !au.authenticate(oldPassword))
                        throw new ForbiddenException("Old password does not match, you are not allowed to update your password without it.");
                }
                au.setPassword(password);
                Connection c = AuthUser.startTransaction();
                try {
                    au.update(c);
                    AuthUser.commitTransaction(c);
                    c = null;
                    log.debug("Changed the password, username="+username);
                } finally {
                    if (c != null)
                        AuthUser.abortTransaction(c);
                }
                message = "Password changed.";
            }

            // edit user metadata
            if (!onlyPassword) {
                boolean changed = false;
                if (uu == null) {
                    log.debug("Creating new RDF User, for username="+username);
                    uu = User.create(request, username);
                    if (uu == null)
                        throw new NotFoundException("Failed creating a user named: "+username);
                    else
                        uu.update(request);
                }
                if (isDifferent(first, uu.getFirstName())) {
                    uu.setFirstName(request, first);
                    log.debug("Changed first name = "+first);
                    changed = true;
                }
                if (isDifferent(last, uu.getLastName())) {
                    uu.setLastName(request, last);
                    log.debug("Changed last name = "+last);
                    changed = true;
                }
                if (isDifferent(mailbox, uu.getMbox())) {
                    uu.setMbox(request, mailbox);
                    log.debug("Changed mbox = "+mailbox);
                    changed = true;
                }

                // update roles - let User object figure out diffs.
                if (Access.isSuperuser(request)) {
                    if (roleURI == null)
                        roleURI = new String[0];
                    Role role[] = new Role[roleURI.length];
                    for (int i = 0; i < roleURI.length; ++i)
                        role[i] = Role.find(request, new URIImpl(roleURI[i]));
                    if (uu.setRoles(request, role))
                        changed = true;
                }
                if (changed)
                    uu.update(request);
                if (changed && message == null && messageSuccess)
                    message = "User has been modified.";
            }
        }

      out.write("\n  <head>\n    <meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\"/>\n    <title>Eagle-I Data Repository - Edit User Metadata</title>\n");

        if (standalone) {

      out.write("\n              <style type=\"text/css\">\n                  .ei_required { color: red; }\n                  .eaglei_passwdForm form { margin: 30px 0; }\n                  .eaglei_passwdForm label { margin: 0 20px 5px 20px; }\n                  .eaglei_passwdForm input { margin: 5px 20px;  }\n              </style>\n            </head>\n            <body bgcolor=lightyellow>\n              ");
      out.write('\n');
      out.write("\n\n<hr/>\n    <table border=\"0\" width=\"100%\" >\n      <tr>\n        <td width=\"30%\"><a href=\"http://www.eagle-i.org/\"><img border=\"0\" alt=\"Institutional Logo\" align=\"right\"\n               src=\"");
      out.print( DataRepository.getInstance().getConfigurationProperty("eaglei.repository.logo", "/repository/images/eagle-i_admin_logo.png") );
      out.write("\" /></a>\n        </td>\n        <td width=\"40%\"><div align=\"center\">\n          <font size=\"+2\" color=\"black\">\n            Repository Administration Area\n          </font>\n          <p>");
      out.print( DataRepository.getInstance().getConfigurationProperty("eaglei.repository.title", "(Config property <tt>eaglei.repository.title</tt> needs to be set)") );
      out.write("</p>\n        </div></td>\n        <td width=\"30%\">&nbsp;</td>\n      </tr>\n    </table>\n<hr/>\n");
      out.write('\n');

            if (createAuth && submit == null) {

      out.write("\n                <h2>");
      out.print( username == null ? "Creating a New User" : "Reinstating: <tt>"+username+"</tt>" );
      out.write("</h2>\n");

            } else {

      out.write("\n                <h2>Editing ");
      out.print( currentUser ? "Current":"" );
      out.write(" User: <tt>");
      out.print( username );
      out.write("</tt></h2>\n");

                if (uu != null) {

      out.write("\n                    <h3>URI: <tt>");
      out.print( uu.getURI() );
      out.write("</tt></h3>\n");

                }
            }

      out.write("\n              <span class=\"ei_required\"><i>Input fields labelled in <b>RED</b> are <b>required</b></i></span>\n");

        } else {

      out.write("\n              <link REL=\"stylesheet\" TYPE=\"text/css\" HREF=\"/repository/styles/i.css\">\n            </head>\n            <body>\n");

        }
        if (message != null) {

      out.write("\n            <h3><font color=\"");
      out.print( messageSuccess ? "GREEN" : "RED" );
      out.write("\">\n                  ");
      out.print( messageSuccess ? "Success" : "FAILED" );
      out.write(':');
      out.write(' ');
      out.print( StringEscapeUtils.escapeHtml(message) );
      out.write("</font>\n            </h3>\n");

        }

      out.write("\n    <div class=\"eaglei_passwdForm\">\n     <form method=\"POST\" action=\"/repository/admin/editUserPortlet.jsp\" accept-charset=\"");
      out.print( acceptCharset );
      out.write('"');
      out.write('>');
      out.write('\n');

        if (standalone) {

      out.write("\n            <input type=\"hidden\" name=\"standalone\"/>\n");

        }
        if (createAuth && submit == null) {

      out.write("\n            <input type=\"hidden\" name=\"create_auth\"/>\n");

        }
        if (onlyPassword) {

      out.write("\n            <input type=\"hidden\" name=\"only_password\" value=\"true\"/>\n            <input type=\"hidden\" name=\"username\" value=\"");
      out.print( username );
      out.write("\"/>\n");

        } else {
            if (createAuth && submit == null && username == null) {

      out.write("\n                <label for=\"id_username\"><span class=\"ei_required\"><b>Username:</b> </span></label>\n                <input type=\"text\" name=\"username\" id=\"id_username\" size=\"30\" value=\"");
      out.print( username == null ?  "" :  username );
      out.write("\"/>\n                <br/>\n");

            } else {

      out.write("\n                <input type=\"hidden\" name=\"username\" value=\"");
      out.print( username );
      out.write("\"/>\n");

            }

      out.write("\n            <label for=\"id_first\"><b>First Name:</b> </label>\n            <input type=\"text\" name=\"first\" id=\"id_first\" size=\"30\" value=\"");
      out.print( first == null ?  "" :  first );
      out.write("\"/>\n            <br/>\n            <label for=\"id_last\"><b>Last Name:</b> </label>\n            <input type=\"text\" name=\"last\" id=\"id_last\" size=\"30\" value=\"");
      out.print( last == null ? "" : last );
      out.write("\"/>\n            <br/>\n            <label for=\"id_mailbox\"><b>Mailbox:</b> </label>\n            <input type=\"text\" name=\"mailbox\" id=\"id_mailbox\" size=\"40\" value=\"");
      out.print( mailbox == null ? "" : mailbox );
      out.write("\"/>\n");

        }

        // if this is changing our own password, request old password first:
        if (!createAuth && currentUser) {

      out.write("\n        <br/>\n        <label for=\"id_old_password\">\n          <span><b>Your Current Password:</b> </span>\n        </label>\n        <input type=\"password\" name=\"old_password\" id=\"id_old_password\" size=\"20\"/>\n");

        }

      out.write("\n        <br/>\n        <label for=\"id_password\">\n          <span class=\"");
      out.print( createAuth ? "ei_required" : "" );
      out.write("\"><b>");
      out.print( createAuth ? "" : "Change " );
      out.write("Password:</b> </span>\n        </label>\n        <input type=\"password\" name=\"password\" id=\"id_password\" size=\"20\"/>\n        <br/>\n        <label for=\"id_password_confirm\">\n          <span class=\"");
      out.print( createAuth ? "ei_required" : "" );
      out.write("\"><b>Confirm Password:</b> </span>\n        </label>\n        <input type=\"password\" name=\"password_confirm\" id=\"id_password_confirm\" size=\"20\"/>\n");

        if (!onlyPassword) {
            String disabled = Access.isSuperuser(request) ? "" : "disabled ";
            List<Role> roles = Role.findAllUserRoles(request);

      out.write("\n            <br/>\n            <label for=\"id_role\" style=\"vertical-align: top;\">\n              <b>Roles: </b>\n            </label>\n            <select name=\"role\" id=\"id_role\" ");
      out.print( disabled );
      out.write("\n                    multiple=\"true\" size=\"");
      out.print( roles.size() > 6 ? 6 : roles.size() );
      out.write('"');
      out.write('>');
      out.write('\n');

            for (Role r : roles) {
                boolean has = uu != null && uu.hasRoleP(r.getURI());

      out.write("\n                <option ");
      out.print( disabled );
      out.write(' ');
      out.print( has ? "selected" : "" );
      out.write(" value=\"");
      out.print( r.getURI() );
      out.write('"');
      out.write('>');
      out.print( r.getLabel() );
      out.write("</option>\n");

            }

      out.write("\n            </select>\n            <br/><label><i>Use CTRL-click or COMMAND-click to select / deselect multiple Roles.</i></label>\n            <br/>\n");

        }

      out.write("\n        <br/>&nbsp;&nbsp;&nbsp;&nbsp;\n        <button type=\"reset\">Reset Form</button>\n        &nbsp;&nbsp;&nbsp;&nbsp;\n        <button name=\"submit\" value=\"submit\" type=\"submit\">Submit</button>\n     </form>\n    </div>\n");

        if (standalone) {

      out.write("\n            <a href=\"/repository/admin/users.jsp\">Back to User List page</a>\n            <br/>\n            <br/>\n            <a href=\"/repository/admin/index.jsp\">Return to Admin top level</a>\n");

        }
    } catch (IllegalArgumentException e) {
        response.sendError(response.SC_BAD_REQUEST, "Illegal argument: "+e.getMessage());
    } catch (ErrorSendingException e) {
        response.sendError(e.getStatus(), e.getMessage());
    }

      out.write("\n  </body>\n</html>\n");
    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try { out.clearBuffer(); } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
