package org.eaglei.repository;

import org.openrdf.model.URI;

/**
 * Record class describing one "grant" of access to an entity in the repository.
 *
 *
 * Started April, 2010
 *
 * @author Larry Stone
 * @version $Id: $
 */
public class AccessGrant
{
    /** record class for RDF "term" that has URI and label */
    public static class Term
    {
        public URI uri = null;
        public String label = null;

        public Term(URI uri, String label)
        {
            Term.this.uri = uri;
            Term.this.label = (label == null) ? uri.getLocalName() : label;
        }
        public Term(URI uri)
        {
            Term.this.uri = uri;
            Term.this.label = uri.getLocalName();
        }

        /** String rendition is the URI */
        public String toString()
        {
            return uri.toString();
        }
    }

    public Term agent = null;
    public Term agentType = null;
    public Term access = null;

    // true when grant comes from Repo Ontology and is hence immutable.
    // (even if you do change it, the next onto refresh will undo the work)
    public boolean builtin = false;

    /**
     * <p>Constructor for AccessGrant.</p>
     *
     * @param agent a {@link org.openrdf.model.URI} object.
     * @param agentLabel a {@link java.lang.String} object.
     * @param agentType a {@link org.openrdf.model.URI} object.
     * @param agentTypeLabel a {@link java.lang.String} object.
     * @param access a {@link org.openrdf.model.URI} object.
     * @param accessLabel a {@link java.lang.String} object.
     * @param builtin a boolean.
     */
    public AccessGrant(URI agent, String agentLabel, URI agentType, String agentTypeLabel, URI access, String accessLabel, boolean builtin)
    {
        AccessGrant.this.agent = new Term(agent, agentLabel);
        AccessGrant.this.agentType = new Term(agentType, agentTypeLabel);
        AccessGrant.this.access = new Term(access, accessLabel);
        AccessGrant.this.builtin = builtin;
    }
}
