package org.eaglei.repository.status;

/**
 * Superclass for exceptions that get turned into HTTP status codes in
 * the response by a servlet wrapper class.  Since it is a subclass of
 * RuntimeException, methods can throw without bothering to declare it.
 * These are picked up by the RepositoryServlet.service() wrapper
 * and, if possible, turned into status codes in the HTTP response.
 *
 * @author lcs
 * @version $Id: $
 */
public abstract class ErrorSendingException extends RuntimeException
{

    //private static final long serialVersionUID = 1L;

    /**
     * <p>getStatus</p>
     *
     * @return a int.
     */
    public abstract int getStatus();

    /**
     * <p>Constructor for ErrorSendingException.</p>
     *
     * @param message a {@link java.lang.String} object.
     */
    public ErrorSendingException(String message)
    {
        super(message);
    }
    /**
     * <p>Constructor for ErrorSendingException.</p>
     *
     * @param message a {@link java.lang.String} object.
     * @param cause a {@link java.lang.Throwable} object.
     */
    public ErrorSendingException(String message, Throwable cause)
    {
        super(message, cause);
    }
    /**
     * <p>Constructor for ErrorSendingException.</p>
     *
     * @param cause a {@link java.lang.Throwable} object.
     */
    public ErrorSendingException(Throwable cause)
    {
        super(cause);
    }
}
