package org.eaglei.repository.vocabulary;

import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.URI;

/**
 * Constants from the Dublin Core Terms (DCTERMS) namespace.
 * See: http://dublincore.org/ and http://dublincore.org/documents/dcmi-terms/
 *
 * @author Larry Stone
 * @version $Id: $
 */
public class DCTERMS
{
    /** Repository Ontology Namespace Preifx (and URI of Named Graph) */
    public static final String NAMESPACE = "http://purl.org/dc/terms/";

    /** Constant <code>NAMESPACE_URI</code> */
    public static final URI NAMESPACE_URI =  new URIImpl(NAMESPACE);

    /** --------------------- Useful Term URIs */

    public static final URI CREATED =  makeURI("created");
    /** Constant <code>CREATOR</code> */
    public static final URI CREATOR =  makeURI("creator");
    /** Constant <code>CONTRIBUTOR</code> */
    public static final URI CONTRIBUTOR =  makeURI("contributor");
    /** Constant <code>MODIFIED</code> */
    public static final URI MODIFIED =  makeURI("modified");
    /** Constant <code>MEDIATOR</code> */
    public static final URI MEDIATOR =  makeURI("mediator");
    /** Constant <code>SOURCE</code> */
    public static final URI SOURCE =  makeURI("source");
    /** Constant <code>IDENTIFIER</code> */
    public static final URI IDENTIFIER =  makeURI("identifier");
    /** Constant <code>AGENT</code> */
    public static final URI AGENT =  makeURI("Agent");

    /** Constant <code>SOURCE_IDENTIFIER</code> - a made-up URI for
     * an identifier within a source node.
     * DO NOT USE IN RDF, only for e.g. maps.
     */
    public static final URI SOURCE_IDENTIFIER =  makeURI("sourceIdentifier");

    /** Constant <code>SOURCE_MODIFIED</code> - a made-up URI for
     * a modified date within a source node.
     * DO NOT USE IN RDF, only for e.g. maps.
     */
    public static final URI SOURCE_MODIFIED =  makeURI("sourceModified");

    /** Utility to create a URI in the REPO namespace out of the given suffix. */
    private static URI makeURI(String id)
    {
        return new URIImpl(NAMESPACE+id);
    }
}
