/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Access;
import org.eaglei.repository.DataRepository;
import org.eaglei.repository.Role;
import org.eaglei.repository.User;
import org.eaglei.repository.rid.RIDGenerator;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.ForbiddenException;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.vocabulary.FOAF;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.Dataset;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;

/*
 * Exception performing whole class analysis ignored.
 */
public class User {
    private static Logger log = LogManager.getLogger(User.class);
    private static final URI USER_GRAPH = REPO.NG_USERS;
    private static DatasetImpl userDataset = SPARQL.copyDataset((Dataset)SPARQL.InternalGraphs);
    private final URI uri;
    private final String username;
    private String firstName = null;
    private String lastName = null;
    private String mbox = null;
    private Set<Role> roles = new HashSet();
    private boolean dirty = false;
    private static final String userForURIQuery;

    public static Dataset getUserDataset() {
        return userDataset;
    }

    private User(URI uri, String username) {
        this.uri = uri;
        this.username = username;
    }

    public static User findUsername(HttpServletRequest request, String pname) throws ServletException {
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        try {
            log.debug((Object)("Single user SPARQL query = " + userForURIQuery));
            TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, userForURIQuery);
            q.setDataset((Dataset)userDataset);
            q.clearBindings();
            q.setBinding("hasPrincipalName", (Value)new LiteralImpl(pname));
            q.setIncludeInferred(false);
            oneUserHandler h = new oneUserHandler();
            q.evaluate((TupleQueryResultHandler)h);
            log.debug((Object)("User.findUsername(" + pname + ") => " + oneUserHandler.access$000((oneUserHandler)h)));
            return oneUserHandler.access$000((oneUserHandler)h);
        }
        catch (MalformedQueryException e) {
            log.error((Object)("Rejecting malformed query:" + (Object)((Object)e)));
            throw new ServletException((Throwable)e);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
    }

    public static Iterable<User> findAll(HttpServletRequest request) throws ServletException {
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        ArrayList<User> result = new ArrayList<User>();
        try {
            log.debug((Object)("All user SPARQL query = " + userForURIQuery));
            TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, userForURIQuery);
            q.setDataset((Dataset)userDataset);
            q.setIncludeInferred(false);
            q.evaluate((TupleQueryResultHandler)new allUserHandler(result));
        }
        catch (MalformedQueryException e) {
            log.error((Object)("Rejecting malformed query:" + (Object)((Object)e)));
            throw new ServletException((Throwable)e);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        return result;
    }

    public URI getURI() {
        return this.uri;
    }

    public String getUsername() {
        return this.username;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getMbox() {
        return this.mbox;
    }

    public String getTitle() {
        if (this.username != null) {
            String pn = this.getPersonalName();
            return pn.length() > 0 ? this.username + " (" + pn + ")" : this.username;
        }
        return this.uri.getLocalName();
    }

    public String getPersonalName() {
        return this.firstName == null ? (this.lastName == null ? "" : this.lastName) : (this.lastName == null ? this.firstName : this.firstName + " " + this.lastName);
    }

    public Role[] getRoles() {
        return this.roles.toArray(new Role[this.roles.size()]);
    }

    public boolean hasRoleP(Role r) {
        return this.roles.contains(r);
    }

    public boolean hasRoleP(URI ru) {
        for (Role r : this.roles) {
            if (!r.getURI().equals(ru)) continue;
            return true;
        }
        return false;
    }

    public static User create(HttpServletRequest request, String username) throws ServletException {
        return User.create((HttpServletRequest)request, (String)username, (boolean)false);
    }

    public static User create(HttpServletRequest request, String username, boolean skipAccessCheck) throws ServletException {
        if (!skipAccessCheck && !Access.hasPermissionOnUser((HttpServletRequest)request, (String)username)) {
            throw new ForbiddenException("Not allowed to create user: " + username);
        }
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        ValueFactory vf = rc.getValueFactory();
        User result = null;
        try {
            Literal lpname = vf.createLiteral(username);
            if (rc.hasStatement(null, REPO.HAS_PRINCIPAL_NAME, (Value)lpname, false, new Resource[]{REPO.NG_INTERNAL})) {
                throw new BadRequestException("Cannot create user: there is already a repository user with the login principal name (username) \"" + username + "\"");
            }
            result = new User(vf.createURI(DataRepository.getInstance().getDefaultNamespace(), RIDGenerator.getInstance().newID().toString()), username);
            rc.add((Resource)result.uri, RDF.TYPE, (Value)REPO.PERSON, new Resource[]{USER_GRAPH});
            rc.add((Resource)result.uri, RDFS.LABEL, (Value)lpname, new Resource[]{USER_GRAPH});
            rc.add((Resource)result.uri, REPO.HAS_PRINCIPAL_NAME, (Value)lpname, new Resource[]{REPO.NG_INTERNAL});
            log.debug((Object)("create: created new User instance, username=" + username + ", uri=" + result.uri));
            result.dirty = true;
            return result;
        }
        catch (RepositoryException e) {
            log.error((Object)"Failed creating user URI: ", (Throwable)e);
            throw new ServletException("Failed creating user URI: ", (Throwable)e);
        }
    }

    public void setFirstName(HttpServletRequest request, String name) throws ServletException {
        this.firstName = name;
        this.setMetadataInternal(request, FOAF.FIRST_NAME, name);
    }

    public void setLastName(HttpServletRequest request, String name) throws ServletException {
        this.lastName = name;
        this.setMetadataInternal(request, FOAF.SURNAME, name);
    }

    public void setMbox(HttpServletRequest request, String mbox) throws ServletException {
        this.mbox = mbox;
        this.setMetadataInternal(request, FOAF.MBOX, mbox);
    }

    private void setMetadataInternal(HttpServletRequest request, URI property, String newVal) throws ServletException {
        if (!Access.hasPermissionOnUser((HttpServletRequest)request, (String)this.username)) {
            throw new ForbiddenException("Not allowed to modify user: " + this.username);
        }
        try {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            boolean hasProp = rc.hasStatement((Resource)this.uri, property, null, false, new Resource[]{USER_GRAPH});
            boolean hasLabel = rc.hasStatement((Resource)this.uri, RDFS.LABEL, null, false, new Resource[]{USER_GRAPH});
            ValueFactory vf = rc.getValueFactory();
            if (hasProp) {
                rc.remove((Resource)this.uri, property, null, new Resource[]{USER_GRAPH});
            }
            if (newVal != null) {
                rc.add((Resource)this.uri, property, (Value)vf.createLiteral(newVal), new Resource[]{USER_GRAPH});
            }
            String label = this.getTitle();
            log.debug((Object)("Setting User label, uri=" + this.uri + ", label=" + label));
            if (hasLabel) {
                rc.remove((Resource)this.uri, RDFS.LABEL, null, new Resource[]{USER_GRAPH});
            }
            rc.add((Resource)this.uri, RDFS.LABEL, (Value)vf.createLiteral(label), new Resource[]{USER_GRAPH});
            this.dirty = true;
        }
        catch (RepositoryException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void addRole(HttpServletRequest request, URI ru) throws ServletException {
        this.addRole(request, Role.find((HttpServletRequest)request, (URI)ru));
    }

    public void addRole(HttpServletRequest request, Role r) throws ServletException {
        this.addRole(request, r, false);
    }

    public void addRole(HttpServletRequest request, Role r, boolean skipAccessCheck) throws ServletException {
        if (!skipAccessCheck && !Access.isSuperuser((HttpServletRequest)request)) {
            throw new ForbiddenException("Only the administrator is allowed to modify user roles.");
        }
        if (this.hasRoleP(r)) {
            return;
        }
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        try {
            if (this.roles.add(r)) {
                rc.add((Resource)this.uri, REPO.HAS_ROLE, (Value)r.getURI(), new Resource[]{REPO.NG_INTERNAL});
                this.dirty = true;
                log.debug((Object)("Added role: " + r));
            }
        }
        catch (RepositoryException e) {
            log.error((Object)"Failed adding role ", (Throwable)e);
            throw new ServletException("Failed adding role ", (Throwable)e);
        }
    }

    public void removeRole(HttpServletRequest request, URI ru) throws ServletException {
        this.removeRole(request, Role.find((HttpServletRequest)request, (URI)ru));
    }

    public void removeRole(HttpServletRequest request, Role r) throws ServletException {
        if (!Access.isSuperuser((HttpServletRequest)request)) {
            throw new ForbiddenException("Only the administrator is allowed to modify user roles.");
        }
        if (!this.hasRoleP(r)) {
            return;
        }
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        try {
            rc.remove((Resource)this.uri, REPO.HAS_ROLE, (Value)r.getURI(), new Resource[0]);
            this.roles.remove(r);
            this.dirty = true;
            log.debug((Object)("Removed role: " + r));
        }
        catch (RepositoryException e) {
            log.error((Object)"Failed adding role ", (Throwable)e);
            throw new ServletException("Failed removing role ", (Throwable)e);
        }
    }

    public boolean setRoles(HttpServletRequest request, Role[] newRoles) throws ServletException {
        ArrayList<Role> addRoles = new ArrayList<Role>();
        HashSet deleteRoles = new HashSet(this.roles);
        for (Role r : newRoles) {
            if (deleteRoles.contains(r)) {
                deleteRoles.remove(r);
                continue;
            }
            addRoles.add(r);
        }
        if (deleteRoles.isEmpty() && addRoles.isEmpty()) {
            return false;
        }
        for (Role r : deleteRoles) {
            this.removeRole(request, r);
        }
        for (Role r : addRoles) {
            this.addRole(request, r);
        }
        return true;
    }

    public void update(HttpServletRequest request) throws ServletException {
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        try {
            if (this.dirty) {
                rc.commit();
                Access.decacheUser((HttpServletRequest)request, (User)this);
            }
            this.dirty = false;
        }
        catch (RepositoryException e) {
            log.error((Object)("Failed updating user, URI=" + this.uri), (Throwable)e);
            throw new ServletException("Failed updating user, URI=" + this.uri, (Throwable)e);
        }
    }

    protected void finalize() throws Throwable {
        if (this.dirty) {
            log.error((Object)("finalize: about to destroy a User with dirty flag set, CHANGES WILL BE LOST.  Current state: " + this.toString()));
        }
        super.finalize();
    }

    public String toString() {
        String rs = this.roles == null ? "{null}" : Arrays.deepToString(this.getRoles());
        String uu = this.uri == null ? "(not set)" : this.uri.toString();
        return "<#User: uri=" + uu + ", username=" + this.username + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", mbox=" + this.mbox + ", roles=" + rs + ">";
    }

    public boolean equals(Object o) {
        return o instanceof User && this.uri != null && this.uri.equals(((User)o).uri);
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }

    static /* synthetic */ String access$302(User x0, String x1) {
        x0.firstName = x1;
        return x0.firstName;
    }

    static /* synthetic */ String access$402(User x0, String x1) {
        x0.lastName = x1;
        return x0.lastName;
    }

    static /* synthetic */ String access$502(User x0, String x1) {
        x0.mbox = x1;
        return x0.mbox;
    }

    static /* synthetic */ String access$600(User x0) {
        return x0.username;
    }

    static /* synthetic */ Set access$700(User x0) {
        return x0.roles;
    }

    static {
        SPARQL.addGraph((DatasetImpl)userDataset, (URI)USER_GRAPH);
        if (log.isDebugEnabled()) {
            log.debug((Object)("User Dataset = " + Utils.prettyPrint((Dataset)userDataset)));
        }
        userForURIQuery = "SELECT * WHERE { ?uri a <" + REPO.PERSON + "> ; \n" + "<" + REPO.HAS_PRINCIPAL_NAME + "> ?hasPrincipalName .\n" + "  OPTIONAL { ?uri <" + FOAF.FIRST_NAME + "> ?firstName }\n" + "  OPTIONAL { ?uri <" + FOAF.SURNAME + "> ?surname }\n" + "  OPTIONAL { ?uri <" + FOAF.MBOX + "> ?mbox }\n" + "  OPTIONAL { ?uri <" + REPO.HAS_ROLE + "> ?hasRole . ?hasRole <" + RDFS.LABEL + "> ?roleLabel }\n" + " } ORDER BY ?hasPrincipalName";
    }
}

