/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.admin;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.DataRepository;
import org.eaglei.repository.Role;
import org.eaglei.repository.User;
import org.eaglei.repository.admin.AuthAdminBean;

public class AuthAdminBean {
    private static Logger logger = LogManager.getLogger(AuthAdminBean.class);
    private static final String TBL_USERS = "Users";
    private static final String TBL_ROLES = "Roles";
    private static final String ROLE_AUTH = "authenticated".intern();
    private static final String ROLE_SUPER = "superuser";
    private static final String LABEL_ADMIN = "Administrator".intern();
    private static final String LABEL_AUTH = "Authenticated".intern();
    private static final String LABEL_ANONYM = "Anonymous".intern();
    private static final String[] INTERNAL_ROLE_LABELS = new String[]{LABEL_AUTH, LABEL_ANONYM};
    static Iterable<Role> rRoles = null;
    HashMap<String, User> rdfUsers = null;
    User[] sortedUsers = null;
    HashSet<String> rdbUsers = null;
    int rUidx = 0;
    User rUser = null;
    List<String> rURolesAsLabels = null;
    String username = "";
    String password = "";
    String password2 = "";
    String firstName = "";
    String lastName = "";
    String mbox = "";
    String uri = "";
    String backupDir = "";
    String[] cbox = null;
    String remoteUser = "";
    boolean remoteIsSuperuser = false;
    String[] roles = new String[0];
    HttpServletRequest request = null;
    String delimiter = ",";
    ArrayList<String> results = new ArrayList();
    ArrayList<String> messages = new ArrayList();
    ArrayList<String> errors = new ArrayList();

    public AuthAdminBean() {
        logger.setLevel(Level.DEBUG);
    }

    public void setUsername(String value) {
        this.username = value;
    }

    public void setPassword(String value) {
        this.password = value;
    }

    public void setPassword2(String value) {
        this.password2 = value;
    }

    public void setFirstName(String value) {
        this.firstName = value;
    }

    public void setLastName(String value) {
        this.lastName = value;
    }

    public void setMbox(String value) {
        this.mbox = value;
    }

    private void setRUser(User value) {
        this.rUser = value;
    }

    public void setBackupDir(String name) {
        this.backupDir = name;
    }

    public String getBackupDir() {
        return this.backupDir;
    }

    public void setRequest(HttpServletRequest value) {
        this.request = value;
    }

    public void setCbox(String[] values) {
        this.cbox = values;
    }

    public void setRoles(String[] list) {
        logger.debug((Object)("@@@" + Arrays.asList(list).toString()));
        this.roles = list;
    }

    public void setRemoteUser(String rid) {
        this.remoteUser = rid;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public void setRemoteIsSuperuser(boolean flag) {
        this.remoteIsSuperuser = flag;
    }

    public boolean getRemoteIsSuperuser() {
        return this.remoteIsSuperuser;
    }

    public boolean getIsSuperuser() {
        List labels = this.getRU_roleLabelListIntern();
        return labels.contains(LABEL_ADMIN);
    }

    public boolean getShouldBecomeSuperuser() {
        if (this.roles == null) {
            return false;
        }
        String s2 = null;
        for (String s2 : Arrays.asList(this.roles)) {
            if (s2.intern() != LABEL_ADMIN) continue;
            return true;
        }
        return false;
    }

    public boolean isUserActive() {
        return this.getRU_roleLabelListIntern().contains(LABEL_AUTH);
    }

    public boolean isUserActive(User u) {
        Role[] rarr = u.getRoles();
        for (int i = 0; i < rarr.length; ++i) {
            if (!LABEL_AUTH.equals(rarr[i].getLabel())) continue;
            return true;
        }
        return false;
    }

    private boolean isNotInternalRole(String label) {
        return !Arrays.asList(INTERNAL_ROLE_LABELS).contains(label);
    }

    public boolean getUserConfirmed() {
        if (this.cbox == null) {
            return false;
        }
        for (int i = 0; i < this.cbox.length; ++i) {
            if (this.cbox[i] == null || !this.cbox[i].equals("DeleteConfirmed")) continue;
            return true;
        }
        return false;
    }

    public String getSymbol_RoleSuperuser() {
        return ROLE_SUPER;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPassword2() {
        return this.password2;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public ArrayList<String> getAllUsers() {
        HashSet union = new HashSet(this.rdfUsers.keySet());
        union.addAll(this.rdbUsers);
        ArrayList<String> usrlist = new ArrayList<String>(union.size());
        for (String s : union) {
            usrlist.add(s);
        }
        return usrlist;
    }

    public String getAsHTML_RUserFirstName() {
        if (this.rUser != null) {
            return this.rUser.getFirstName() == null ? "" : this.rUser.getFirstName();
        }
        return "";
    }

    public String getAsHTML_RUserLastName() {
        if (this.rUser != null) {
            return this.rUser.getLastName() == null ? "" : this.rUser.getLastName();
        }
        return "";
    }

    public String getAsHTML_RUserMbox() {
        if (this.rUser != null) {
            return this.rUser.getMbox() == null ? "" : this.rUser.getMbox();
        }
        return "";
    }

    private int getDisplayListSize() {
        return 10;
    }

    public ArrayList<String> getBACKUPList() {
        File bckupDir = null;
        try {
            bckupDir = DataRepository.getInstance().getBackupDirectory();
        }
        catch (IOException e) {
            // empty catch block
        }
        ArrayList<String> names = new ArrayList<String>(Arrays.asList(bckupDir.list()));
        return names;
    }

    public void scrollNext() {
        int lgth = this.getDisplayListSize();
        this.rUidx = this.getAllUsers().size() > this.rUidx + lgth ? this.rUidx + lgth : this.rUidx;
    }

    public void scrollPrev() {
        int lgth = this.getDisplayListSize();
        this.rUidx = this.rUidx - lgth > 0 ? this.rUidx - lgth : 0;
    }

    public String getHtmlTable_UserList(int count) {
        String html = "<table border=\"1\"><tr><th>Username</th><th>First name</th><th>Last name</th></tr>\n";
        String uidString = null;
        ArrayList allUserNames = this.getAllUsers();
        Collections.sort(allUserNames);
        int end = this.rUidx + count > allUserNames.size() ? allUserNames.size() : this.rUidx + count;
        logger.debug((Object)("Will create table of " + count + " users starting at " + this.rUidx + " ending at " + end + " of " + allUserNames.size()));
        for (int i = this.rUidx; i < end; ++i) {
            uidString = (String)allUserNames.get(i);
            User u = (User)this.rdfUsers.get(uidString);
            String uidHtmlString = uidString;
            if (this.rdbUsers.contains(uidString)) {
                if (u == null) {
                    uidHtmlString = "<b>" + uidHtmlString + "</b>";
                }
            } else if (u == null) {
                uidHtmlString = "<i>" + uidHtmlString + "</i>";
                logger.debug((Object)("Oops, encoutered userid that isnt in RDF and not inRDB" + uidString));
            } else {
                uidHtmlString = "<del>" + uidHtmlString + "</del>";
            }
            html = html + "<tr><td><a href=\"/repository/admin/updateUserIfc.jsp?username=" + uidString + "\">" + uidHtmlString + "</a></td>";
            if (u != null) {
                html = html + "<td>" + this.ppHtmlName(u.getFirstName()) + "</td>";
                html = html + "<td>" + this.ppHtmlName(u.getLastName()) + "</td></tr>\n";
                continue;
            }
            html = html + "<td>(no rdf data available)</td>";
            html = html + "<td>(no rdf data available)</td></tr>\n";
        }
        html = html + "<tr><th><a href=\"/repository/admin/selectUserIfc.jsp?scroll=prev\">prev</a></th><th/><th><a href=\"/repository/admin/selectUserIfc.jsp?scroll=next\">next</a></th></tr></table>";
        return html;
    }

    private String ppHtmlName(String aString) {
        if (aString == null) {
            return "(not set)";
        }
        if (aString.isEmpty()) {
            return "(not set)";
        }
        return aString;
    }

    public String getHtmlUserRolesCheckboxes(boolean isNew) {
        if (rRoles == null) {
            return "<i>No Roles defined!</i>";
        }
        if (!isNew && this.rUser == null) {
            return "<i>No User set!</i>";
        }
        Role r2 = null;
        String html = "";
        String rLabel = null;
        for (Role r2 : rRoles) {
            rLabel = r2.getLabel();
            if (!this.isNotInternalRole(rLabel)) continue;
            html = html + "<tr> <td align=\"right\">" + rLabel + ":</td> <td align=\"left\">";
            html = html + " <input type=\"checkbox\" ";
            if (!isNew && this.rUser.hasRoleP(r2)) {
                html = html + " checked=\"yes\"";
            }
            html = html + " name=\"roles\" value=\"" + rLabel + "\"";
            if (!this.getRemoteIsSuperuser()) {
                html = html + " disabled=\"true\" ";
            }
            html = html + "/> </td> </tr>";
        }
        return html;
    }

    private boolean isValidPassword(String input) {
        return input.matches("[a-zA-z0-9@#$%?&\\-_]*");
    }

    private boolean isValidUsername(String input) {
        return input.matches("[a-zA-z0-9_]*");
    }

    protected List getRU_roleLabelListIntern() {
        if (this.rUser == null) {
            return null;
        }
        if (this.rURolesAsLabels != null) {
            return this.rURolesAsLabels;
        }
        Role[] rur = this.rUser.getRoles();
        int l = rur.length;
        this.rURolesAsLabels = new ArrayList(l);
        for (int i = 0; i < l; ++i) {
            this.rURolesAsLabels.add(rur[i].getLabel().intern());
        }
        return this.rURolesAsLabels;
    }

    private String[] getRolesIntern() {
        if (this.roles == null) {
            return null;
        }
        int l = this.roles.length;
        String[] r = new String[l];
        for (int i = 0; i < l; ++i) {
            r[i] = this.roles[i].intern();
        }
        return r;
    }

    public String getMbox() {
        return this.mbox;
    }

    public String getURI() {
        if (this.rUser != null) {
            return this.rUser.getURI().toString();
        }
        return "a problem occured!";
    }

    public Iterable<Role> getRepoRoles() {
        return rRoles;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public ArrayList<String> getResults() {
        return this.results;
    }

    public ArrayList<String> getErrors() {
        return this.errors;
    }

    public ArrayList<String> getMessages() {
        return this.messages;
    }

    private void clearMessages() {
        this.messages = new ArrayList();
    }

    private void addMessage(String aString) {
        this.messages.add(aString);
    }

    private boolean executionSuccess() {
        return this.getErrors().isEmpty();
    }

    private boolean errorsOccured() {
        return !this.getErrors().isEmpty();
    }

    private void clearResults() {
        this.results = new ArrayList();
    }

    private void addResult(String aString) {
        this.results.add(aString);
    }

    private void clearErrors() {
        this.errors = new ArrayList();
    }

    private void addError(String aString) {
        this.errors.add(aString);
    }

    private void clear() {
        this.clearErrors();
        this.clearMessages();
        this.clearResults();
    }

    public void resetUserlist() {
        Object rdfUsers = null;
        Object sortedUsers = null;
        Object rdbUsers = null;
        boolean rUidx = false;
        Object rUser = null;
        Object rURolesAsLabels = null;
    }

    public void reset() {
        this.resetCbox();
        this.remoteUser = "";
        this.mbox = "";
        this.lastName = "";
        this.firstName = "";
        this.password2 = "";
        this.password = "";
        this.username = "";
        this.uri = "";
        this.remoteIsSuperuser = false;
        this.roles = new String[0];
        this.rdfUsers = null;
        this.rUser = null;
        this.rURolesAsLabels = null;
    }

    public void resetCbox() {
        this.cbox = null;
    }

    public void initRoles(HttpServletRequest request) {
        if (rRoles == null) {
            try {
                rRoles = Role.findAll((HttpServletRequest)request);
            }
            catch (ServletException e) {
                logger.warn((Object)"Couldn't retrieve Roles!", (Throwable)e);
            }
        }
    }

    public boolean executeAdHocSQL() {
        1 transaction = new /* Unavailable Anonymous Inner Class!! */;
        return this.execute((Transaction)transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postUpdateUser() {
        if (!this.getRemoteIsSuperuser() && !this.remoteUser.equals(this.getUsername())) {
            this.addError("Only a user him or herself or superuser may update user information!");
            return false;
        }
        this.clear();
        if (!this.selectUser()) {
            return false;
        }
        this.clear();
        if (this.getPassword().intern() != this.getPassword2().intern()) {
            this.addError("The passwords do not match!");
            return false;
        }
        if (this.getRepoRoles() == null) {
            this.initRoles(this.getRequest());
        }
        2 transaction = new /* Unavailable Anonymous Inner Class!! */;
        try {
            boolean bl = this.execute((Transaction)transaction);
            return bl;
        }
        finally {
            this.reset();
            this.resetUserlist();
        }
    }

    public boolean postRetireUser() {
        this.clear();
        if (!this.getUserConfirmed()) {
            this.addError("User retirement was not confirmed!");
            return false;
        }
        3 transaction = new /* Unavailable Anonymous Inner Class!! */;
        boolean result = this.execute((Transaction)transaction);
        this.reset();
        this.resetUserlist();
        return result;
    }

    public boolean postCreateUser() {
        this.clear();
        String pwd = this.getPassword().intern();
        if (pwd == null || this.getUsername() == null || pwd.equals("") || this.getUsername().equals("")) {
            this.addError("Neither username nor passwords may be empty!");
            return false;
        }
        if (pwd != this.getPassword2().intern()) {
            this.addError("The passwords do not match!");
            return false;
        }
        if (!this.isValidPassword(pwd)) {
            this.addError("Invalid characters in password!");
            return false;
        }
        String user = this.getUsername();
        if (!this.isValidUsername(user)) {
            this.addError("Invalid characters in username!");
            return false;
        }
        if (this.getRepoRoles() == null) {
            this.initRoles(this.getRequest());
        }
        4 transaction = new /* Unavailable Anonymous Inner Class!! */;
        return this.execute((Transaction)transaction);
    }

    public boolean selectUsers() {
        this.clear();
        5 transaction = new /* Unavailable Anonymous Inner Class!! */;
        return this.execute((Transaction)transaction);
    }

    private void computeRdbUserList() {
        this.rdbUsers = new HashSet();
        String s = null;
        Iterator it = this.getResults().iterator();
        while (it.hasNext()) {
            s = ((String)it.next()).intern();
            this.rdbUsers.add(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean selectUser() {
        this.clear();
        String user = this.getUsername();
        logger.debug((Object)("Selected user: " + user + " remote user: " + this.getRemoteUser() + (this.getRemoteIsSuperuser() ? " <- admin" : " <- not admin")));
        if (!user.equals(this.getRemoteUser()) && !this.getRemoteIsSuperuser()) {
            this.addError("Only a superuser or the user him- or herself may update user information!");
            return false;
        }
        Connection c = null;
        try {
            c = this.checkoutConnection();
            this.sqlFetchRoles(c, user);
            User repoUser = User.findUsername((HttpServletRequest)this.getRequest(), (String)user);
            if (repoUser == null) {
                try {
                    logger.debug((Object)("Didn't find " + user + " in RDF, creating..."));
                    repoUser = User.create((HttpServletRequest)this.getRequest(), (String)user);
                    repoUser.update(this.getRequest());
                    this.resetUserlist();
                }
                catch (ServletException e3) {
                    this.addError("Encountered exception when attempting to add user to RDF: " + e3.getMessage());
                    boolean bl = false;
                    if (c != null) {
                        try {
                            c.close();
                        }
                        catch (SQLException e2) {
                            // empty catch block
                        }
                        c = null;
                    }
                    return bl;
                }
            }
            this.setRUser(repoUser);
            this.initRoles(this.getRequest());
        }
        catch (NamingException e) {
            this.addError(e.toString());
            boolean e3 = false;
            return e3;
        }
        catch (SQLException e) {
            this.addError(e.toString());
            try {
                c.rollback();
            }
            catch (Exception e2) {
                // empty catch block
            }
            boolean e2 = false;
            return e2;
        }
        catch (ServletException e) {
            this.addError("Exception occured: " + e.toString());
            try {
                c.rollback();
            }
            catch (Exception e2) {
                // empty catch block
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (c != null) {
                try {
                    c.close();
                }
                catch (SQLException e) {}
                c = null;
            }
        }
        return true;
    }

    public boolean backupDB() {
        this.clear();
        String bakName = this.getBackupDir();
        if (!bakName.matches("[\\p{Alnum}[\\-/_]]*")) {
            this.addError("Illegal characters in backup folder name! Name may only include alphanumeric characters.");
            return false;
        }
        6 transaction = new /* Unavailable Anonymous Inner Class!! */;
        return this.execute((Transaction)transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restoreDB() {
        this.clear();
        String bakName = this.getBackupDir();
        String bakPath = null;
        try {
            bakPath = DataRepository.getInstance().getBackupDirectory().toString();
        }
        catch (IOException e) {
            logger.debug((Object)("Oops, caught IOException on restore: " + e.getMessage()));
            this.addError(e.getMessage());
            return false;
        }
        String dbURL = "jdbc:derby:db" + File.separator + "eagle-i-users.derby" + ";rollforwardrecoveryFrom=" + bakPath + File.separator + bakName + File.separator + "eagle-i-users.derby";
        logger.debug((Object)("Attempting restore from: " + dbURL));
        Connection c = null;
        try {
            c = DriverManager.getConnection(dbURL);
            this.addMessage("Restored Authentication Database from: " + bakPath + File.separator + bakName);
        }
        catch (SQLException e) {
            logger.debug((Object)("Oops, caught SQLException on restore: " + e.getMessage()));
            this.addError(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                c.close();
            }
            catch (SQLException e) {}
        }
        return true;
    }

    private void sqlExpression(Connection c, String sqlExp) throws SQLException {
        this.execute(c, sqlExp);
    }

    private void sqlBackupDB(Connection c, String backupfilePath) throws SQLException {
        String sqlExp = "CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE('" + backupfilePath + "')";
        this.execute(c, sqlExp);
    }

    private void sqlFetchUsers(Connection c) throws SQLException {
        String sqlExp = "SELECT Username FROM Users";
        this.executeAndFetch(c, sqlExp);
    }

    private void sqlFetchUser(Connection c, String usr) throws SQLException {
        String sqlExp = "SELECT Username FROM Roles WHERE Username='" + usr + "'";
        this.executeAndFetch(c, sqlExp);
    }

    private void sqlFetchRoles(Connection c, String usr) throws SQLException {
        String sqlExp = "SELECT Rolename FROM Roles WHERE Username='" + usr + "'";
        this.executeAndFetch(c, sqlExp);
    }

    private void sqlCreateUser(Connection c, String usr, String pwd) throws SQLException {
        String sqlExp = "INSERT INTO Users VALUES ('" + usr + "', '" + pwd + "')";
        this.execute(c, sqlExp);
    }

    private void sqlChangePassword(Connection c, String usr, String pwd) throws SQLException {
        String sqlExp = "UPDATE Users SET Password='" + pwd + "' WHERE Username='" + usr + "'";
        this.execute(c, sqlExp);
    }

    private void sqlDeleteUser(Connection c, String usr) throws SQLException {
        String sqlExp = "DELETE FROM Users WHERE Username = '" + usr + "'";
        this.execute(c, sqlExp);
    }

    private void sqlDeleteUserFromRoles(Connection c, String usr) throws SQLException {
        String sqlExp = "DELETE FROM Roles WHERE Username = '" + usr + "'";
        this.execute(c, sqlExp);
    }

    private void sqlFetchPasswordForUser(Connection c, String usr) throws SQLException {
        String sqlExpr = "SELECT Password FROM Users WHERE Username='" + usr + "'";
        this.executeAndFetch(c, sqlExpr);
    }

    private void sqlGrantAuth(Connection c, String usr) throws SQLException {
        this.execute(c, this.sqlExprGrantRole(ROLE_AUTH, usr));
    }

    private void sqlGrantSuper(Connection c, String usr) throws SQLException {
        this.execute(c, this.sqlExprGrantRole(ROLE_SUPER, usr));
    }

    private String sqlExprGrantRole(String role, String usr) {
        return "INSERT INTO Roles VALUES ('" + role + "', '" + usr + "')";
    }

    private void sqlRevokeAuth(Connection c, String usr) throws SQLException {
        this.execute(c, this.sqlExprRevokeRole(ROLE_AUTH, usr));
    }

    private void sqlRevokeSuper(Connection c, String usr) throws SQLException {
        this.execute(c, this.sqlExprRevokeRole(ROLE_SUPER, usr));
    }

    private String sqlExprRevokeRole(String role, String usr) {
        return "DELETE FROM Roles WHERE (rolename = '" + role + "') AND (Username = '" + usr + "')";
    }

    private Connection checkoutConnection() throws NamingException, SQLException {
        InitialContext initContext = new InitialContext();
        Context envContext = (Context)initContext.lookup("java:/comp/env");
        DataSource ds = (DataSource)envContext.lookup("jdbc/eaglei");
        Connection c = ds.getConnection();
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execute(Transaction transaction) {
        this.clear();
        Connection c = null;
        try {
            c = this.checkoutConnection();
            c.setAutoCommit(false);
            transaction.execute(c);
            c.commit();
        }
        catch (NamingException e) {
            this.addError(e.toString());
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            this.addError(e.toString());
            try {
                c.rollback();
            }
            catch (Exception e2) {
                logger.warn((Object)("Caught exception on rolling back:" + e2));
            }
            boolean e2 = false;
            return e2;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.addError(e.toString());
            try {
                c.rollback();
            }
            catch (Exception e2) {
                logger.warn((Object)("Caught exception on rolling back:" + e2));
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (c != null) {
                try {
                    c.close();
                }
                catch (SQLException e) {
                    logger.warn((Object)("Caught exception on rolling back:" + e));
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAndFetch(Connection conn, String sqlExpression) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        logger.debug((Object)("Executing for resulttuple: \"" + sqlExpression + "\""));
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sqlExpression);
            this.fetch(rs);
            rs.close();
            stmt.close();
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.warn((Object)("Caught exception on closing statement:" + e));
                }
                stmt = null;
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warn((Object)("Caught exception on closing result set:" + e));
                }
                rs = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int execute(Connection conn, String sqlExpression) throws SQLException {
        Statement stmt = null;
        int rc = 0;
        logger.debug((Object)("Executing for update: \"" + sqlExpression + "\""));
        try {
            stmt = conn.createStatement();
            rc = stmt.executeUpdate(sqlExpression);
            logger.debug((Object)(stmt.getUpdateCount() + " rows updated!"));
            stmt.close();
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.warn((Object)("Caught exception on closing statement:" + e));
                }
            }
        }
        return rc;
    }

    private void fetch(ResultSet rs) throws SQLException {
        Object row;
        ResultSetMetaData rsMetaData = rs.getMetaData();
        int noc = rsMetaData.getColumnCount();
        logger.debug((Object)("result set column count=" + noc));
        for (int i = 1; i <= noc; ++i) {
            row = new String[noc];
            logger.trace((Object)"column MetaData ");
            logger.trace((Object)("column number " + i));
            logger.trace((Object)rsMetaData.getColumnDisplaySize(i));
            logger.trace((Object)rsMetaData.getColumnLabel(i));
            logger.trace((Object)rsMetaData.getColumnName(i));
            rsMetaData.getColumnType(i);
            logger.trace((Object)rsMetaData.getColumnType(i));
        }
        ArrayList result = new ArrayList();
        while (rs.next()) {
            row = new StringBuffer();
            String field = null;
            for (int i = 1; i <= noc; ++i) {
                field = rs.getString(i);
                if (i > 1) {
                    ((StringBuffer)row).append(this.delimiter);
                }
                ((StringBuffer)row).append(field);
            }
            this.addResult(((StringBuffer)row).toString());
        }
    }

    static /* synthetic */ void access$000(AuthAdminBean x0, Connection x1, String x2) throws SQLException {
        x0.sqlExpression(x1, x2);
    }

    static /* synthetic */ void access$100(AuthAdminBean x0, Connection x1, String x2, String x3) throws SQLException {
        x0.sqlChangePassword(x1, x2, x3);
    }

    static /* synthetic */ void access$200(AuthAdminBean x0, String x1) {
        x0.addMessage(x1);
    }

    static /* synthetic */ void access$300(AuthAdminBean x0, Connection x1, String x2) throws SQLException {
        x0.sqlGrantSuper(x1, x2);
    }

    static /* synthetic */ void access$400(AuthAdminBean x0, Connection x1, String x2) throws SQLException {
        x0.sqlRevokeSuper(x1, x2);
    }

    static /* synthetic */ Logger access$500() {
        return logger;
    }

    static /* synthetic */ void access$600(AuthAdminBean x0, String x1) {
        x0.addError(x1);
    }

    static /* synthetic */ String[] access$700(AuthAdminBean x0) {
        return x0.getRolesIntern();
    }

    static /* synthetic */ boolean access$800(AuthAdminBean x0, String x1) {
        return x0.isNotInternalRole(x1);
    }

    static /* synthetic */ void access$900(AuthAdminBean x0, Connection x1, String x2) throws SQLException {
        x0.sqlDeleteUserFromRoles(x1, x2);
    }

    static /* synthetic */ void access$1000(AuthAdminBean x0, Connection x1, String x2) throws SQLException {
        x0.sqlDeleteUser(x1, x2);
    }

    static /* synthetic */ void access$1100(AuthAdminBean x0, Connection x1, String x2, String x3) throws SQLException {
        x0.sqlCreateUser(x1, x2, x3);
    }

    static /* synthetic */ void access$1200(AuthAdminBean x0, Connection x1, String x2) throws SQLException {
        x0.sqlGrantAuth(x1, x2);
    }

    static /* synthetic */ void access$1300(AuthAdminBean x0, Connection x1) throws SQLException {
        x0.sqlFetchUsers(x1);
    }

    static /* synthetic */ void access$1400(AuthAdminBean x0) {
        x0.computeRdbUserList();
    }

    static /* synthetic */ void access$1500(AuthAdminBean x0, Connection x1, String x2) throws SQLException {
        x0.sqlBackupDB(x1, x2);
    }
}

