/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.format;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.helpers.RDFHandlerBase;

public class RDFNQuadsWriter
extends RDFHandlerBase
implements RDFWriter {
    public static final String NQUADS_MIME = "text/rdf+nquads";
    private BufferedWriter out = null;
    public static final boolean normalizeBNodes = false;
    public static final RDFFormat NQUADS = new RDFFormat("NQuads", "text/rdf+nquads", Charset.defaultCharset(), "nq", false, true);

    public RDFFormat getRDFFormat() {
        return NQUADS;
    }

    public RDFNQuadsWriter(Writer out) {
        this.out = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
    }

    public void handleStatement(Statement s) throws RDFHandlerException {
        try {
            Resource ctx = s.getContext();
            if (ctx == null) {
                this.out.write("<>");
            } else {
                this.handleResource(ctx);
            }
            this.out.write(" ");
            this.handleResource(s.getSubject());
            this.out.write(" <");
            this.out.write(s.getPredicate().toString());
            this.out.write("> ");
            Value so = s.getObject();
            if (so instanceof Literal) {
                String ls = so.toString();
                Matcher m = Pattern.compile("[\n\r]").matcher(ls);
                int lastEnd = 0;
                while (m.find()) {
                    char c;
                    int len1 = m.start() - lastEnd;
                    if (len1 > 0) {
                        this.out.write(ls, lastEnd, len1);
                    }
                    this.out.write((c = ls.charAt(m.start())) == '\n' ? "\\n" : "\\r");
                    lastEnd = m.end();
                }
                this.out.write(ls, lastEnd, ls.length() - lastEnd);
            } else {
                this.handleResource((Resource)so);
            }
            this.out.write(" .");
            this.out.newLine();
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    private void handleResource(Resource ss) throws IOException {
        if (ss instanceof URI) {
            this.out.write("<");
            this.out.write(ss.toString());
            this.out.write(">");
        } else {
            this.out.write("_:" + ((BNode)ss).getID());
        }
    }

    public void endRDF() throws RDFHandlerException {
        try {
            this.out.close();
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }
}

