/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Access;
import org.eaglei.repository.AccessGrant;
import org.eaglei.repository.NamedGraph;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.BooleanLiteralImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.query.impl.MapBindingSet;

public class ListGraphs
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(ListGraphs.class);

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        String format = request.getParameter("format");
        NamedGraph.Type type = (NamedGraph.Type)Utils.parseKeywordArg(NamedGraph.Type.class, (String)request.getParameter("type"), (String)"type", (boolean)false, null);
        Collection ngs = NamedGraph.findAll((HttpServletRequest)request);
        Object[] nga = ngs.toArray(new NamedGraph[ngs.size()]);
        Arrays.sort(nga);
        ArrayList<MapBindingSet> result = new ArrayList<MapBindingSet>();
        boolean superuser = Access.isSuperuser((HttpServletRequest)request);
        for (Object ng : nga) {
            NamedGraph.Type ngt = ng.getType();
            if (type != null && !type.equals((Object)ngt)) continue;
            MapBindingSet nbs = new MapBindingSet(7);
            URI uri = ng.getName();
            nbs.addBinding("namedGraphURI", (Value)uri);
            nbs.addBinding("namedGraphLabel", (Value)new LiteralImpl(ng.getLabel()));
            if (ngt != null) {
                nbs.addBinding("typeURI", (Value)ngt.uri);
                nbs.addBinding("typeLabel", (Value)new LiteralImpl(ngt.getTitle()));
            }
            if (superuser) {
                nbs.addBinding("read", (Value)BooleanLiteralImpl.TRUE);
                nbs.addBinding("add", (Value)BooleanLiteralImpl.TRUE);
                nbs.addBinding("remove", (Value)BooleanLiteralImpl.TRUE);
            } else {
                BooleanLiteralImpl hasRead = BooleanLiteralImpl.FALSE;
                BooleanLiteralImpl hasRemove = BooleanLiteralImpl.FALSE;
                BooleanLiteralImpl hasAdd = BooleanLiteralImpl.FALSE;
                for (AccessGrant g : Access.getGrants((HttpServletRequest)request, (URI)uri, (boolean)true)) {
                    if (g.access.uri.equals(REPO.HAS_READ_ACCESS)) {
                        hasRead = BooleanLiteralImpl.TRUE;
                        continue;
                    }
                    if (g.access.uri.equals(REPO.HAS_ADD_ACCESS)) {
                        hasAdd = BooleanLiteralImpl.TRUE;
                        continue;
                    }
                    if (!g.access.uri.equals(REPO.HAS_REMOVE_ACCESS)) continue;
                    hasRemove = BooleanLiteralImpl.TRUE;
                }
                nbs.addBinding("read", (Value)hasRead);
                nbs.addBinding("add", (Value)hasAdd);
                nbs.addBinding("remove", (Value)hasRemove);
            }
            result.add(nbs);
        }
        SPARQL.sendTupleQueryResults((HttpServletRequest)request, (HttpServletResponse)response, (String)format, result);
    }
}

