/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Access;
import org.eaglei.repository.DataRepository;
import org.eaglei.repository.NamedGraph;
import org.eaglei.repository.Provenance;
import org.eaglei.repository.servlet.Model;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.ForbiddenException;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.vocabulary.DATAMODEL;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.query.impl.MapBindingSet;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class Model
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(Model.class);
    private static OntModel ontModel = null;

    public void init() {
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        ontModel = (OntModel)ctx.getBean("jenaOntModel", OntModel.class);
    }

    private String getJarTopLevelPath() {
        return DataRepository.getInstance().getConfigurationProperty("eaglei.repository.datamodel.file", "ero.owl");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        if (request.getParameter("action") != null) {
            throw new BadRequestException("The 'action' argument is not allowed in the GET method, use POST.");
        }
        String format = request.getParameter("format");
        try {
            String availableJarVersion;
            String availableModelVersion;
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            String loadedVersion = this.getLoadedVersionInfo(rc);
            if (loadedVersion == null) {
                loadedVersion = "(not loaded or not in ontology)";
            }
            if ((availableModelVersion = this.getAvailableModelVersionInfo()) == null) {
                availableModelVersion = "(failed or not in ontology)";
            }
            if ((availableJarVersion = this.getAvailableJarVersionInfo()) == null) {
                availableJarVersion = "(failed or not in Jar or War)";
            }
            ArrayList<MapBindingSet> results = new ArrayList<MapBindingSet>(1);
            MapBindingSet bs = new MapBindingSet(2);
            ValueFactory vf = rc.getValueFactory();
            bs.addBinding("loaded", (Value)vf.createLiteral(loadedVersion));
            bs.addBinding("availableJar", (Value)vf.createLiteral(availableJarVersion));
            bs.addBinding("availableModel", (Value)vf.createLiteral(availableModelVersion));
            results.add(bs);
            SPARQL.sendTupleQueryResults((HttpServletRequest)request, (HttpServletResponse)response, (String)format, results);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block26: {
            boolean force = false;
            long count = 0L;
            long modTime = -1L;
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            String action = request.getParameter("action");
            String source = request.getParameter("source");
            URI context = DATAMODEL.GRAPH_NAME_URI;
            if (action == null) {
                throw new BadRequestException("Missing required argument 'action'");
            }
            if (action.equals("load")) {
                force = true;
            } else if (!action.equals("update")) {
                throw new BadRequestException("Argument action must be one of: 'load', 'update'");
            }
            if (source == null) {
                throw new BadRequestException("Missing required argument 'source'");
            }
            if (!Access.hasPermission((HttpServletRequest)request, (Resource)context, (Access)Access.ADD) || !Access.hasPermission((HttpServletRequest)request, (Resource)context, (Access)Access.REMOVE)) {
                throw new ForbiddenException("User is not permitted to replace the data model ontology graph");
            }
            if (source.equals("jar") && !force) {
                throw new BadRequestException("You must force-load the data model from the jar source since version is not available, although it SHOULD be the same as for the model source.");
            }
            try {
                boolean created = rc.size(new Resource[]{context}) == 0L;
                String loadedVersion = this.getLoadedVersionInfo(rc);
                String availableVersion = this.getAvailableModelVersionInfo();
                String sourceLoaded = null;
                if (availableVersion == null) {
                    throw new ServletException("Failed to get version of available data model ontology, perhaps failed to load ontology.");
                }
                if (force || loadedVersion == null || !loadedVersion.equals(availableVersion)) {
                    if (log.isDebugEnabled()) {
                        if (force) {
                            log.debug((Object)"Forced reload of data model ontology.");
                        } else {
                            log.debug((Object)("Updating data model ontology: loaded=" + loadedVersion + ", available=" + availableVersion));
                        }
                    }
                    rc.clear(new Resource[]{context});
                    if (source.equals("model")) {
                        count += (long)this.convertOntModel(rc, ontModel, context);
                        ExtendedIterator mi = ontModel.listSubModels(true);
                        rc.commit();
                        try {
                            while (mi.hasNext()) {
                                count += (long)this.convertOntModel(rc, (OntModel)mi.next(), context);
                            }
                        }
                        finally {
                            mi.close();
                        }
                        sourceLoaded = DATAMODEL.GRAPH_NAME_URI.toString();
                        log.info((Object)("Copied " + count + " statements from Data Model Ontology."));
                    } else if (source.equals("jar")) {
                        String toplevel = this.getJarTopLevelPath();
                        String jar = this.getDataModelJarSpec(toplevel);
                        rc.commit();
                        modTime = this.loadDataModelFromJar(rc, context, toplevel, jar);
                        sourceLoaded = jar;
                    } else {
                        throw new BadRequestException("Argument source must be one of: 'model', 'jar'");
                    }
                    NamedGraph ng = NamedGraph.find((HttpServletRequest)request, (URI)context, (boolean)true);
                    ng.setType(request, NamedGraph.Type.ontology);
                    ng.setLabel(request, "eagle-i Data Model Ontology");
                    Date now = new Date();
                    Provenance p = new Provenance(context);
                    if (created) {
                        p.setCreated(request, now);
                    } else {
                        p.setModified(request, now);
                    }
                    Date sourceModified = null;
                    if (modTime != -1L) {
                        sourceModified = new Date(modTime);
                    }
                    p.setSource(request, sourceLoaded, sourceModified);
                    rc.commit();
                    response.setStatus(201);
                    break block26;
                }
                response.setStatus(200);
            }
            catch (OpenRDFException e) {
                log.error((Object)e);
                throw new ServletException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int convertOntModel(RepositoryConnection rc, OntModel om, URI context) throws RepositoryException {
        ValueFactory vf = rc.getValueFactory();
        int count = 0;
        StmtIterator si = om.getBaseModel().listStatements();
        try {
            while (si.hasNext()) {
                com.hp.hpl.jena.rdf.model.Statement js = si.nextStatement();
                Resource subject = this.convertResource(js.getSubject(), vf);
                URI predicate = vf.createURI(js.getPredicate().getURI());
                Resource object = null;
                RDFNode jv = js.getObject();
                if (jv.isResource()) {
                    object = this.convertResource((com.hp.hpl.jena.rdf.model.Resource)jv, vf);
                } else if (jv.isLiteral()) {
                    Literal jvl = (Literal)jv;
                    String lang = jvl.getLanguage();
                    String dt = jvl.getDatatypeURI();
                    object = dt != null ? vf.createLiteral(jvl.getLexicalForm(), vf.createURI(dt)) : (lang != null ? vf.createLiteral(jvl.getLexicalForm(), lang) : vf.createLiteral(jvl.getLexicalForm()));
                } else {
                    log.error((Object)("Skipping unknown Value object (class=" + jv.getClass().getName() + "): " + jv));
                }
                rc.add(subject, predicate, (Value)object, new Resource[]{context});
                ++count;
            }
        }
        finally {
            si.close();
        }
        return count;
    }

    private Resource convertResource(com.hp.hpl.jena.rdf.model.Resource jr, ValueFactory vf) {
        if (jr.isURIResource()) {
            return vf.createURI(jr.getURI());
        }
        String id = jr.getId().getLabelString();
        return vf.createBNode(id);
    }

    private String getAvailableJarVersionInfo() throws ServletException, IOException {
        String toplevel = this.getJarTopLevelPath();
        String jarURLspec = this.getDataModelJarSpec(toplevel);
        log.debug((Object)("Gettings maven version from jar at: " + jarURLspec));
        ZipInputStream jis = null;
        try {
            JarEntry je;
            URL jarURL = new URL(jarURLspec);
            Properties pp = new Properties();
            jis = new JarInputStream(jarURL.openStream());
            while ((je = ((JarInputStream)jis).getNextJarEntry()) != null) {
                if (je.isDirectory()) continue;
                String fn = je.getName();
                if (!fn.startsWith("META-INF/maven/") || !fn.endsWith("/pom.properties")) continue;
                log.debug((Object)("..found POM properties: " + fn));
                pp.load(jis);
                if (pp.containsKey("version")) {
                    String string = pp.getProperty("version");
                    return string;
                }
                log.warn((Object)("Cannot find 'version' property in Data Model jar, jar=" + jarURL + ", entry=" + fn));
                String string = null;
                return string;
            }
        }
        catch (MalformedURLException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        finally {
            if (jis != null) {
                jis.close();
            }
        }
        log.warn((Object)("Cannot find Maven properties file in Data Model jar, jar=" + jarURLspec));
        return null;
    }

    private String getAvailableModelVersionInfo() {
        Ontology oo = ontModel.getOntology("http://purl.org/eagle-i/app-ext/");
        if (oo != null) {
            return oo.getVersionInfo();
        }
        log.warn((Object)"Failed to find ontology in OntModel, uri=http://purl.obolibrary.org/obo/ero.owl");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLoadedVersionInfo(RepositoryConnection rc) throws RepositoryException {
        RepositoryResult rr = rc.getStatements((Resource)DATAMODEL.APP_EXT_NAMESPACE_URI, OWL.VERSIONINFO, null, false, new Resource[]{DATAMODEL.GRAPH_NAME_URI});
        try {
            Value vers;
            if (rr.hasNext() && (vers = ((Statement)rr.next()).getObject()) instanceof org.openrdf.model.Literal) {
                String string = ((org.openrdf.model.Literal)vers).getLabel();
                return string;
            }
        }
        finally {
            rr.close();
        }
        return null;
    }

    private String getDataModelJarSpec(String toplevel) throws ServletException {
        URL ero = this.getClass().getClassLoader().getResource(toplevel);
        if (ero == null) {
            throw new ServletException("Cannot load data model OWL, since the top-level file \"" + toplevel + "\"  is not available as a resource.  Check your configuration.");
        }
        String eros = ero.toString();
        if (eros.startsWith("jar:")) {
            Pattern ep = Pattern.compile("jar:([^!]+)!/" + Pattern.quote(toplevel));
            log.debug((Object)("Groveling jar URL with pattern=\"" + ep.pattern() + "\""));
            Matcher em = ep.matcher(eros);
            if (em.matches()) {
                String jarURLspec = em.group(1);
                log.debug((Object)("Got jar URL = " + jarURLspec));
                return jarURLspec;
            }
            log.warn((Object)("Failed matching pattern=\"" + ep.pattern() + "\" against owl resource URL=" + eros));
            throw new ServletException("Failed to extract jar's URL from resource (see log for details): " + eros);
        }
        log.warn((Object)("Cannot load data model OWL, URL for the toplevel file is NOT in Jar scheme: " + eros));
        throw new ServletException("Cannot load data model OWL, URL for the toplevel file is NOT in Jar scheme: " + eros);
    }

    private long loadDataModelFromJar(RepositoryConnection rc, URI context, String toplevel, String jarURLspec) throws ServletException, IOException {
        long result = -1L;
        log.info((Object)("Loading data model from jar at: " + jarURLspec));
        ZipInputStream jis = null;
        File tmpFile = File.createTempFile("datamodel", ".txt", (File)this.getServletConfig().getServletContext().getAttribute("javax.servlet.context.tempdir"));
        AppendHandler ah = new AppendHandler(this, Rio.createWriter((RDFFormat)RDFFormat.NTRIPLES, (Writer)new FileWriter(tmpFile)));
        RDFParser op = Rio.createParser((RDFFormat)RDFFormat.RDFXML);
        op.setRDFHandler((RDFHandler)ah);
        try {
            JarEntry je;
            URL jarURL = new URL(jarURLspec);
            jis = new JarInputStream(jarURL.openStream());
            while ((je = ((JarInputStream)jis).getNextJarEntry()) != null) {
                if (je.isDirectory()) continue;
                String fn = je.getName();
                if (fn.endsWith(".owl")) {
                    log.info((Object)("..Adding OWL statements from jar entry: " + fn));
                    try {
                        op.parse((InputStream)new UnclosableInputStream(this, (InputStream)jis, null), "");
                    }
                    catch (RDFParseException e) {
                        log.warn((Object)("Skipping file=" + fn + ", failed parsing: " + (Object)((Object)e)));
                    }
                    if (!fn.equals(toplevel) && !fn.equals("/" + toplevel)) continue;
                    result = je.getTime();
                    log.debug((Object)("Found toplevel entry, setting mod time = " + result));
                    continue;
                }
                log.info((Object)("..Skipping non-OWL jar file = " + fn));
            }
            ah.reallyEndRDF();
            ah = null;
            rc.add(tmpFile, "", RDFFormat.NTRIPLES, new Resource[]{context});
            rc.commit();
            log.info((Object)("Loaded merged data model ontology, size = " + String.valueOf(rc.size(new Resource[]{context})) + " statements."));
        }
        catch (MalformedURLException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        finally {
            if (jis != null) {
                jis.close();
            }
            if (ah != null) {
                try {
                    ah.reallyEndRDF();
                }
                catch (RDFHandlerException ie) {
                    log.warn((Object)("Failed closing merged ontology file: " + (Object)((Object)ie)));
                }
            }
            tmpFile.delete();
        }
        return result;
    }
}

