<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
<%--
   - Admin - present a list of named graphs, the name-or-URI of each
   -  is a link to the page to edit its ACL.
  --%>
<%@ page import="java.util.Arrays" %>
<%@ page import="java.util.Collection" %>
<%@ page import="org.apache.commons.lang.StringEscapeUtils" %>
<%@ page import="org.openrdf.model.URI" %>
<%@ page import="org.openrdf.repository.RepositoryConnection" %>
<%@ page import="org.eaglei.repository.NamedGraph" %>
<%@ page import="org.eaglei.repository.servlet.WithRepositoryConnection" %>
<%@ page import="org.eaglei.repository.status.ErrorSendingException" %>

  <head>
    <meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
    <title>Eagle-I Data Repository Admin - Named Graphs</title>
  </head>
<%
    try {
%>
  <body>
    <%@ include file="/repository/admin/banner.jsp" %>
    <h2>Named Graphs Administration</h2>
    <table border="1">
    <tr><th colspan="2">Graph Name or URI</th><th>Content Type</th><th>&nbsp;Size*&nbsp;</th><th>Public?</th></tr>
<%
    RepositoryConnection rc = WithRepositoryConnection.get(request);
    Collection<NamedGraph> ngs = NamedGraph.findAll(request);
    NamedGraph nga[] = ngs.toArray(new NamedGraph[ngs.size()]);
    Arrays.sort(nga);
    for (NamedGraph ng : nga) {
        String ngl = StringEscapeUtils.escapeHtml(ng.getLabel());
 %>
      <tr><td><a href="/repository/admin/editGraph.jsp?name=<%= ng.getName() %>">
                <%= ngl %>
              </a></td>
          <td><form style="margin: 0pt;" action="/repository/admin/editGrants.jsp">
                <input type="hidden" name="type" value="Named Graph" />
                <input type="hidden" name="label" value="<%= ngl %>"/>
                <input type="hidden" name="uri" value="<%= ng.getName() %>"/>
                <button type="submit">Edit ACL</button></form></td>
          <td><%= ng.isManaged() ?
                  StringEscapeUtils.escapeHtml(ng.getTypeLabel())  :
                  "<div align=\"center\"><i>(Undocumented)<i></div>"
               %></td>
          <td align="right" style="padding: 0em .4em;"><tt><%= String.format("%,d",rc.size(ng.getName())) %></tt></td>
          <td align="center"><%= String.valueOf(ng.isAnonymousReadable()) %></td>
      </tr>
<%
    }
%>
</table>
    <i>Click on name to edit named graph properties.</i>
    <br/>
    <i><b>(*)</b> "Size" is a count of the <u>explicit</u> statements only, inferred ones are omitted.</i>
    <br/>
    <br/>
    <a href="/repository/admin/index.jsp">Return to Admin top level</a>
  </body>
<%
    // see "try" at start of body tag.
    } catch (ErrorSendingException e) {
        response.sendError(e.getStatus(), e.getMessage());
    }
%>
</html>
             
