package org.eaglei.repository.auth;

import javax.servlet.ServletException;

/**
 * Outline of instance in pluggable authentication user database
 *
 * @see AuthUserTomcat
 * @author Larry Stone
 * Started March 2011
 */
public interface AuthUser
{
    /**
     * Getter for username
     * @return the login name
     */
    String getUsername();

    /**
     * Getter for password
     * @return the password or null if not used by this implementation
     */
    String getPassword();

    /**
     * Getter for Administrator state
     * @return true if this is an Administrator user (Superuesr)
     */
    boolean isSuperuser();

    /** Setter for password
     *
     * @param s new value, must be a string if this implementation uses passwords
     */
    void setPassword(String s);

    /**
     * Setter for isSuperuser flag
     * @param b new value, true means superuser
     */
    void setIsSuperuser(boolean b);

    /**
     * authentication test
     * @param s credential value, i.e. password
     * @return true if credential matches
     */
    boolean authenticate(String s);

    /**
     * Obliterate all record of this authentication user
     */
    void delete();

    /**
     * Create entry for this model of a user in the auth database
     */
    void create();

    /**
     * Commit all changes to java model objects into actual DB
     * (actual effect varies with implementation)
     * @throws ServletException
     */
    void commit()
        throws ServletException;
}
