package org.eaglei.repository.model.workflow;

import org.openrdf.model.URI;
import org.openrdf.model.Value;
import javax.servlet.http.HttpServletRequest;

/**
 * Interface for workflow action callbacks.
 * @author lcs
 */
public interface WorkflowAction
{
    /**
     * This method gets called when an instance undergoes a workflow transition.
     * The parameter "param" comes from the transition itself.
     * @param request
     * @param instance
     * @param param
     * @throws Exception
     */
    void onTransition(HttpServletRequest request, URI instance, Value param) throws Exception;
}
