package org.eaglei.repository.servlet.admin;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletException;

import org.apache.log4j.Logger;
import org.apache.log4j.LogManager;

import org.openrdf.model.URI;

import org.eaglei.repository.auth.Authentication;
import org.eaglei.repository.model.workflow.WorkflowTransition;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.ForbiddenException;

/**
 *
 * Method: POST only.
 *
 *   REQUIRED ARGS:
 *    uri = URI of the object  (except on create)
 *    action = create | update | delete
 *   optional:
 *    label   (requred to create)
 *    comment
 *    inital
 *    final
 *    tAction
 *    tActionParameter
 *    order
 *
 * @author Larry Stone
 * Started March 2011
 */
public class UpdateTransition extends RepositoryServlet
{
    private static Logger log = LogManager.getLogger(UpdateTransition.class);

    // allowable values for Action arg
    public enum Action { create, update, delete };

    // args to pass through to JSP
    private static final String PASS_THRU_ARGS[] = {};

    /** {@inheritDoc} */
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
        throws ServletException, java.io.IOException
    {
        request.setCharacterEncoding("UTF-8");
        Action action = (Action)getParameterAsKeyword(request, "action", Action.class, null, true);
        URI uri = getParameterAsURI(request, "uri", false);
        String label = getParameter(request, "label", false);
        String comment = getParameter(request, "comment", false);
        URI workspace = getParameterAsURI(request, "workspace", false);
        URI initialState = getParameterAsURI(request, "initial", false);
        URI finalState = getParameterAsURI(request, "final", false);
        String tAction = getParameter(request, "tAction", false);
        String tActionParameter = getParameter(request, "tActionParameter", false);
        String order = getParameter(request, "order", false);

        if (!Authentication.isSuperuser(request))
            throw new ForbiddenException("This service is only for use by administrators.");

        // sanity-check args
        if (uri == null && action != Action.create) {
            throw new BadRequestException("Value for 'uri' is required when action is not create.");
        }
        if ((action == Action.create || action == Action.update)) {
            if (label == null)
                throw new BadRequestException("Value for 'label' is required when creating or updating.");
            if (finalState == null)
                throw new BadRequestException("Value for 'final' is required when creating or updating.");
            if (initialState == null)
                throw new BadRequestException("Value for 'initial' is required when creating or updating.");
        }

        String message = null;
        WorkflowTransition result = null;
        if (action == Action.delete) {
            result = WorkflowTransition.find(request, uri);
            result.delete(request);
            message = "Deleted transition \""+result.getLabel()+"\"";

        } else {
            if (action == Action.create) {
                result = WorkflowTransition.create(request, uri, label, comment, initialState, finalState);
                uri = result.getURI();
                message = "Created a new Transition.";
            } else if (action == Action.update) {
                result = WorkflowTransition.find(request, uri);
                result.setLabel(request, label);
                result.setComment(request, comment);
                result.setInitial(request, initialState);
                result.setFinal(request, finalState);
                message = "Modified transition \""+result.getLabel()+"\"";
            }
            result.setOrder(request, order);
            result.setWorkspace(request, workspace);
            result.setAction(request, tAction);
            result.setActionParameter(request, tActionParameter);
        }
        if (result != null)
            result.commit(request);

        redirectToJSP(request, response, message, PASS_THRU_ARGS, "uri", uri.stringValue());
    }
}
